/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Point;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;

public class DesktopPane
extends JDesktopPane {
    public DesktopPane() {
        this.setBackground(Color.gray);
    }

    public ProcessDesignFrame getCurrentProcessDesignFrame() {
        JInternalFrame frame = this.getSelectedFrame();
        if (frame instanceof ProcessDesignFrame) {
            return (ProcessDesignFrame)frame;
        }
        return null;
    }

    public ProcessDesignFrame getEditingProcessDesignFrame(Element e) {
        if (!(e instanceof ProcessElement)) {
            return null;
        }
        JInternalFrame[] frames = this.getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);
        ProcessDesignFrame frame = null;
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof ProcessDesignFrame) || !((ProcessDesignFrame)frames[i]).isEditingProcess((ProcessElement)e)) continue;
            frame = (ProcessDesignFrame)frames[i];
            break;
        }
        return frame;
    }

    public ProcessDesignFrame createProcessDesignFrame(Element e) {
        if (!(e instanceof ProcessElement)) {
            return null;
        }
        ProcessDesignFrame frame = new ProcessDesignFrame((ProcessElement)e);
        Point p = this.getNextLocation();
        frame.setLocation(p);
        this.add(frame);
        frame.setVisible(true);
        frame.initialize();
        try {
            frame.setSelected(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        frame.toFront();
        return frame;
    }

    public void updateAllFrame() {
        JInternalFrame[] frames = this.getAllFrames();
        for (int i = frames.length - 1; i >= 0; --i) {
            ProcessDesignFrame frame;
            if (!(frames[i] instanceof ProcessDesignFrame) || !(frame = (ProcessDesignFrame)frames[i]).isVisible()) continue;
            frame.getView().getProcessFlowView().inspectSelectedActivity(false);
            frame.getView().updateUI();
        }
    }

    public void closeAllFrame() {
        JInternalFrame[] frames = this.getAllFrames();
        for (int i = frames.length - 1; i >= 0; --i) {
            frames[i].setVisible(false);
            frames[i].dispose();
        }
    }

    public Point getNextLocation() {
        JInternalFrame[] frames = this.getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);
        if (frames == null) {
            return new Point(0, 0);
        }
        int count = frames.length;
        return new Point(25 * (count % 6), 25 * (count % 6));
    }
}

