/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.impl.ApplicationElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ParameterElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ParticipantElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ProcessElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.VariableElementImpl;

public class ElementFactory {
    static ElementFactory singleton = new ElementFactory();

    public static ElementFactory getInstance() {
        return singleton;
    }

    private ElementFactory() {
    }

    public Element createElement(String elementKind) {
        if (elementKind == null) {
            return null;
        }
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        String initialName = rm.getResource("Common.noname");
        if (elementKind.equals("variable")) {
            return new VariableElementImpl(initialName);
        }
        if (elementKind.equals("participant")) {
            return new ParticipantElementImpl(initialName);
        }
        if (elementKind.equals("application")) {
            return new ApplicationElementImpl(initialName);
        }
        if (elementKind.equals("process")) {
            return new ProcessElementImpl(initialName);
        }
        if (elementKind.equals("parameter")) {
            return new ParameterElementImpl(initialName);
        }
        return null;
    }
}

