/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.ElementFactory;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.dnd.ElementContext;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;

public class ElementList
extends JScrollPane
implements ChangeElementListener {
    private static final int GRID_W = 80;
    private static final int GRID_H = 70;
    private static final Dimension MINIMUM_VIEW_SIZE = new Dimension(80, 70);
    private static final Font VIEW_FONT = new Font("MonoSpaced", 0, 10);
    private static final Point CURSOR_POINT = new Point(16, 16);
    private JPopupMenu popup;
    private JMenuItem popNew;
    private JMenuItem popInspect;
    private JMenuItem popDelete;
    private IconView view;
    private String elementType;
    private List elements;
    private int selectedIndex;

    public ElementList(List elems, String type) {
        this.elementType = type;
        this.elements = elems;
        this.selectedIndex = -1;
        InspectorDialog.addChangeElementListener(this.elementType, this);
        this.buildPopupMenu();
        this.view = new IconView();
        Dimension size = new Dimension(MINIMUM_VIEW_SIZE);
        this.view.setPreferredSize(size);
        this.view.setSize(size);
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(21);
        this.setViewportView(this.view);
    }

    private void buildPopupMenu() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.popup = new JPopupMenu();
        this.popNew = new JMenuItem(rm.getResource("ElementList.menu.new"));
        this.popInspect = new JMenuItem(rm.getResource("ElementList.menu.inspect"));
        this.popDelete = new JMenuItem(rm.getResource("ElementList.menu.delete"));
        this.popNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ElementList.this.executeNewElement();
            }
        });
        this.popInspect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ElementList.this.executeInspectElement();
            }
        });
        this.popDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ElementList.this.executeDeleteElement();
            }
        });
        this.popup.add(this.popNew);
        this.popup.add(this.popInspect);
        this.popup.add(this.popDelete);
    }

    public void recalc() {
        Dimension size = this.getSize();
        int count = 1;
        if (this.elements != null) {
            count += this.elements.size();
        }
        size.width = count * 80;
        size.height = 70;
        this.view.setPreferredSize(size);
        this.view.setSize(size);
        this.view.repaint();
    }

    private void executeNewElement() {
        ElementFactory factory = ElementFactory.getInstance();
        Element newElem = factory.createElement(this.elementType);
        if (newElem == null) {
            return;
        }
        this.elements.add(newElem);
        this.selectedIndex = this.elements.size() - 1;
        this.recalc();
    }

    private void executeInspectElement() {
        Element elem = this.getSelectedElement();
        if (elem == null) {
            return;
        }
        if (this.elementType == "process") {
            DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
            ProcessDesignFrame frame = desktop.getEditingProcessDesignFrame(elem);
            if (frame == null) {
                frame = desktop.createProcessDesignFrame(elem);
            }
            WorkflowDesignerManager.getMainFrame().getToolbox().setSelectedIndex(0);
        } else {
            InspectorDialog.showDialog((Component)this, elem);
        }
    }

    private void executeDeleteElement() {
        DesktopPane desktop;
        Element elem = this.getSelectedElement();
        if (elem == null) {
            return;
        }
        PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
        if (pkg.isUsed(elem)) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            DialogUtilities.showWarning(rm.getResource("message.warn.0104"));
            return;
        }
        if (this.elementType == "process") {
            if (((ProcessElement)elem).getAccessLevel() == 1) {
                ResourceManager rm = WorkflowDesignerManager.getResourceManager();
                DialogUtilities.showWarning(rm.getResource("message.warn.0001"));
                return;
            }
            desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
            ProcessDesignFrame frame = desktop.getEditingProcessDesignFrame(elem);
            if (frame != null) {
                frame.setVisible(false);
                desktop.remove(frame);
                frame.dispose();
            }
        }
        this.elements.remove(elem);
        desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
        desktop.updateAllFrame();
        this.recalc();
    }

    public void setElements(List list) {
        this.elements = list;
        this.selectedIndex = -1;
        this.recalc();
    }

    private Element getElement(Point p) {
        if (this.elements == null) {
            return null;
        }
        if (p.x < 0) {
            return null;
        }
        if (p.y < 0 || p.y >= 70) {
            return null;
        }
        int ix = p.x / 80;
        int count = this.elements.size();
        if (ix >= count) {
            return null;
        }
        return (Element)this.elements.get(ix);
    }

    private Element getSelectedElement() {
        if (this.elements == null) {
            return null;
        }
        if (this.selectedIndex < 0) {
            return null;
        }
        int count = this.elements.size();
        if (this.selectedIndex >= count) {
            return null;
        }
        return (Element)this.elements.get(this.selectedIndex);
    }

    public void elementChanged(Element elem) {
        this.repaint();
    }

    public void elementDropped(Element elem) {
    }

    private class IconView
    extends JComponent
    implements MouseListener,
    MouseMotionListener,
    DragGestureListener {
        public IconView() {
            Dimension size = new Dimension(MINIMUM_VIEW_SIZE);
            this.setPreferredSize(MINIMUM_VIEW_SIZE);
            this.setMinimumSize(MINIMUM_VIEW_SIZE);
            this.setSize(MINIMUM_VIEW_SIZE);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            DragSource dragSource = new DragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        }

        public void paintComponent(Graphics g) {
            g.setFont(VIEW_FONT);
            Dimension size = this.getSize();
            g.setColor(Color.white);
            g.fillRect(0, 0, size.width, size.height);
            this.paintElements(g);
            g.dispose();
        }

        private void paintElements(Graphics g) {
            if (ElementList.this.elements == null) {
                return;
            }
            int count = ElementList.this.elements.size();
            int sindex = -1;
            Element selement = null;
            for (int i = 0; i < count; ++i) {
                Element child = (Element)ElementList.this.elements.get(i);
                if (i != ElementList.this.selectedIndex) {
                    this.paintElement(g, child, i, 0);
                    continue;
                }
                sindex = i;
                selement = child;
            }
            if (selement != null) {
                this.paintSelectedElement(g, selement, sindex, 0);
            }
        }

        private void paintElement(Graphics g, Element elem, int px, int py) {
            int lineW;
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            Graphics2D g2 = (Graphics2D)g;
            Shape shape = g2.getClip();
            int x = 80 * px;
            int y = 70 * py;
            int w = 80;
            int h = 70;
            Icon icon = IconManager.getIcon(ElementList.this.elementType);
            int iconW = icon.getIconWidth();
            int iconH = icon.getIconHeight();
            int iconX = x + (w - iconW) / 2;
            int iconY = y + 2;
            icon.paintIcon(this, g2, iconX, iconY);
            FontMetrics metrics = g.getFontMetrics();
            int fontH = metrics.getHeight();
            int descent = metrics.getDescent();
            g.setColor(Color.black);
            String n = elem.getName();
            if (StringUtils.checkNull(n)) {
                n = rm.getResource("ElementList.noname");
            }
            if ((lineW = metrics.stringWidth(n)) <= w - 4) {
                int dx = x + (w - lineW) / 2;
                int dy = y + 2 + iconH + fontH - descent;
                g2.drawString(n, dx, dy);
            } else {
                int dotW = metrics.stringWidth("...");
                int dx = x + 2;
                int cy = y + 2 + iconH;
                int dw = w - (dotW + 4);
                g2.clipRect(dx, cy, dw, fontH);
                int dy = cy + fontH - descent;
                g2.drawString(n, dx, dy);
                g2.setClip(shape);
                dx = x + w - (dotW + 1);
                g2.clipRect(dx, cy, dotW, fontH);
                g2.drawString("...", dx, dy);
            }
            g2.setClip(shape);
        }

        private void paintSelectedElement(Graphics g, Element elem, int px, int py) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            if (ElementList.this.selectedIndex < 0) {
                return;
            }
            Dimension size = this.getSize();
            int x = 80 * px;
            int y = 70 * py;
            int w = 80;
            int h = 70;
            Icon selectedIcon = IconManager.getIcon(ElementList.this.elementType + "-s");
            int iconW = selectedIcon.getIconWidth();
            int iconH = selectedIcon.getIconHeight();
            int iconX = x + (w - iconW) / 2;
            int iconY = y + 2;
            selectedIcon.paintIcon(this, g, iconX, iconY);
            FontMetrics metrics = g.getFontMetrics();
            int fontH = metrics.getHeight();
            int descent = metrics.getDescent();
            String n = elem.getName();
            if (StringUtils.checkNull(n)) {
                n = rm.getResource("ElementList.noname");
            }
            int lineW = metrics.stringWidth(n);
            int dx = x + (w - lineW) / 2;
            int dy = y + 2 + iconH;
            if (dx < 0) {
                dx = 0;
            }
            g.setColor(SystemColor.textHighlight);
            g.fillRect(dx, dy, lineW, fontH);
            dy = dy + fontH - descent;
            g.setColor(SystemColor.textHighlightText);
            g.drawString(n, dx, dy);
        }

        private void recalcSelection(Point p) {
            if (p.x < 0) {
                ElementList.this.selectedIndex = -1;
            } else if (p.y < 0 || p.y >= 70) {
                ElementList.this.selectedIndex = -1;
            } else {
                ElementList.this.selectedIndex = p.x / 80;
            }
            this.repaint();
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            this.recalcSelection(e.getDragOrigin());
            Element elem = ElementList.this.getSelectedElement();
            if (elem == null) {
                return;
            }
            ElementContext t = new ElementContext(elem, ElementList.this.elementType);
            String iconName = ElementList.this.elementType + "-cur";
            ImageIcon icon = (ImageIcon)IconManager.getIcon(iconName);
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), CURSOR_POINT, ElementList.this.elementType);
            e.startDrag(cursor, t);
        }

        public void mouseClicked(MouseEvent e) {
            this.recalcSelection(e.getPoint());
            if (ElementList.this.selectedIndex < 0) {
                return;
            }
            if (e.getClickCount() >= 2) {
                ElementList.this.executeInspectElement();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() || e.getModifiers() == 8 || e.getModifiers() == 4) {
                this.recalcSelection(e.getPoint());
                Element elem = ElementList.this.getSelectedElement();
                if (elem == null) {
                    ElementList.this.popInspect.setEnabled(false);
                    ElementList.this.popDelete.setEnabled(false);
                } else {
                    ElementList.this.popInspect.setEnabled(true);
                    ElementList.this.popDelete.setEnabled(true);
                }
                ElementList.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            Element elem = ElementList.this.getElement(e.getPoint());
            if (elem == null) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(elem.getTooltipText(rm));
            }
        }
    }
}

