/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.expression.ConditionalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.workflow.xpdl.ConditionalExpressionDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.wfmc.x2002.xpdl10.ActivitiesDocument;
import org.wfmc.x2002.xpdl10.ActivityDocument;
import org.wfmc.x2002.xpdl10.ActualParametersDocument;
import org.wfmc.x2002.xpdl10.ApplicationDocument;
import org.wfmc.x2002.xpdl10.ApplicationsDocument;
import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.BlockActivityDocument;
import org.wfmc.x2002.xpdl10.ConditionDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataFieldsDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributesDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;
import org.wfmc.x2002.xpdl10.FormalParametersDocument;
import org.wfmc.x2002.xpdl10.ImplementationDocument;
import org.wfmc.x2002.xpdl10.PackageDocument;
import org.wfmc.x2002.xpdl10.PackageHeaderDocument;
import org.wfmc.x2002.xpdl10.ParticipantDocument;
import org.wfmc.x2002.xpdl10.ParticipantTypeDocument;
import org.wfmc.x2002.xpdl10.ParticipantsDocument;
import org.wfmc.x2002.xpdl10.ProcessHeaderDocument;
import org.wfmc.x2002.xpdl10.RedefinableHeaderDocument;
import org.wfmc.x2002.xpdl10.ResponsiblesDocument;
import org.wfmc.x2002.xpdl10.SubFlowDocument;
import org.wfmc.x2002.xpdl10.ToolDocument;
import org.wfmc.x2002.xpdl10.TransitionDocument;
import org.wfmc.x2002.xpdl10.TransitionsDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessesDocument;

public class PackageConverter {
    private static final String EMPTY_FLOW = "/jp/co/argo21/nautica/tool/wfd/resources/empty.xpdl";
    private static final PackageConverter singleton = new PackageConverter();

    public static PackageConverter getInstance() {
        return singleton;
    }

    private PackageConverter() {
    }

    public PackageDocument convert(PackageElement elem) throws XmlException, IOException {
        if (elem == null) {
            return null;
        }
        PackageDocument doc = this.getEmptyDocument();
        PackageDocument.Package pkg = doc.getPackage();
        this.convertPackageElement(pkg, elem);
        return doc;
    }

    private PackageDocument getEmptyDocument() throws XmlException, IOException {
        InputStream in = this.getClass().getResourceAsStream(EMPTY_FLOW);
        XmlOptions opts = new XmlOptions();
        opts.setCharacterEncoding("utf-8");
        PackageDocument doc = PackageDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
        in.close();
        return doc;
    }

    private void convertPackageElement(PackageDocument.Package pkg, PackageElement elem) throws XmlException {
        List procs;
        List vars;
        List parts;
        pkg.setId(elem.getID());
        pkg.setName(elem.getName());
        PackageHeaderDocument.PackageHeader phd = pkg.getPackageHeader();
        phd.setDescription(elem.getDescription());
        phd.setCreated(elem.getCreatedDate());
        RedefinableHeaderDocument.RedefinableHeader rhd = pkg.addNewRedefinableHeader();
        rhd.setAuthor(elem.getAuthor());
        rhd.setVersion(elem.getVersion());
        List apps = elem.getApplications();
        if (apps.size() > 0) {
            ApplicationsDocument.Applications applications = pkg.addNewApplications();
            Iterator it = apps.iterator();
            while (it.hasNext()) {
                ApplicationElement e = (ApplicationElement)it.next();
                this.convertApplicationElement(applications.addNewApplication(), e);
            }
        }
        if ((parts = elem.getParticipants()).size() > 0) {
            ParticipantsDocument.Participants participants = pkg.addNewParticipants();
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                ParticipantElement e = (ParticipantElement)it.next();
                this.convertParticipantElement(participants.addNewParticipant(), e);
            }
        }
        if ((vars = elem.getVariables()).size() > 0) {
            DataFieldsDocument.DataFields dataFields = pkg.addNewDataFields();
            Iterator it = vars.iterator();
            while (it.hasNext()) {
                VariableElement e = (VariableElement)it.next();
                this.convertVariableElement(dataFields.addNewDataField(), e);
            }
        }
        if ((procs = elem.getProcesses()).size() > 0) {
            WorkflowProcessesDocument.WorkflowProcesses processes = pkg.addNewWorkflowProcesses();
            Iterator it = procs.iterator();
            while (it.hasNext()) {
                ProcessElement e = (ProcessElement)it.next();
                this.convertProcessElement(processes.addNewWorkflowProcess(), e);
            }
        }
    }

    private void convertApplicationElement(ApplicationDocument.Application app, ApplicationElement elem) throws XmlException {
        app.setId(elem.getID());
        app.setName(elem.getName());
        app.setDescription(elem.getDescription());
        List params = elem.getParameters();
        if (params.size() > 0) {
            FormalParametersDocument.FormalParameters parameters = app.addNewFormalParameters();
            Iterator it = params.iterator();
            while (it.hasNext()) {
                ParameterElement e = (ParameterElement)it.next();
                this.convertParameterElement(parameters.addNewFormalParameter(), e);
            }
        }
    }

    private void convertParticipantElement(ParticipantDocument.Participant part, ParticipantElement elem) throws XmlException {
        part.setId(elem.getID());
        part.setName(elem.getName());
        part.setDescription(elem.getDescription());
        ParticipantTypeDocument.ParticipantType ptype = part.addNewParticipantType();
        ParticipantTypeDocument.ParticipantType.Type.Enum type = ParticipantTypeDocument.ParticipantType.Type.Enum.forInt((int)elem.getType());
        ptype.setType(type);
    }

    private void convertVariableElement(DataFieldDocument.DataField data, VariableElement elem) throws XmlException {
        data.setId(elem.getID());
        data.setName(elem.getName());
        data.setDescription(elem.getDescription());
        data.setInitialValue(elem.getInitialValue());
        if (elem.isInitialized()) {
            DataTypeDocument.DataType dtype = data.addNewDataType();
            BasicTypeDocument.BasicType basictype = dtype.addNewBasicType();
            BasicTypeDocument.BasicType.Type.Enum type = BasicTypeDocument.BasicType.Type.Enum.forInt((int)elem.getType());
            basictype.setType(type);
        }
    }

    private void convertProcessElement(WorkflowProcessDocument.WorkflowProcess proc, ProcessElement elem) throws XmlException {
        List trs;
        List acts;
        proc.setId(elem.getID());
        proc.setName(elem.getName());
        WorkflowProcessDocument.WorkflowProcess.AccessLevel.Enum level = WorkflowProcessDocument.WorkflowProcess.AccessLevel.Enum.forInt((int)elem.getAccessLevel());
        proc.setAccessLevel(level);
        ProcessHeaderDocument.ProcessHeader ph = proc.addNewProcessHeader();
        ph.setDescription(elem.getDescription());
        ProcessHeaderDocument.ProcessHeader.DurationUnit.Enum unit = ProcessHeaderDocument.ProcessHeader.DurationUnit.Enum.forInt((int)elem.getDurationUnit());
        ph.setDurationUnit(unit);
        ph.setLimit("" + elem.getLimit());
        List rsps = elem.getResponsibles();
        if (rsps.size() > 0) {
            RedefinableHeaderDocument.RedefinableHeader rhd = proc.addNewRedefinableHeader();
            ResponsiblesDocument.Responsibles responsibles = rhd.addNewResponsibles();
            Iterator it = rsps.iterator();
            while (it.hasNext()) {
                String r = (String)it.next();
                responsibles.addResponsible(r);
            }
        }
        ExtendedAttributesDocument.ExtendedAttributes eas = proc.addNewExtendedAttributes();
        ExtendedAttributeDocument.ExtendedAttribute ea1 = eas.addNewExtendedAttribute();
        ea1.setName("LOGICAL_WIDTH");
        ea1.setValue("" + elem.getLogicalWidth());
        ExtendedAttributeDocument.ExtendedAttribute ea2 = eas.addNewExtendedAttribute();
        ea2.setName("LOGICAL_HEIGHT");
        ea2.setValue("" + elem.getLogicalHeight());
        List params = elem.getParameters();
        if (params.size() > 0) {
            FormalParametersDocument.FormalParameters parameters = proc.addNewFormalParameters();
            Iterator it = params.iterator();
            while (it.hasNext()) {
                ParameterElement e = (ParameterElement)it.next();
                this.convertParameterElement(parameters.addNewFormalParameter(), e);
            }
        }
        if ((acts = elem.getActivities()).size() > 0) {
            ActivitiesDocument.Activities activities = proc.addNewActivities();
            Iterator it = acts.iterator();
            while (it.hasNext()) {
                ActivityElement e = (ActivityElement)it.next();
                this.convertActivityElement(activities.addNewActivity(), e);
            }
        }
        if ((trs = elem.getTransitions()).size() > 0) {
            TransitionsDocument.Transitions transitions = proc.addNewTransitions();
            Iterator it = trs.iterator();
            while (it.hasNext()) {
                TransitionElement e = (TransitionElement)it.next();
                this.convertTransitionElement(transitions.addNewTransition(), e);
            }
        }
    }

    private void convertParameterElement(FormalParameterDocument.FormalParameter param, ParameterElement elem) throws XmlException {
        param.setId(elem.getID());
        param.setDescription(elem.getDescription());
        FormalParameterDocument.FormalParameter.Mode.Enum mode = FormalParameterDocument.FormalParameter.Mode.Enum.forInt((int)elem.getMode());
        param.setMode(mode);
        DataTypeDocument.DataType dtype = param.addNewDataType();
        BasicTypeDocument.BasicType basictype = dtype.addNewBasicType();
        BasicTypeDocument.BasicType.Type.Enum type = BasicTypeDocument.BasicType.Type.Enum.forInt((int)elem.getType());
        basictype.setType(type);
    }

    private void convertActivityElement(ActivityDocument.Activity act, ActivityElement elem) throws XmlException {
        String engineName;
        String abid;
        act.setId(elem.getID());
        act.setName(elem.getName());
        act.setDescription(elem.getDescription());
        String type = elem.getType();
        if (type.equals("CONCUR_START") || type.equals("CONCUR_END")) {
            BlockActivityDocument.BlockActivity blockActivity = act.addNewBlockActivity();
            blockActivity.setBlockId(elem.getBlockID());
        }
        if (type.equals("INTERACTIVE") || type.equals("AUTOMATIC") || type.equals("SUBPROCESS")) {
            ImplementationDocument.Implementation imp = act.addNewImplementation();
            act.setLimit("" + elem.getLimit());
            if (type.equals("INTERACTIVE")) {
                act.setPerformer(elem.getPerformerID());
            } else if (type.equals("AUTOMATIC")) {
                act.setPerformer(elem.getPerformerID());
                ToolDocument.Tool tool = imp.addNewTool();
                tool.setId(elem.getApplicationID());
                List appParams = elem.getApplicationParameters();
                if (appParams.size() > 0) {
                    ActualParametersDocument.ActualParameters actualParameters = tool.addNewActualParameters();
                    Iterator it = appParams.iterator();
                    while (it.hasNext()) {
                        String p = (String)it.next();
                        actualParameters.addActualParameter(p);
                    }
                }
            } else if (type.equals("SUBPROCESS")) {
                SubFlowDocument.SubFlow sf = imp.addNewSubFlow();
                sf.setId(elem.getSubprocessID());
                SubFlowDocument.SubFlow.Execution.Enum sync = SubFlowDocument.SubFlow.Execution.Enum.forInt((int)elem.getExecution());
                sf.setExecution(sync);
                List procParams = elem.getSubprocessParameters();
                if (procParams.size() > 0) {
                    ActualParametersDocument.ActualParameters actualParameters = sf.addNewActualParameters();
                    Iterator it = procParams.iterator();
                    while (it.hasNext()) {
                        String p = (String)it.next();
                        actualParameters.addActualParameter(p);
                    }
                }
            }
        }
        ExtendedAttributesDocument.ExtendedAttributes eas = act.addNewExtendedAttributes();
        ExtendedAttributeDocument.ExtendedAttribute ea1 = eas.addNewExtendedAttribute();
        ea1.setName("LOGICAL_X");
        ea1.setValue("" + elem.getLogicalX());
        ExtendedAttributeDocument.ExtendedAttribute ea2 = eas.addNewExtendedAttribute();
        ea2.setName("LOGICAL_Y");
        ea2.setValue("" + elem.getLogicalY());
        ExtendedAttributeDocument.ExtendedAttribute ea3 = eas.addNewExtendedAttribute();
        ea3.setName("ACTIVITY_TYPE");
        ea3.setValue(type);
        String pbid = elem.getParentBID();
        if (!StringUtils.checkNull(pbid)) {
            ExtendedAttributeDocument.ExtendedAttribute ea4 = eas.addNewExtendedAttribute();
            ea4.setName("PARENT_BID");
            ea4.setValue(pbid);
        }
        if (!StringUtils.checkNull(abid = elem.getAffiliateBID())) {
            ExtendedAttributeDocument.ExtendedAttribute ea5 = eas.addNewExtendedAttribute();
            ea5.setName("AFFILIATE_BID");
            ea5.setValue(abid);
        }
        if (!StringUtils.checkNull(engineName = elem.getEngineName())) {
            ExtendedAttributeDocument.ExtendedAttribute ea6 = eas.addNewExtendedAttribute();
            ea6.setName("ENGINE_NANE");
            ea6.setValue(engineName);
        }
    }

    private void convertTransitionElement(TransitionDocument.Transition tr, TransitionElement elem) throws XmlException {
        tr.setId(elem.getID());
        tr.setName(elem.getName());
        tr.setDescription(elem.getDescription());
        tr.setFrom(elem.getSource().getID());
        tr.setTo(elem.getDestination().getID());
        Expression cond = elem.getCondition();
        if (cond != null) {
            ConditionDocument.Condition condition = tr.addNewCondition();
            ConditionDocument.Condition.Type.Enum type = ConditionDocument.Condition.Type.Enum.forInt((int)elem.getType());
            if (type.equals(ConditionDocument.Condition.Type.CONDITION) && cond != null) {
                ConditionalExpression exp = new ConditionalExpression(cond);
                ConditionalExpressionDocument cDoc = ConditionalExpressionDocument.Factory.newInstance();
                ConditionalExpressionDocument.ConditionalExpression ce = cDoc.addNewConditionalExpression();
                exp.saveTo((XmlObject)ce);
                condition.set((XmlObject)cDoc);
            }
            condition.setType(type);
        }
    }
}

