/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.ValidationResult;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

public class PackageValidator {
    private static final int E = 0;
    private static final int W = 1;
    private static final PackageValidator singleton = new PackageValidator();

    public static PackageValidator getInstance() {
        return singleton;
    }

    private PackageValidator() {
    }

    private void addResult(List results, int kind, Element elem, String msgid) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        ValidationResult r = new ValidationResult(kind, elem, rm.getResource(msgid));
        results.add(r);
    }

    public List validate(PackageElement elem) {
        ArrayList results = new ArrayList();
        if (elem == null) {
            this.addResult(results, 0, elem, "message.error.0101");
            return results;
        }
        this.validatePackageElement(elem, results);
        if (results.size() == 0) {
            return null;
        }
        return results;
    }

    private void validatePackageElement(PackageElement elem, List results) {
        List procs;
        List vars;
        List parts;
        List apps;
        if (StringUtils.checkNull(elem.getName())) {
            this.addResult(results, 0, elem, "message.error.0102");
        }
        if ((apps = elem.getApplications()).size() > 0) {
            Iterator it = apps.iterator();
            while (it.hasNext()) {
                ApplicationElement e = (ApplicationElement)it.next();
                this.validateApplicationElement(e, results);
                this.validateSameName(e, apps, results);
            }
        }
        if ((parts = elem.getParticipants()).size() > 0) {
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                ParticipantElement e = (ParticipantElement)it.next();
                this.validateParticipantElement(e, results);
                this.validateSameName(e, parts, results);
            }
        }
        if ((vars = elem.getVariables()).size() > 0) {
            Iterator it = vars.iterator();
            while (it.hasNext()) {
                VariableElement e = (VariableElement)it.next();
                this.validateVariableElement(e, results);
                this.validateSameName(e, vars, results);
            }
        }
        if ((procs = elem.getProcesses()).size() > 0) {
            Iterator it = procs.iterator();
            while (it.hasNext()) {
                ProcessElement e = (ProcessElement)it.next();
                this.validateProcessElement(elem, e, results);
                this.validateSameName(e, procs, results);
            }
        }
    }

    private void validateApplicationElement(ApplicationElement elem, List results) {
        List params;
        if (StringUtils.checkNull(elem.getName())) {
            this.addResult(results, 0, elem, "message.error.0103");
        }
        if ((params = elem.getParameters()).size() > 0) {
            Iterator it = params.iterator();
            while (it.hasNext()) {
                ParameterElement e = (ParameterElement)it.next();
                this.validateParameterElement(e, results);
            }
        }
    }

    private void validateParticipantElement(ParticipantElement elem, List results) {
        if (StringUtils.checkNull(elem.getName())) {
            this.addResult(results, 0, elem, "message.error.0104");
        }
    }

    private void validateVariableElement(VariableElement elem, List results) {
        if (StringUtils.checkNull(elem.getName())) {
            this.addResult(results, 0, elem, "message.error.0105");
        }
        if (StringUtils.checkNull(elem.getInitialValue())) {
            this.addResult(results, 1, elem, "message.warn.0101");
        }
    }

    private void validateProcessElement(PackageElement pkg, ProcessElement elem, List results) {
        Element e;
        Iterator it;
        List params;
        List rsps;
        if (StringUtils.checkNull(elem.getName())) {
            this.addResult(results, 0, elem, "message.error.0106");
        }
        if ((rsps = elem.getResponsibles()).size() == 0) {
            this.addResult(results, 1, elem, "message.warn.0102");
        }
        if ((params = elem.getParameters()).size() > 0) {
            Iterator it2 = params.iterator();
            while (it2.hasNext()) {
                ParameterElement e2 = (ParameterElement)it2.next();
                this.validateParameterElement(e2, results);
            }
        }
        List acts = elem.getActivities();
        List trs = elem.getTransitions();
        if (acts.size() > 0) {
            it = acts.iterator();
            while (it.hasNext()) {
                e = (ActivityElement)it.next();
                this.validateTransition((ActivityElement)e, trs, results);
                this.validateActivityElement(pkg, (ActivityElement)e, results);
            }
        }
        if (trs.size() > 0) {
            it = trs.iterator();
            while (it.hasNext()) {
                e = (TransitionElement)it.next();
                this.validateTransitionElement((TransitionElement)e, results);
            }
        }
    }

    private void validateParameterElement(ParameterElement elem, List results) {
    }

    private void validateActivityElement(PackageElement pkg, ActivityElement elem, List results) {
        block8: {
            String type;
            block9: {
                block7: {
                    if (StringUtils.checkNull(elem.getName())) {
                        this.addResult(results, 0, elem, "message.error.0107");
                    }
                    if (!(type = elem.getType()).equals("INTERACTIVE")) break block7;
                    if (!StringUtils.checkNull(elem.getPerformerID())) break block8;
                    this.addResult(results, 1, elem, "message.error.0119");
                    break block8;
                }
                if (!type.equals("AUTOMATIC")) break block9;
                if (StringUtils.checkNull(elem.getPerformerID())) {
                    this.addResult(results, 1, elem, "message.error.0119");
                }
                if (!StringUtils.checkNull(elem.getApplicationID())) break block8;
                this.addResult(results, 0, elem, "message.error.0108");
                this.validateApplication(elem, pkg.getApplications(), results);
                List params = elem.getApplicationParameters();
                if (params.size() > 0) {
                    Iterator it = params.iterator();
                    while (it.hasNext()) {
                        String aid = (String)it.next();
                        this.validateActualParams(elem, aid, pkg.getVariables(), results);
                    }
                }
                break block8;
            }
            if (type.equals("SUBPROCESS") && StringUtils.checkNull(elem.getSubprocessID())) {
                this.addResult(results, 0, elem, "message.error.0109");
                this.validateSubprocess(elem, pkg.getProcesses(), results);
                List params = elem.getSubprocessParameters();
                if (params.size() > 0) {
                    Iterator it = params.iterator();
                    while (it.hasNext()) {
                        String pid = (String)it.next();
                        this.validateActualParams(elem, pid, pkg.getVariables(), results);
                    }
                }
            }
        }
    }

    private void validateTransitionElement(TransitionElement elem, List results) {
        switch (elem.getType()) {
            case 1: {
                if (elem.getCondition() != null) break;
                this.addResult(results, 0, elem, "message.error.0110");
            }
        }
    }

    private void validateTransition(ActivityElement elem, List trs, List results) {
        int in = 0;
        int out = 0;
        Iterator it = trs.iterator();
        while (it.hasNext()) {
            TransitionElement e = (TransitionElement)it.next();
            if (elem == e.getSource()) {
                ++out;
                continue;
            }
            if (elem != e.getDestination()) continue;
            ++in;
        }
        if (elem.getType().equals("START")) {
            if (out == 0) {
                this.addResult(results, 0, elem, "message.error.0111");
            }
        } else if (elem.getType().equals("END")) {
            if (in == 0) {
                this.addResult(results, 0, elem, "message.error.0112");
            }
        } else {
            if (in == 0) {
                this.addResult(results, 0, elem, "message.error.0112");
            }
            if (out == 0) {
                this.addResult(results, 0, elem, "message.error.0111");
            }
        }
    }

    private void validateSameName(Element elem, List vars, List results) {
        Iterator it = vars.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (elem.getName() == null || e.getName() == null || elem == e || !elem.getName().equals(e.getName())) continue;
            this.addResult(results, 0, elem, "message.error.0113");
        }
    }

    private void validateApplication(ActivityElement elem, List apps, List results) {
        Iterator it = apps.iterator();
        String appID = elem.getApplicationID();
        if (appID == null) {
            return;
        }
        boolean found = false;
        while (it.hasNext()) {
            ApplicationElement e = (ApplicationElement)it.next();
            if (!appID.equals(e.getID())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addResult(results, 0, elem, "message.error.0114");
        }
    }

    private void validateSubprocess(ActivityElement elem, List procs, List results) {
        Iterator it = procs.iterator();
        String procID = elem.getSubprocessID();
        if (procID == null) {
            return;
        }
        boolean found = false;
        while (it.hasNext()) {
            ProcessElement e = (ProcessElement)it.next();
            if (!procID.equals(e.getID())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addResult(results, 0, elem, "message.error.0115");
        }
    }

    private void validateParticipant(ActivityElement elem, List parts, List results) {
        Iterator it = parts.iterator();
        String partID = elem.getPerformerID();
        if (partID == null) {
            return;
        }
        boolean found = false;
        while (it.hasNext()) {
            ParticipantElement e = (ParticipantElement)it.next();
            if (!partID.equals(e.getID())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addResult(results, 0, elem, "message.error.0116");
        }
    }

    private void validateActualParams(ActivityElement elem, String id, List params, List results) {
        Iterator it = params.iterator();
        if (StringUtils.checkNull(id)) {
            this.addResult(results, 0, elem, "message.error.0117");
            return;
        }
        boolean found = false;
        while (it.hasNext()) {
            VariableElement e = (VariableElement)it.next();
            if (!id.equals(e.getID())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addResult(results, 0, elem, "message.error.0118");
        }
    }
}

