/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.DesignerStatusBar;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.FileManager;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.MenuBar;
import jp.co.argo21.nautica.tool.wfd.PackageConverter;
import jp.co.argo21.nautica.tool.wfd.PackageValidator;
import jp.co.argo21.nautica.tool.wfd.TabbedToolBox;
import jp.co.argo21.nautica.tool.wfd.ValidationDialog;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.impl.PackageElementImpl;
import jp.co.argo21.nautica.tool.wfd.xpdl.XPDLFileFilter;
import org.wfmc.x2002.xpdl10.PackageDocument;

public class WorkflowDesignerFrame
extends JFrame {
    private MenuBar menuBar;
    private TabbedToolBox toolbox;
    private DesktopPane desktop;
    private DesignerStatusBar statusBar;
    private PackageElement pkg;
    private Element pastable;

    public WorkflowDesignerFrame() throws HeadlessException {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.initInputMap();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screen = toolkit.getScreenSize();
        int sw = screen.width;
        int sh = screen.height;
        this.menuBar = new MenuBar();
        this.toolbox = new TabbedToolBox();
        this.desktop = new DesktopPane();
        this.statusBar = new DesignerStatusBar();
        this.setTitle(rm.getResource("WorkflowDesignerFrame.title"));
        this.enableEvents(64L);
        this.setDefaultCloseOperation(0);
        this.setJMenuBar(this.menuBar);
        Container contentPane = this.getContentPane();
        BorderLayout layout = new BorderLayout();
        contentPane.setLayout(layout);
        contentPane.add((Component)this.toolbox, "North");
        contentPane.add((Component)this.desktop, "Center");
        contentPane.add((Component)this.statusBar, "South");
        int fw = (int)((double)sw * 0.95);
        int fh = (int)((double)sh * 0.95);
        this.setSize(new Dimension(fw, fh));
        this.setLocation((sw - fw) / 2, 0);
        this.setIconImage(((ImageIcon)IconManager.getIcon("application")).getImage());
        this.validate();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.notifyApplicationWillExit();
        } else {
            this.repaint();
        }
    }

    public void notifyApplicationWillExit() {
        int result;
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        if (this.isNeedSaved() && (result = DialogUtilities.showYesNoConfirm(rm.getResource("message.confirm.0002"))) == 0) {
            this.save();
        }
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void initInputMap() {
        JComponent c = (JComponent)this.getContentPane();
        ActionMap am = WorkflowDesignerManager.getActionMap();
        c.setActionMap(am);
        InputMap inputmap = c.getInputMap(2);
        inputmap.put(KeyStroke.getKeyStroke(78, 2), "newPackage");
        inputmap.put(KeyStroke.getKeyStroke(79, 2), "openPackage");
        inputmap.put(KeyStroke.getKeyStroke(83, 2), "savePackage");
        inputmap.put(KeyStroke.getKeyStroke(80, 2), "printPackage");
        inputmap.put(KeyStroke.getKeyStroke(81, 2), "exit");
        inputmap.put(KeyStroke.getKeyStroke(88, 2), "cutActivity");
        inputmap.put(KeyStroke.getKeyStroke(67, 2), "copyActivity");
        inputmap.put(KeyStroke.getKeyStroke(86, 2), "pasteActivity");
        inputmap.put(KeyStroke.getKeyStroke(127, 0), "deleteActivity");
        inputmap.put(KeyStroke.getKeyStroke(122, 0), "exceptionViewer");
        inputmap.put(KeyStroke.getKeyStroke(112, 0), "help");
        inputmap.put(KeyStroke.getKeyStroke(72, 2), "help");
        inputmap.put(KeyStroke.getKeyStroke(38, 8), "reduceHeight");
        inputmap.put(KeyStroke.getKeyStroke(40, 8), "expandHeight");
        inputmap.put(KeyStroke.getKeyStroke(37, 8), "reduceWidth");
        inputmap.put(KeyStroke.getKeyStroke(39, 8), "expandWidth");
    }

    void load() {
        FileManager fileManager = WorkflowDesignerManager.getFileManager();
        try {
            PackageDocument doc = fileManager.getDocument();
            PackageElementImpl p = new PackageElementImpl(doc);
            PackageConverter conv = PackageConverter.getInstance();
            fileManager.setDocument(conv.convert(p));
            this.desktop.closeAllFrame();
            this.setPackage(p);
            this.toolbox.setSelectedIndex(4);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    boolean isNeedSaved() {
        FileManager fileManager = WorkflowDesignerManager.getFileManager();
        try {
            PackageDocument doc = fileManager.getDocument();
            PackageConverter conv = PackageConverter.getInstance();
            PackageDocument converted = conv.convert(this.pkg);
            if (doc == null) {
                return false;
            }
            if (converted == null) {
                return false;
            }
            return !doc.toString().equals(converted.toString());
        }
        catch (Exception ex) {
            return true;
        }
    }

    public void newPackage() {
        FileManager fileManager = WorkflowDesignerManager.getFileManager();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        try {
            int result;
            if (this.isNeedSaved() && (result = DialogUtilities.showYesNoConfirm(rm.getResource("message.confirm.0002"))) == 0) {
                this.save();
            }
            fileManager.initDocument();
            this.load();
        }
        catch (Exception ex) {
            WorkflowDesignerManager.getExceptionViewer().setThrowable(ex);
            DialogUtilities.showError(rm.getResource("message.error.0011"));
        }
    }

    public void open() {
        FileManager fileManager = WorkflowDesignerManager.getFileManager();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        try {
            int result;
            if (this.isNeedSaved() && (result = DialogUtilities.showYesNoConfirm(rm.getResource("message.confirm.0002"))) == 0) {
                this.save();
            }
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setFileFilter(new XPDLFileFilter(rm.getResource("XPDLFileFilter.description")));
            fileChooser.setFileSelectionMode(0);
            int selected = fileChooser.showOpenDialog(this);
            if (selected == 1) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String path = file.getAbsolutePath();
            if (!path.endsWith("xpdl")) {
                path = path + "." + "xpdl";
            }
            fileManager.loadDocument(path);
            this.load();
        }
        catch (Exception ex) {
            WorkflowDesignerManager.getExceptionViewer().setThrowable(ex);
            DialogUtilities.showError(rm.getResource("message.error.0012"));
        }
    }

    public void save() {
        FileManager fileManager = WorkflowDesignerManager.getFileManager();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        String fn = fileManager.getFilename();
        if (fn == null) {
            this.saveTo();
            return;
        }
        try {
            PackageConverter conv = PackageConverter.getInstance();
            fileManager.setDocument(conv.convert(this.pkg));
            fileManager.saveDocument();
        }
        catch (Exception ex) {
            WorkflowDesignerManager.getExceptionViewer().setThrowable(ex);
            DialogUtilities.showError(rm.getResource("message.error.0013"));
        }
    }

    public void saveTo() {
        FileManager fileManager = WorkflowDesignerManager.getFileManager();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JFileChooser fileChooser = null;
        File selectedFile = new File(System.getProperty("user.home", ".") + System.getProperty("file.separator", "/") + this.pkg.getName() + "." + "xpdl");
        fileChooser = new JFileChooser(selectedFile);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new XPDLFileFilter(rm.getResource("XPDLFileFilter.description")));
        fileChooser.setFileSelectionMode(0);
        int selected = fileChooser.showSaveDialog(this);
        if (selected == 1) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String path = file.getAbsolutePath();
        if (!path.endsWith("xpdl")) {
            path = path + "." + "xpdl";
        }
        try {
            PackageConverter conv = PackageConverter.getInstance();
            fileManager.setDocument(conv.convert(this.pkg));
            fileManager.saveDocument(path);
        }
        catch (Exception ex) {
            WorkflowDesignerManager.getExceptionViewer().setThrowable(ex);
            DialogUtilities.showError(rm.getResource("message.error.0013"));
        }
    }

    public void validatePackage() {
        List results = PackageValidator.getInstance().validate(this.pkg);
        ValidationDialog.showDialog(this, results);
    }

    public void showPackageInspector() {
        InspectorDialog.showDialog((Component)this, this.pkg);
    }

    public MenuBar getFrameMemuBar() {
        return this.menuBar;
    }

    public DesktopPane getDesktop() {
        return this.desktop;
    }

    public DesignerStatusBar getStatusBar() {
        return this.statusBar;
    }

    public TabbedToolBox getToolbox() {
        return this.toolbox;
    }

    public PackageElement getPackage() {
        return this.pkg;
    }

    public void setPackage(PackageElement elem) {
        this.pkg = elem;
        this.toolbox.loadElements(elem);
    }

    public boolean getEnableCopyAction() {
        return this.menuBar.getEnableCopyAction();
    }

    public void setEnableCopyAction(boolean f) {
        this.menuBar.setEnableCopyAction(f);
    }

    public boolean getEnablePasteAction() {
        return this.menuBar.getEnablePasteAction();
    }

    public void setEnablePasteAction(boolean f) {
        this.menuBar.setEnablePasteAction(f);
    }

    public boolean getEnableDeleteAction() {
        return this.menuBar.getEnableDeleteAction();
    }

    public void setEnableDeleteAction(boolean f) {
        this.menuBar.setEnableDeleteAction(f);
    }

    public Element getPastable() {
        return this.pastable;
    }

    public void setPastable(Element element) {
        this.pastable = element;
        this.menuBar.setEnablePasteAction(this.pastable != null);
    }
}

