/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.Iterator;
import java.util.List;
import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.expression.ExceptionExpression;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.tool.wfd.expression.LogicalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.OtherwiseExpression;
import jp.co.argo21.nautica.tool.wfd.expression.RelationalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.UnaryExpression;
import jp.co.argo21.nautica.workflow.xpdl.ConditionalExpressionDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.wfmc.x2002.xpdl10.ConditionDocument;
import org.wfmc.x2002.xpdl10.TransitionDocument;

public class TransitionElementImpl
implements TransitionElement {
    private String id;
    private String name;
    private String description;
    private ActivityElement source;
    private ActivityElement destination;
    private Expression condition;
    private int type;

    public TransitionElementImpl(ActivityElement s, ActivityElement d) {
        this.setID(IDGenerator.generate("TR"));
        this.setName("");
        this.setDescription("");
        this.setSource(s);
        this.setDestination(d);
        this.setType(1);
        this.setCondition(null);
    }

    public TransitionElementImpl(TransitionDocument.Transition tr, List acts) {
        String id = tr.getId();
        if (StringUtils.checkNull(id)) {
            this.setID(IDGenerator.generate("TR"));
        } else {
            this.setID(id);
        }
        this.setName(tr.getName());
        this.setDescription(tr.getDescription());
        String sid = tr.getFrom();
        this.setSource(this.getActivityElement(acts, sid));
        String did = tr.getTo();
        this.setDestination(this.getActivityElement(acts, did));
        if (tr.isSetCondition()) {
            ConditionDocument.Condition c = tr.getCondition();
            int type = c.getType().intValue();
            try {
                if (type == 1) {
                    XmlObject obj = XmlObject.Factory.parse((String)c.toString());
                    if (obj == null) {
                        this.setCondition(null);
                    } else if (obj instanceof ConditionalExpressionDocument) {
                        ConditionalExpressionDocument ceDoc = (ConditionalExpressionDocument)obj;
                        ConditionalExpressionDocument.ConditionalExpression ce = ceDoc.getConditionalExpression();
                        if (ce.isSetRelationalExpression()) {
                            this.setCondition(new RelationalExpression(ce.getRelationalExpression()));
                        } else if (ce.isSetUnaryExpression()) {
                            this.setCondition(new UnaryExpression(ce.getUnaryExpression()));
                        } else if (ce.isSetLogicalExpression()) {
                            this.setCondition(new LogicalExpression(ce.getLogicalExpression()));
                        }
                    } else {
                        this.setCondition(null);
                    }
                } else if (type == 2) {
                    this.setCondition(new OtherwiseExpression());
                } else if (type == 3) {
                    this.setCondition(new ExceptionExpression());
                }
            }
            catch (XmlException ex) {}
        } else {
            this.setCondition(null);
        }
    }

    private void setID(String id) {
        this.id = id;
    }

    private void setSource(ActivityElement act) {
        this.source = act;
    }

    private void setDestination(ActivityElement act) {
        this.destination = act;
    }

    private ActivityElement getActivityElement(List acts, String id) {
        Iterator it = acts.iterator();
        while (it.hasNext()) {
            ActivityElement act = (ActivityElement)it.next();
            String aid = act.getID();
            if (!id.equals(aid)) continue;
            return act;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public ActivityElement getDestination() {
        return this.destination;
    }

    public ActivityElement getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public void setCondition(Expression cond) {
        this.type = cond == null ? 1 : (cond instanceof OtherwiseExpression ? 2 : (cond instanceof ExceptionExpression ? 3 : 1));
        this.condition = cond;
    }

    public void setType(int i) {
        this.type = i;
    }

    public String getTooltipText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        s = s.append("<html>");
        s = s.append("<b>").append(this.getName()).append("</b>");
        s = s.append("<table border>");
        s = s.append("<tr><td width=100>").append(rm.getResource("TransitionElement.label.0")).append("</td><td width=150>").append(this.getID()).append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("TransitionElement.label.3")).append("</td><td width=150>").append(this.getDescription()).append("</td></tr>");
        s = s.append("</table>");
        s = s.append("</html>");
        return s.toString();
    }

    public String getPrintText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        return s.toString();
    }

    public boolean isUsed(Element elem) {
        if (elem == null) {
            return false;
        }
        if (elem == this.source) {
            return true;
        }
        return elem == this.destination;
    }
}

