/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.expression.ConditionalVariable;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.workflow.xpdl.RelationalExpressionDocument;
import org.apache.xmlbeans.XmlObject;

public class RelationalExpression
implements Expression {
    public static final int EQUAL = 1;
    public static final int NOT_EQUAL = 2;
    public static final int LESS_THAN = 3;
    public static final int LESS_EQUAL = 4;
    public static final int GREATER_THAN = 5;
    public static final int GREATER_EQUAL = 6;
    private static final String EQUAL_STR = "==";
    private static final String NOT_EQUAL_STR = "!=";
    private static final String LESS_THAN_STR = "<";
    private static final String LESS_EQUAL_STR = "<=";
    private static final String GREATER_THAN_STR = ">";
    private static final String GREATER_EQUAL_STR = ">=";
    private int operator;
    private String leftValue;
    private String rightValue;

    public RelationalExpression(String lVal, int ope, String rVal) {
        this.operator = ope;
        this.leftValue = lVal;
        this.rightValue = rVal;
    }

    public RelationalExpression(RelationalExpressionDocument.RelationalExpression exp) {
        this.operator = exp.getType().intValue();
        this.leftValue = exp.getDataFieldRef();
        this.rightValue = exp.getComparedValue();
    }

    public void saveTo(XmlObject o) {
        if (o == null) {
            return;
        }
        if (!(o instanceof RelationalExpressionDocument.RelationalExpression)) {
            return;
        }
        RelationalExpressionDocument.RelationalExpression re = (RelationalExpressionDocument.RelationalExpression)o;
        re.setType(RelationalExpressionDocument.RelationalExpression.Type.Enum.forInt((int)this.operator));
        if (this.leftValue != null) {
            re.setDataFieldRef(this.leftValue);
        }
        if (this.rightValue != null) {
            re.setComparedValue(this.rightValue);
        }
    }

    public boolean eval(List list) {
        ConditionalVariable var = this.getVariable(list, this.leftValue);
        if (var == null) {
            return false;
        }
        int type = var.getType();
        String value = var.getValue();
        if (type == 6) {
            return this.evalAsBoolean(value, this.rightValue);
        }
        if (type == 3) {
            return this.evalAsInteger(value, this.rightValue);
        }
        return this.evalAsString(value, this.rightValue);
    }

    public String getExpressionString() {
        String ls = "null";
        String rs = "null";
        if (this.leftValue != null) {
            ls = this.leftValue;
        }
        if (this.rightValue != null) {
            rs = this.rightValue;
        }
        return "(" + ls + ") " + this.getOpeString() + " (" + rs + ")";
    }

    public String getExpressionString(List vars) {
        if (vars == null) {
            return this.getExpressionString();
        }
        if (this.leftValue == null) {
            return this.getExpressionString();
        }
        String label = null;
        Iterator it = vars.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null || !(o instanceof VariableElement) || !((VariableElement)o).getID().equals(this.leftValue)) continue;
            label = ((VariableElement)o).getName();
            break;
        }
        String ls = "null";
        String rs = "null";
        if (label != null) {
            ls = label;
        }
        if (this.rightValue != null) {
            rs = this.rightValue;
        }
        return "(" + ls + ") " + this.getOpeString() + " (" + rs + ")";
    }

    public void getAllExpressions(List exps) {
        if (!exps.contains(this)) {
            exps.add(this);
        }
    }

    private String getOpeString() {
        if (this.operator == 2) {
            return NOT_EQUAL_STR;
        }
        if (this.operator == 3) {
            return LESS_THAN_STR;
        }
        if (this.operator == 4) {
            return LESS_EQUAL_STR;
        }
        if (this.operator == 5) {
            return GREATER_THAN_STR;
        }
        if (this.operator == 6) {
            return GREATER_EQUAL_STR;
        }
        return EQUAL_STR;
    }

    private boolean evalAsBoolean(String v1, String v2) {
        boolean result = false;
        Boolean b1 = null;
        Boolean b2 = null;
        try {
            b1 = new Boolean(v1);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            b2 = new Boolean(v2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (b1 == null) {
            return false;
        }
        if (b2 == null) {
            return false;
        }
        result = b1.equals(b2);
        if (this.operator == 1) {
            return result;
        }
        return !result;
    }

    private boolean evalAsDateTime(String v1, String v2) {
        boolean comp = false;
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(v1);
        }
        catch (Exception ex) {
            return false;
        }
        try {
            d2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(v2);
        }
        catch (Exception ex) {
            return false;
        }
        return this.evalComparedValue(d1.compareTo(d2));
    }

    private boolean evalAsInteger(String v1, String v2) {
        boolean comp = false;
        BigInteger i1 = null;
        BigInteger i2 = null;
        try {
            i1 = new BigInteger(v1);
        }
        catch (Exception ex) {
            return false;
        }
        try {
            i2 = new BigInteger(v2);
        }
        catch (Exception ex) {
            return false;
        }
        return this.evalComparedValue(i1.compareTo(i2));
    }

    private boolean evalAsDecimal(String v1, String v2) {
        boolean comp = false;
        BigDecimal d1 = null;
        BigDecimal d2 = null;
        try {
            d1 = new BigDecimal(v1);
        }
        catch (Exception ex) {
            return false;
        }
        try {
            d2 = new BigDecimal(v2);
        }
        catch (Exception ex) {
            return false;
        }
        return this.evalComparedValue(d1.compareTo(d2));
    }

    private boolean evalComparedValue(int comp) {
        if (comp < 0) {
            return this.operator == 3 || this.operator == 4 || this.operator == 2;
        }
        if (comp > 0) {
            return this.operator == 5 || this.operator == 6 || this.operator == 2;
        }
        return this.operator == 1 || this.operator == 4 || this.operator == 6;
    }

    private boolean evalAsString(String v1, String v2) {
        boolean result = false;
        result = v1 == null && v2 == null ? true : (v1 == null ? false : (v2 == null ? false : v1.equals(v2)));
        if (this.operator == 1) {
            return result;
        }
        return !result;
    }

    private ConditionalVariable getVariable(List list, String id) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ConditionalVariable e = (ConditionalVariable)it.next();
            if (!id.equals(e.getID())) continue;
            return e;
        }
        return null;
    }
}

