/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.inspector.AbstractElementInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.ParameterInspector;

public class ApplicationInspector
extends AbstractElementInspector {
    private static String[] columnNames;
    protected static final Border border;
    private IconView iconView;
    private JLabel idField;
    private JTextField nameField;
    private JTextField descriptionField;
    private JTable paramTable;
    private JButton addParamButton;
    private JButton editParamButton;
    private JButton delParamButton;
    static /* synthetic */ Class class$java$lang$String;

    public ApplicationInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel0 = this.createBasicInfoPanel(rm);
        this.addTab(rm.getResource("ApplicationInspector.tab.0"), panel0);
        JPanel panel1 = this.createParamInfoPanel(rm);
        this.addTab(rm.getResource("ApplicationInspector.tab.1"), panel1);
        this.validate();
    }

    private JPanel createBasicInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 110);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ApplicationInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("ApplicationInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("ApplicationInspector.label.2"));
        this.iconView = new IconView();
        this.iconView.setIconName("application");
        this.idField = new JLabel();
        this.idField.setBorder(border);
        this.nameField = new JTextField();
        this.nameField.setDocument(new ByteLimitedDocument(64));
        this.descriptionField = new JTextField();
        this.descriptionField.setDocument(new ByteLimitedDocument(128));
        panel.add(this.locate(this.iconView, 10, 10, 60, 60));
        panel.add(this.locate(l0, 80, 10, 100, 25));
        panel.add(this.locate(l1, 80, 40, 100, 25));
        panel.add(this.locate(l2, 80, 70, 100, 25));
        panel.add(this.locate(this.idField, 180, 10, 190, 25));
        panel.add(this.locate(this.nameField, 180, 40, 190, 25));
        panel.add(this.locate(this.descriptionField, 180, 70, 190, 25));
        this.validate();
        return panel;
    }

    private JPanel createParamInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ApplicationInspector.label.3"));
        this.paramTable = new JTable(new ParamTableModel());
        this.paramTable.setSelectionMode(0);
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.paramTable);
        this.addParamButton = new JButton(rm.getResource("JButton.label.add"));
        this.addParamButton.addActionListener(new AddParamAction());
        this.editParamButton = new JButton(rm.getResource("JButton.label.edit"));
        this.editParamButton.addActionListener(new EditParamAction());
        this.delParamButton = new JButton(rm.getResource("JButton.label.delete"));
        this.delParamButton.addActionListener(new DeleteParamAction());
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(sp, 10, 40, 270, 145));
        panel.add(this.locate(this.addParamButton, 290, 40, 80, 25));
        panel.add(this.locate(this.editParamButton, 290, 70, 80, 25));
        panel.add(this.locate(this.delParamButton, 290, 100, 80, 25));
        this.validate();
        return panel;
    }

    public void init() {
        super.init();
        this.nameField.setText("");
        this.descriptionField.setText("");
        this.paramTable.clearSelection();
    }

    public void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof ApplicationElement) {
            ApplicationElement app = (ApplicationElement)elem;
            this.idField.setText(app.getID());
            this.nameField.setText(app.getName());
            this.descriptionField.setText(app.getDescription());
        }
        this.setSelectedIndex(0);
    }

    public boolean check() {
        return true;
    }

    public void commit() {
        Element e = this.getInspectable();
        if (e != null && e instanceof ApplicationElement) {
            ApplicationElement app = (ApplicationElement)e;
            app.setName(this.nameField.getText());
            app.setDescription(this.descriptionField.getText());
            this.fireElementChanged();
        }
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        columnNames = new String[3];
        ApplicationInspector.columnNames[0] = rm.getResource("ParamTableModel.columnName.0");
        ApplicationInspector.columnNames[1] = rm.getResource("ParamTableModel.columnName.1");
        ApplicationInspector.columnNames[2] = rm.getResource("ParamTableModel.columnName.2");
    }

    class ParamTableModel
    extends AbstractTableModel {
        ParamTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            Element e = ApplicationInspector.this.getInspectable();
            if (e == null) {
                return 0;
            }
            return ((ApplicationElement)e).getParameters().size();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Element e = ApplicationInspector.this.getInspectable();
            if (e == null) {
                return "";
            }
            List list = ((ApplicationElement)e).getParameters();
            ParameterElement p = (ParameterElement)list.get(row);
            if (col == 0) {
                int m = p.getMode();
                if (m == 1) {
                    return ParameterInspector.PARAM_MODES[0];
                }
                if (m == 2) {
                    return ParameterInspector.PARAM_MODES[1];
                }
                if (m == 3) {
                    return ParameterInspector.PARAM_MODES[2];
                }
            } else if (col == 1) {
                int t = p.getType();
                if (t == 1) {
                    return ParameterInspector.PARAM_TYPES[0];
                }
                if (t == 3) {
                    return ParameterInspector.PARAM_TYPES[1];
                }
                if (t == 6) {
                    return ParameterInspector.PARAM_TYPES[2];
                }
            } else if (col == 2) {
                return p.getDescription();
            }
            return "";
        }

        public Class getColumnClass(int col) {
            return class$java$lang$String == null ? (class$java$lang$String = ApplicationInspector.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class DeleteParamAction
    extends AbstractAction {
        DeleteParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = ApplicationInspector.this.paramTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
                return;
            }
            Element app = ApplicationInspector.this.getInspectable();
            if (app == null) {
                return;
            }
            List list = ((ApplicationElement)app).getParameters();
            ParameterElement p = (ParameterElement)list.remove(selected);
            ApplicationInspector.this.paramTable.clearSelection();
            ApplicationInspector.this.paramTable.updateUI();
        }
    }

    class EditParamAction
    extends AbstractAction {
        EditParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = ApplicationInspector.this.paramTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
                return;
            }
            Element app = ApplicationInspector.this.getInspectable();
            if (app == null) {
                return;
            }
            List list = ((ApplicationElement)app).getParameters();
            ParameterElement p = (ParameterElement)list.get(selected);
            InspectorDialog.showDialog((Component)ApplicationInspector.this, p);
            ApplicationInspector.this.paramTable.clearSelection();
            ApplicationInspector.this.paramTable.updateUI();
        }
    }

    class AddParamAction
    extends AbstractAction {
        AddParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Element newElem = InspectorDialog.showDialog((Component)ApplicationInspector.this, "parameter");
            if (newElem == null) {
                return;
            }
            Element app = ApplicationInspector.this.getInspectable();
            if (app == null) {
                return;
            }
            ((ApplicationElement)app).addParameter((ParameterElement)newElem);
            ApplicationInspector.this.paramTable.clearSelection();
            ApplicationInspector.this.paramTable.updateUI();
        }
    }
}

