/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.inspector.Inspector;

public class BasicActivityInspector
extends JTabbedPane
implements Inspector {
    protected static final Border border = BorderFactory.createEtchedBorder();
    private IconView iconView;
    private JLabel idField;
    private JTextField nameField;
    private JTextField descriptionField;
    private JLabel xField;
    private JLabel yField;
    private Element inspectable;

    public BasicActivityInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel = this.createBasicInfoPanel(rm);
        this.addTab(rm.getResource("BasicActivityInspector.tab.0"), panel);
        this.validate();
    }

    private JPanel createBasicInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 135);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("BasicActivityInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("BasicActivityInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("BasicActivityInspector.label.2"));
        JLabel l3 = new JLabel(rm.getResource("BasicActivityInspector.label.3"));
        JLabel l4 = new JLabel(rm.getResource("BasicActivityInspector.label.4"));
        this.iconView = new IconView();
        this.idField = new JLabel();
        this.idField.setBorder(border);
        this.nameField = new JTextField();
        this.nameField.setDocument(new ByteLimitedDocument(64));
        this.descriptionField = new JTextField();
        this.descriptionField.setDocument(new ByteLimitedDocument(128));
        this.xField = new JLabel();
        this.xField.setHorizontalAlignment(4);
        this.xField.setBorder(border);
        this.yField = new JLabel();
        this.yField.setHorizontalAlignment(4);
        this.yField.setBorder(border);
        panel.add(this.locate(this.iconView, 10, 10, 60, 60));
        panel.add(this.locate(l0, 80, 10, 100, 25));
        panel.add(this.locate(l1, 80, 40, 100, 25));
        panel.add(this.locate(l2, 80, 70, 100, 25));
        panel.add(this.locate(l3, 230, 70, 100, 25));
        panel.add(this.locate(l4, 80, 100, 100, 25));
        panel.add(this.locate(this.idField, 180, 10, 190, 25));
        panel.add(this.locate(this.nameField, 180, 40, 190, 25));
        panel.add(this.locate(this.xField, 180, 70, 40, 25));
        panel.add(this.locate(this.yField, 330, 70, 40, 25));
        panel.add(this.locate(this.descriptionField, 180, 100, 190, 25));
        this.validate();
        return panel;
    }

    public Element getInspectable() {
        return this.inspectable;
    }

    public void setInspectable(Element elem) {
        this.inspectable = elem;
        if (elem != null && elem instanceof ActivityElement) {
            ActivityElement act = (ActivityElement)elem;
            this.iconView.setIconName(act.getActivityState().getIconName());
            this.idField.setText(act.getID());
            this.nameField.setText(act.getName());
            this.xField.setText("" + (act.getLogicalX() + 1));
            this.yField.setText("" + (act.getLogicalY() + 1));
            this.descriptionField.setText(act.getDescription());
        }
        this.setSelectedIndex(0);
    }

    public boolean isAutoCommit() {
        return false;
    }

    public boolean check() {
        return true;
    }

    public void commit() {
        Element e = this.getInspectable();
        if (e != null && e instanceof ActivityElement) {
            ActivityElement act = (ActivityElement)e;
            act.setName(this.nameField.getText());
            act.setDescription(this.descriptionField.getText());
        }
    }

    public void init() {
        this.nameField.setText("");
        this.descriptionField.setText("");
    }

    public void unload() {
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }
}

