/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.util.EmptyStackException;
import java.util.Stack;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;

public class SimulatableActivityWrapper {
    private ActivityElement act;
    private TransitionElement tr;
    private Stack blockStack = new Stack();

    public SimulatableActivityWrapper(ActivityElement act, TransitionElement tr) {
        this.act = act;
        this.tr = tr;
        if (act.getType().equals("CONCUR_START")) {
            this.blockStack.push(this);
        } else if (act.getType().equals("CONCUR_END")) {
            this.blockStack.pop();
        }
    }

    public SimulatableActivityWrapper(ActivityElement act, TransitionElement tr, Stack st) {
        this.act = act;
        this.tr = tr;
        if (st != null) {
            this.blockStack.addAll(st);
        }
        if (act.getType().equals("CONCUR_START")) {
            this.blockStack.push(this);
        } else if (act.getType().equals("CONCUR_END")) {
            this.blockStack.pop();
        }
    }

    public ActivityElement getActivity() {
        return this.act;
    }

    public TransitionElement getTransition() {
        return this.tr;
    }

    public Stack getBlockStack() {
        return this.blockStack;
    }

    public SimulatableActivityWrapper peekTopBlockWrapper() {
        try {
            return (SimulatableActivityWrapper)this.blockStack.peek();
        }
        catch (EmptyStackException ex) {
            return null;
        }
    }

    public int searchBlockWrapper(SimulatableActivityWrapper wrapper) {
        return this.blockStack.search(wrapper);
    }
}

