/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;
import jp.co.argo21.commons.swing.BooleanDocument;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.expression.ConditionalVariable;

public class SimulatorView
extends JTabbedPane {
    private static String[] columnNames;
    protected static final Border border;
    private IconView iconView;
    private JLabel idField;
    private JLabel nameField;
    private JRadioButton editVarButton;
    private JRadioButton raiseExButton;
    private JTable varTable;
    private JTextField varField;
    private JButton updateButton;
    private Document strDocument = new ByteLimitedDocument(128);
    private Document numDocument = new NumericDocument(9, true);
    private Document boolDocument = new BooleanDocument();
    private List vars;
    static /* synthetic */ Class class$jp$co$argo21$nautica$tool$wfd$expression$ConditionalVariable;
    static /* synthetic */ Class class$java$lang$String;

    public SimulatorView() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel = this.createEditorPanel(rm);
        this.addTab(rm.getResource("SimulatorView.tab.0"), panel);
        this.validate();
    }

    private JPanel createEditorPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 265);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("SimulatorView.label.0"));
        JLabel l1 = new JLabel(rm.getResource("SimulatorView.label.1"));
        this.iconView = new IconView();
        this.idField = new JLabel();
        this.idField.setBorder(border);
        this.nameField = new JLabel();
        this.nameField.setBorder(border);
        this.editVarButton = new JRadioButton(rm.getResource("SimulatorView.operate.0"));
        this.editVarButton.addActionListener(new SelectEditVarAction());
        this.raiseExButton = new JRadioButton(rm.getResource("SimulatorView.operate.1"));
        this.raiseExButton.addActionListener(new SelectRaiseExceptionAction());
        JPanel opePane = new JPanel();
        opePane.setLayout(new GridLayout(1, 3, 5, 5));
        opePane.setBorder(border);
        opePane.add(this.editVarButton);
        opePane.add(this.raiseExButton);
        ButtonGroup opeGroup = new ButtonGroup();
        opeGroup.add(this.editVarButton);
        opeGroup.add(this.raiseExButton);
        this.varTable = new JTable(new VarTableModel());
        this.varTable.setSelectionMode(0);
        this.varTable.setRowHeight(35);
        this.varTable.getColumnModel().getColumn(0).setCellRenderer(new VarRenderer());
        ListSelectionModel vlsm = this.varTable.getSelectionModel();
        vlsm.addListSelectionListener(new VarSelectAction());
        JScrollPane sp0 = new JScrollPane();
        sp0.setViewportView(this.varTable);
        this.varField = new JTextField();
        this.varField.setDocument(this.strDocument);
        this.updateButton = new JButton(rm.getResource("JButton.label.update"));
        this.updateButton.addActionListener(new UpdateVarAction());
        panel.add(this.locate(this.iconView, 10, 10, 60, 60));
        panel.add(this.locate(l0, 80, 10, 100, 25));
        panel.add(this.locate(l1, 80, 40, 100, 25));
        panel.add(this.locate(this.idField, 180, 10, 190, 25));
        panel.add(this.locate(this.nameField, 180, 40, 190, 25));
        panel.add(this.locate(opePane, 10, 80, 360, 35));
        panel.add(this.locate(sp0, 10, 120, 360, 105));
        panel.add(this.locate(this.varField, 10, 230, 270, 25));
        panel.add(this.locate(this.updateButton, 290, 230, 80, 25));
        this.validate();
        return panel;
    }

    private void setVarEditable(boolean b) {
        this.varTable.clearSelection();
        this.varField.setText("");
        this.varTable.setEnabled(b);
        this.varField.setEditable(b);
        this.updateButton.setEnabled(b);
    }

    public boolean isExceptionRaising() {
        return this.raiseExButton.isSelected();
    }

    public List getCurrentVariables() {
        return this.vars;
    }

    public void setCurrentActivity(ActivityElement act) {
        this.iconView.setIconName(act.getActivityState().getIconName());
        this.idField.setText(act.getID());
        this.nameField.setText(act.getName());
    }

    public void setCurrentVariables(List vars) {
        this.vars = vars;
    }

    void setValueEditable(boolean b) {
        this.editVarButton.setEnabled(b);
        this.raiseExButton.setEnabled(b);
        this.varTable.setEnabled(b);
        this.varField.setEditable(b);
        this.updateButton.setEnabled(b);
        this.varField.setText("");
    }

    void init() {
        this.editVarButton.setSelected(true);
        this.setVarEditable(true);
    }

    public boolean check() {
        return true;
    }

    public void commit() {
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        columnNames = new String[3];
        SimulatorView.columnNames[0] = rm.getResource("SimulatorView.columnName.0");
        SimulatorView.columnNames[1] = rm.getResource("SimulatorView.columnName.1");
    }

    public class VarRenderer
    extends DefaultTableCellRenderer {
        private Icon icon;

        VarRenderer() {
            String name = "variable-cur";
            this.icon = IconManager.getIcon(name);
        }

        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            ConditionalVariable var = (ConditionalVariable)o;
            this.setText(var.getName());
            if (this.icon != null) {
                this.setIcon(this.icon);
            }
            this.setToolTipText(var.getTooltipText(rm));
            return this;
        }
    }

    class VarTableModel
    extends AbstractTableModel {
        VarTableModel() {
            SimulatorView.this.vars = WorkflowDesignerManager.getMainFrame().getPackage().getVariables();
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return SimulatorView.this.vars.size();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            ConditionalVariable var = (ConditionalVariable)SimulatorView.this.vars.get(row);
            if (col == 0) {
                return var;
            }
            return var.getValue();
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return class$jp$co$argo21$nautica$tool$wfd$expression$ConditionalVariable == null ? (class$jp$co$argo21$nautica$tool$wfd$expression$ConditionalVariable = SimulatorView.class$("jp.co.argo21.nautica.tool.wfd.expression.ConditionalVariable")) : class$jp$co$argo21$nautica$tool$wfd$expression$ConditionalVariable;
            }
            return class$java$lang$String == null ? (class$java$lang$String = SimulatorView.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class VarSelectAction
    implements ListSelectionListener {
        VarSelectAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selected = lsm.getMinSelectionIndex();
                ConditionalVariable var = (ConditionalVariable)SimulatorView.this.vars.get(selected);
                String v = var.getValue();
                int type = var.getType();
                if (v == null) {
                    SimulatorView.this.varField.setText("");
                } else {
                    SimulatorView.this.varField.setText(v);
                }
                if (type == 3) {
                    SimulatorView.this.varField.setDocument(SimulatorView.this.numDocument);
                    SimulatorView.this.varField.setHorizontalAlignment(4);
                } else if (type == 6) {
                    SimulatorView.this.varField.setDocument(SimulatorView.this.boolDocument);
                    SimulatorView.this.varField.setHorizontalAlignment(2);
                } else {
                    SimulatorView.this.varField.setDocument(SimulatorView.this.strDocument);
                    SimulatorView.this.varField.setHorizontalAlignment(2);
                }
            }
        }
    }

    class UpdateVarAction
    extends AbstractAction {
        UpdateVarAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = SimulatorView.this.varTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0006"));
                return;
            }
            ConditionalVariable var = (ConditionalVariable)SimulatorView.this.vars.get(selected);
            var.setValue(SimulatorView.this.varField.getText());
            SimulatorView.this.varTable.updateUI();
        }
    }

    class SelectRaiseExceptionAction
    extends AbstractAction {
        SelectRaiseExceptionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SimulatorView.this.setVarEditable(false);
        }
    }

    class SelectEditVarAction
    extends AbstractAction {
        SelectEditVarAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SimulatorView.this.setVarEditable(true);
        }
    }
}

