/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.definition.register;

import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.tool.wfadm.definition.register.RegisterInfo;

public class RegisterInfoComponent
extends DialogComponent {
    protected static final Border border = BorderFactory.createEtchedBorder();
    private JTextField nameField;
    private JTextField pathField;
    private RegisterInfo registerInfo;
    private boolean isNew;

    public RegisterInfoComponent() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        JPanel panel = this.createRegisterInfoPanel(rm);
        this.addTab(rm.getResource("RegisterInfoComponent.tab.0"), panel);
        this.validate();
    }

    private JPanel createRegisterInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 80);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("RegisterInfoComponent.label.0"));
        JLabel l1 = new JLabel(rm.getResource("RegisterInfoComponent.label.1"));
        this.nameField = new JTextField();
        this.nameField.setDocument(new ByteLimitedDocument(16));
        this.pathField = new JTextField();
        this.pathField.setDocument(new ByteLimitedDocument(64));
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(l1, 10, 40, 100, 25));
        panel.add(this.locate(this.nameField, 110, 10, 190, 25));
        panel.add(this.locate(this.pathField, 110, 40, 190, 25));
        this.validate();
        return panel;
    }

    public void init() {
        this.nameField.setText("");
        this.pathField.setText("");
    }

    public boolean commit() {
        if (this.check()) {
            this.registerInfo = new RegisterInfo();
            this.registerInfo.setPackageName(this.nameField.getText());
            this.registerInfo.setRegisterPath(this.pathField.getText());
            return true;
        }
        return false;
    }

    public RegisterInfo getRegisterInfo() {
        RegisterInfo info = this.registerInfo;
        this.registerInfo = null;
        this.init();
        return info;
    }

    private boolean check() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        if (!this.checkName(rm)) {
            return false;
        }
        return this.checkPath(rm);
    }

    private boolean checkName(ResourceManager rm) {
        String s = this.nameField.getText();
        String pat = "[A-Za-z0-9]*";
        String msg = null;
        if (s == null) {
            msg = rm.getResource("E9021");
        } else if (s.trim().equals("")) {
            msg = rm.getResource("E9021");
        } else if (!Pattern.matches(pat, s)) {
            msg = rm.getResource("E9022");
        }
        if (msg != null) {
            DialogUtilities.showError(msg);
            return false;
        }
        return true;
    }

    private boolean checkPath(ResourceManager rm) {
        String separator = System.getProperty("file.separator");
        String s = this.pathField.getText();
        String msg = null;
        if (s == null) {
            msg = rm.getResource("E9023");
        } else if (s.trim().equals("")) {
            msg = rm.getResource("E9023");
        } else if (s.trim().startsWith(separator)) {
            msg = rm.getResource("E9024");
        }
        return this.isValid(msg);
    }

    private boolean isValid(String msg) {
        if (msg != null) {
            DialogUtilities.showError(msg);
            return false;
        }
        return true;
    }
}

