/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class MimeInputStream
extends FilterInputStream {
    protected Hashtable headers;

    public MimeInputStream(InputStream in) throws IOException {
        super(in);
        this.readHeaders();
    }

    protected void readHeaders() throws IOException {
        this.headers = new Hashtable();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int ch = this.read();
        while (ch > 0) {
            if (ch == 13) {
                ch = this.read();
                if (ch == 10) {
                    byte[] b = bout.toByteArray();
                    if (b.length == 0) {
                        return;
                    }
                    int len = b.length;
                    for (int i = 0; i < len; ++i) {
                        if (b[i] != 58) continue;
                        String key = new String(b, 0, i, "8859_1");
                        ++i;
                        while (i < len && (b[i] == 32 || b[i] == 9)) {
                            ++i;
                        }
                        String value = new String(b, i, len - i, "8859_1");
                        this.headers.put(key.toLowerCase(), value);
                        bout.reset();
                        break;
                    }
                    ch = this.read();
                    continue;
                }
                throw new IOException();
            }
            bout.write(ch);
            ch = this.read();
        }
    }

    public Enumeration getHeaders() {
        return this.headers.keys();
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }
}

