/*
 * Decompiled with CFR 0.152.
 */
package pnuts.text;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.pnuts.io.URLHelper;
import org.pnuts.lib.PathHelper;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.text.AbstractLineReader;
import pnuts.text.CallbackLineHandler;
import pnuts.text.CollectionLineHandler;
import pnuts.text.LineHandler;
import pnuts.text.LineReader;

class readLines
extends PnutsFunction {
    public readLines() {
        super("readLines");
    }

    public boolean defined(int narg) {
        return narg >= 1 && narg <= 3;
    }

    static AbstractLineReader getLineReader(Object arg, LineHandler handler, Context context) throws IOException {
        Reader reader2;
        if (arg instanceof InputStream) {
            reader2 = new InputStreamReader((InputStream)arg);
        } else if (arg instanceof Reader) {
            reader2 = (Reader)arg;
        } else if (arg instanceof File) {
            reader2 = new FileReader((File)arg);
        } else if (arg instanceof String) {
            reader2 = new FileReader(PathHelper.getFile((String)arg, context));
        } else if (arg instanceof URL) {
            reader2 = URLHelper.getReader((URL)arg);
        } else {
            throw new IllegalArgumentException();
        }
        LineReader lineReader = new LineReader(reader2);
        lineReader.setLineHandler(handler);
        return lineReader;
    }

    static LineHandler getLineHandler(Object arg, Context context) {
        if (arg instanceof PnutsFunction) {
            return new CallbackLineHandler((PnutsFunction)arg, context);
        }
        if (arg instanceof Collection) {
            return new CollectionLineHandler((Collection)arg);
        }
        if (arg == null) {
            return new LineHandler(){

                public void process(char[] c, int offset, int length) {
                }
            };
        }
        throw new IllegalArgumentException();
    }

    protected Object exec(Object[] args, Context context) {
        boolean includeNewLine = false;
        Object arg0 = args[0];
        AbstractLineReader lineReader = null;
        switch (args.length) {
            case 3: {
                includeNewLine = (Boolean)args[2];
            }
            case 2: {
                try {
                    LineHandler handler = readLines.getLineHandler(args[1], context);
                    lineReader = readLines.getLineReader(arg0, handler, context);
                    if (handler instanceof CallbackLineHandler) {
                        CallbackLineHandler h = (CallbackLineHandler)handler;
                        h.setLineReader(lineReader);
                        h.setTerminator(Boolean.FALSE);
                    }
                    Integer n = new Integer(lineReader.processAll(includeNewLine));
                    return n;
                }
                catch (IOException e) {
                    throw new PnutsException((Throwable)e, context);
                }
                finally {
                    if (arg0 instanceof String || arg0 instanceof File || arg0 instanceof URL) {
                        try {
                            ((LineReader)lineReader).close();
                        }
                        catch (IOException e2) {
                            throw new PnutsException((Throwable)e2, context);
                        }
                    }
                }
            }
            case 1: {
                try {
                    ArrayList list2 = new ArrayList();
                    lineReader = readLines.getLineReader(arg0, readLines.getLineHandler(list2, context), context);
                    lineReader.processAll(includeNewLine);
                    ArrayList arrayList = list2;
                    return arrayList;
                }
                catch (IOException e) {
                    throw new PnutsException((Throwable)e, context);
                }
                finally {
                    if (arg0 instanceof String || arg0 instanceof File) {
                        try {
                            ((LineReader)lineReader).close();
                        }
                        catch (IOException e) {
                            throw new PnutsException((Throwable)e, context);
                        }
                    }
                }
            }
        }
        this.undefined(args, context);
        return null;
    }

    public String toString() {
        return "function readLines((inputStream|reader|file|fileName|url) {, (func(line) | collection) {, includeNewLine }} )";
    }
}

