/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.UserBean;
import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import org.apache.log4j.Logger;

public class MySQLUserManagerDAO
extends AbstractDAO
implements UserManagerDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    private static final String USER_ID = "USER_ID";
    private static final String FIRST_NAME = "FIRST_NAME";
    private static final String LAST_NAME = "LAST_NAME";
    private static final String SQL_SELECT_BY_USER_ID = "select * from USER where USER_ID = ?";

    MySQLUserManagerDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserBean findByUserID(String uid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_USER_ID);
        try {
            st.setString(1, uid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            UserBean bean = null;
            if (rs.next()) {
                bean = MySQLUserManagerDAO.createBean(rs);
            }
            UserBean userBean = bean;
            return userBean;
        }
        finally {
            st.close();
        }
    }

    static UserBean createBean(ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            columnNames.add(rs.getMetaData().getColumnName(i));
        }
        UserBean bean = new UserBean();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = ((String)columnNames.get(i)).toUpperCase();
            String attribute = (String)rs.getObject(columnName);
            if (columnName.equals(USER_ID)) {
                bean.setID(attribute);
            }
            if (columnName.equals(FIRST_NAME)) {
                bean.setFirstName(attribute);
            }
            if (columnName.equals(LAST_NAME)) {
                bean.setLastName(attribute);
            }
            if (columnName.equals(USER_ID) || columnName.equals(FIRST_NAME) || columnName.equals(LAST_NAME)) continue;
            bean.setAttribute(columnName, attribute);
        }
        return bean;
    }
}

