/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ApplicationDefinition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.engine.ActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.ConditionEvaluator;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.DefinitionRepositoryImpl;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.StartActivityRequestMessage;
import jp.co.argo21.nautica.workflow.engine.SystemMessageTransporter;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.util.DurationHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import org.apache.log4j.Logger;

public abstract class AbstractActivityBehavior
implements ActivityBehavior {
    protected static Logger eLog = LogManager.getEngineLogger();

    public void complete(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        ProcessBean pbean = proc.getBean();
        String pid = pbean.getID();
        ActivityBean abean = act.getBean();
        String bid = abean.getBlockID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        VariableDAO varDAO = daoFactory.getVariableDAO();
        List vars = varDAO.findByProcessIDAsList(pid);
        List trs = ConditionEvaluator.evaluate(pd, ad, vars, false);
        Iterator it = trs.iterator();
        ArrayList<ActivityBean> acts = new ArrayList<ActivityBean>();
        while (it.hasNext()) {
            TransitionDefinition tr = (TransitionDefinition)it.next();
            ActivityDefinition dest = tr.getDestination();
            ActivityBean ab = this.createActivity(pd, dest, pbean, bid);
            acts.add(ab);
        }
        if (acts.size() == 0) {
            this.suspend(pd, ad, proc, act);
            String F0001 = StringManager.get("F0001");
            eLog.fatal((Object)F0001);
            return;
        }
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_COMPLETED, ts);
        Iterator ait = acts.iterator();
        while (ait.hasNext()) {
            ActivityBean ab = (ActivityBean)ait.next();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            String aid = ab.getActivityID();
            StartActivityRequestMessage sarmsg = new StartActivityRequestMessage(pid, aid);
            SystemMessageTransporter mt = new SystemMessageTransporter("START_ACTIVITY_REQUEST");
            mt.sendMessage(sarmsg);
        }
    }

    public void suspend(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.OPEN_NOT_RUNNING_SUSPENDED, ts);
    }

    public void resume(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
    }

    protected ActivityBean createActivity(ProcessDefinition pd, ActivityDefinition ad, ProcessBean pbean, String bid) throws Exception {
        ActivityBean ceabean;
        String type;
        if (bid != null && !bid.trim().equals("") && (type = ad.getType()).equals("CONCUR_END") && (ceabean = this.getConcurrentEndActivity(pd, ad, pbean, bid)) != null) {
            return ceabean;
        }
        Timestamp ts = DataAccessManager.getAccessTime();
        int du = pd.getDurationUnit();
        int limit = ad.getLimit();
        long durationLimit = ts.getTime() + DurationHelper.calculateDuration(du, limit);
        Timestamp limitTs = new Timestamp(durationLimit);
        ActivityBean abean = new ActivityBean();
        abean.setActivityDefinitionID(ad.getID());
        abean.setActivityID(UniqueKeyGenerator.generate("ACI"));
        abean.setActivityState(ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.toInt());
        abean.setActorID("__SYSTEM__");
        abean.setDurationLimit(limitTs);
        abean.setProcessID(pbean.getID());
        abean.setStartDate(ts);
        abean.setStarterID(pbean.getStarterID());
        abean.setUpdateDate(ts);
        abean.setBlockID(bid);
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        actDAO.insert(abean);
        return abean;
    }

    protected ParticipantDefinition getParticipantDefinition(String pdid, String performerID) throws Exception {
        WorkflowEngine engine = WorkflowEngine.getInstance();
        DefinitionRepositoryImpl dr = engine.getDefinitionRepository();
        PackageDefinition pkgd = dr.getPackageDefinition(pdid);
        List parts = pkgd.getParticipants();
        Iterator it = parts.iterator();
        ParticipantDefinition partd = null;
        while (it.hasNext()) {
            ParticipantDefinition def = (ParticipantDefinition)it.next();
            if (!def.getID().equals(performerID)) continue;
            partd = def;
            break;
        }
        return partd;
    }

    protected ApplicationDefinition getApplicationDefinition(String pdid, String appID) throws Exception {
        WorkflowEngine engine = WorkflowEngine.getInstance();
        DefinitionRepositoryImpl dr = engine.getDefinitionRepository();
        PackageDefinition pkgd = dr.getPackageDefinition(pdid);
        List apps = pkgd.getApplications();
        Iterator it = apps.iterator();
        ApplicationDefinition appd = null;
        while (it.hasNext()) {
            ApplicationDefinition def = (ApplicationDefinition)it.next();
            if (!def.getID().equals(appID)) continue;
            appd = def;
            break;
        }
        return appd;
    }

    protected VariableDefinition getVariableDefinition(String pdid, String varID) throws Exception {
        WorkflowEngine engine = WorkflowEngine.getInstance();
        DefinitionRepositoryImpl dr = engine.getDefinitionRepository();
        PackageDefinition pkgd = dr.getPackageDefinition(pdid);
        List vars = pkgd.getVariables();
        Iterator it = vars.iterator();
        VariableDefinition vard = null;
        while (it.hasNext()) {
            VariableDefinition def = (VariableDefinition)it.next();
            if (!def.getID().equals(varID)) continue;
            vard = def;
            break;
        }
        return vard;
    }

    private ActivityBean getConcurrentEndActivity(ProcessDefinition pd, ActivityDefinition ad, ProcessBean pbean, String bid) throws Exception {
        String pid = pbean.getID();
        String adid = ad.getID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        ActivityBean abean = actDAO.findConcurrentEnd(pid, adid, bid);
        return abean;
    }
}

