/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.WorkItemInternal;
import jp.co.argo21.nautica.workflow.omg.NotAssignedException;
import jp.co.argo21.nautica.workflow.omg.WfAssignment;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;

public class ResourceInternal
implements WfResource {
    private static final long serialVersionUID = 20050000000000001L;
    private Participant participant;

    public ResourceInternal(Participant part) {
        this.participant = part;
    }

    public String getID() throws WorkflowException {
        return this.participant.getID();
    }

    public String getName() throws WorkflowException {
        return this.participant.getName();
    }

    public int getWorkItemCount() throws WorkflowException {
        try {
            String name = this.participant.getID();
            int type = this.participant.getType();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();
            return workitemDAO.findCountByParticipant(name, type);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0114 = StringManager.get("E0114");
            throw new WorkflowException(E0114, ex);
        }
    }

    public WfAssignment getWorkItem(String wid) throws WorkflowException {
        try {
            String name = this.participant.getID();
            int type = this.participant.getType();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();
            WorkItemBean bean = workitemDAO.findByPrimaryKey(wid);
            if (bean == null) {
                String E0115 = StringManager.get("E0115") + "(WorkItemID = " + wid + ")";
                throw new WorkflowException(E0115);
            }
            return new WorkItemInternal(bean);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0116 = StringManager.get("E0116") + "(WorkItemID = " + wid + ")";
            throw new WorkflowException(E0116, ex);
        }
    }

    public WfAssignment[] getAllWorkItem() throws WorkflowException {
        try {
            String name = this.participant.getID();
            int type = this.participant.getType();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();
            WorkItemBean[] beans = workitemDAO.findByParticipant(name, type);
            WfAssignment[] workitems = new WorkItemInternal[beans.length];
            for (int i = 0; i < beans.length; ++i) {
                workitems[i] = new WorkItemInternal(beans[i]);
            }
            return workitems;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0117 = StringManager.get("E0117");
            throw new WorkflowException(E0117, ex);
        }
    }

    public boolean isMemberOfWorkItems(WfAssignment ass) throws WorkflowException {
        try {
            if (ass == null || !(ass instanceof WorkItem)) {
                String E0118 = StringManager.get("E0118");
                throw new WorkflowException(E0118);
            }
            WfResource rsc = ass.getAssignee();
            if (rsc == null || !(rsc instanceof Participant)) {
                String E0119 = StringManager.get("E0119");
                throw new WorkflowException(E0119);
            }
            Participant part = (Participant)((Object)rsc);
            return part.getType() == this.participant.getType() && part.getID().equals(this.participant.getID());
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0120 = StringManager.get("E0120");
            throw new WorkflowException(E0120, ex);
        }
    }

    public void release(WfAssignment ass, String info) throws NotAssignedException, WorkflowException {
        try {
            if (!this.isMemberOfWorkItems(ass)) {
                String E0121 = StringManager.get("E0121");
                throw new WorkflowException(E0121);
            }
            WorkItemInternal workitem = (WorkItemInternal)ass;
            WorkItem bean = workitem.getWorkItem();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();
            workitemDAO.updateParticipant(bean.getID(), this.participant, null);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0122 = StringManager.get("E0122");
            throw new WorkflowException(E0122, ex);
        }
    }

    Participant getParticipant() {
        return this.participant;
    }
}

