/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ResourceManagerFactory;
import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.engine.WorkItemContainer;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.ParticipantHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import org.apache.log4j.Logger;

public class WorkItemPool {
    private static Logger eLog = LogManager.getEngineLogger();
    private static WorkItemPool singleton;
    private Map containers = new Hashtable();

    static void create() throws Exception {
        try {
            singleton = new WorkItemPool();
            singleton.init();
        }
        catch (Exception ex) {
            String E0113 = StringManager.get("E0113");
            eLog.error((Object)E0113);
            throw ex;
        }
    }

    static WorkItemPool getInstance() {
        return singleton;
    }

    private WorkItemPool() {
    }

    private void init() throws Exception {
    }

    WorkItemContainer getWorkItemContainer(String session) throws InvalidSessionException {
        try {
            SessionManagerFactory smf = SessionManagerFactory.getInstance();
            SessionManager sm = smf.getSessionManager();
            User user = sm.getSessionUser(session);
            String uid = user.getID();
            WorkItemContainer container = (WorkItemContainer)this.containers.get(uid);
            if (container == null || container.isExpired()) {
                ArrayList<Participant> orgResources = new ArrayList<Participant>();
                ArrayList<Participant> roleResources = new ArrayList<Participant>();
                Participant userResource = ParticipantHelper.narrow(user);
                ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
                OrganizationManager om = rmf.getOrganizationManager(session);
                Organization[] orgs = om.getOrganizationByUser(user);
                for (int i = 0; i < orgs.length; ++i) {
                    orgResources.add(ParticipantHelper.narrow(orgs[i]));
                }
                RoleManager rm = rmf.getRoleManager(session);
                Role[] userRoles = rm.getAttachedRoles(user);
                for (int i = 0; i < userRoles.length; ++i) {
                    roleResources.add(ParticipantHelper.narrow(userRoles[i]));
                }
                container = new WorkItemContainer(userResource, orgResources, roleResources);
                this.containers.put(uid, container);
            }
            return container;
        }
        catch (InvalidSessionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0161 = StringManager.get("E0161");
            throw new InvalidSessionException(E0161, ex);
        }
    }
}

