/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.sql.Connection;
import java.sql.Timestamp;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.ta.AbstractToolAgent;
import jp.co.argo21.nautica.workflow.ta.AppExecutionInfo;
import jp.co.argo21.nautica.workflow.ta.ApplicationState;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractToolAgentMessageAdapter
extends WorkflowMessageAdapter {
    protected Logger log = LogManager.getLogger(this.getClass());

    AbstractToolAgentMessageAdapter() {
    }

    protected AppExecutionBean getApplicationState(Connection conn, AppExecutionInfo info) throws Exception {
        AppExecutionBean bean = null;
        AppExecutionDAO appExecutionDao = null;
        WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
        appExecutionDao = factory.getAppExecutionDAO(conn);
        for (int cnt = 0; cnt < 5 && bean == null; ++cnt) {
            if (cnt != 0) {
                Thread.sleep(1000L);
            }
            bean = appExecutionDao.findByPrimaryKey(info.getAppName(), info.getToolAgent(), info.getHandler());
        }
        if (bean == null) {
            String errMsg = StringManager.get("E2009") + "APPNAME=" + info.getAppName() + ", " + "TOOL_AGENT=" + info.getToolAgent() + ", " + "EXEC_ID=" + info.getHandler();
            this.log.error((Object)errMsg);
            throw new WorkflowException(errMsg);
        }
        return bean;
    }

    protected void updateState(Connection conn, AppExecutionInfo info, ApplicationState oldState, ApplicationState newState) throws Exception {
        WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
        AppExecutionDAO appExecutionDao = factory.getAppExecutionDAO(conn);
        appExecutionDao.updateState(info.getAppName(), info.getToolAgent(), info.getHandler(), oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeApplication(Connection conn, AppExecutionInfo info, ApplicationState oldState, int result, AbstractToolAgent agent) throws Exception {
        if (result != 0 && info.getRetryCount() > 0) {
            agent.retryApplication(info);
            return;
        }
        WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
        AppExecutionDAO appExecutionDao = factory.getAppExecutionDAO(conn);
        ApplicationState resultAppState = ApplicationState.TERMINATED;
        WorkItemState resultWorkState = WorkItemState.CLOSED_TERMINATED;
        if (result == 0) {
            resultAppState = ApplicationState.COMPLETED;
            resultWorkState = WorkItemState.CLOSED_COMPLETED;
        }
        appExecutionDao.updateState(info.getAppName(), info.getToolAgent(), info.getHandler(), oldState, resultAppState, new Timestamp(System.currentTimeMillis()));
        WorkflowEngine manager = WorkflowEngine.getInstance();
        String session = null;
        try {
            session = agent.connect();
            WorkItemHandler handler = manager.getWorkItemHandler(session);
            handler.changeWorkItemState(session, info.getWid(), resultWorkState);
        }
        finally {
            if (session != null) {
                agent.disconnect(session);
            }
        }
    }
}

