/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import jp.co.argo21.nautica.workflow.ta.AbstractToolAgent;
import jp.co.argo21.nautica.workflow.ta.AppExecutionInfo;
import jp.co.argo21.nautica.workflow.ta.MailConfig;
import jp.co.argo21.nautica.workflow.ta.MailConfigFactory;
import jp.co.argo21.nautica.workflow.ta.MailExecutionInfo;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationBusyException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotDefinedException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotStoppedException;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.InvalidToolAgentException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;

public class MailToolAgent
extends AbstractToolAgent {
    MailToolAgent(String userId, String passwd) {
        this.userId = userId;
        this.passwd = passwd;
    }

    public void terminateApplication(int toolAgentHandle, String wid) throws ApplicationNotStoppedException, InvalidToolAgentException, InvalidWorkItemException, ApplicationBusyException {
        String errMsg = StringManager.get("E2002") + "(ToolAgentHandler=" + toolAgentHandle + ", " + "WorkItemID=" + wid + ")";
        this.log.error((Object)errMsg);
        throw new ApplicationNotStoppedException(errMsg);
    }

    protected String getToolAgentClassName() {
        return this.getClass().getName();
    }

    protected String getQueueName() {
        return "MAIL";
    }

    protected AppExecutionInfo getExecInfo(String appName, String wid, int handler, Attribute[] attrList) {
        return new MailExecutionInfo(appName, this.getToolAgentClassName(), wid, handler, attrList);
    }

    protected void checkApplicationDefined(String appName) throws ApplicationNotDefinedException {
        MailConfig config = null;
        try {
            config = MailConfigFactory.getConfig();
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E2004") + "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg, ex);
        }
        if (config == null || !config.existApplication(appName)) {
            String errMsg = StringManager.get("E2004") + "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg);
        }
    }
}

