/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.filter;

import java.io.IOException;
import java.util.LinkedList;
import org.activeio.FilterSynchChannel;
import org.activeio.Packet;
import org.activeio.SynchChannel;
import org.activeio.filter.PacketAggregator;

public final class PacketAggregatingSynchChannel
extends FilterSynchChannel {
    private final LinkedList assembledPackets = new LinkedList();
    private final PacketAggregator aggregator = new PacketAggregator(){

        protected void packetAssembled(Packet packet) {
            PacketAggregatingSynchChannel.this.assembledPackets.addLast(packet);
        }
    };

    public PacketAggregatingSynchChannel(SynchChannel next) {
        super(next);
    }

    public Packet read(long timeout) throws IOException {
        long start = System.currentTimeMillis();
        if (this.assembledPackets.isEmpty()) {
            block3: {
                do {
                    Packet packet;
                    if ((packet = this.getNext().read(timeout)) == null) {
                        return null;
                    }
                    this.aggregator.addRawPacket(packet);
                    if (!this.assembledPackets.isEmpty()) break block3;
                } while (timeout == -1L || (timeout = Math.max(0L, timeout - (System.currentTimeMillis() - start))) != 0L);
                return null;
            }
            return (Packet)this.assembledPackets.removeFirst();
        }
        return (Packet)this.assembledPackets.removeFirst();
    }

    public void write(Packet packet) throws IOException {
        this.getNext().write(this.aggregator.getHeader(packet));
        this.getNext().write(packet);
    }
}

