/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.filter;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.activeio.FilterSynchChannel;
import org.activeio.Packet;
import org.activeio.SynchChannel;

public class SynchornizedSynchChannel
extends FilterSynchChannel {
    private final Sync readLock;
    private final Sync writeLock;

    public SynchornizedSynchChannel(SynchChannel next) {
        this(next, (Sync)new Mutex(), (Sync)new Mutex());
    }

    public SynchornizedSynchChannel(SynchChannel next, Sync readLock, Sync writeLock) {
        super(next);
        this.readLock = readLock;
        this.writeLock = writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet read(long timeout) throws IOException {
        try {
            if (timeout == -1L) {
                this.readLock.acquire();
            } else {
                long start = System.currentTimeMillis();
                if (!this.readLock.attempt(0L)) {
                    return null;
                }
                timeout = Math.max(0L, timeout - (System.currentTimeMillis() - start));
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        try {
            Packet packet = this.getNext().read(timeout);
            return packet;
        }
        finally {
            this.readLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Packet packet) throws IOException {
        try {
            this.writeLock.acquire();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        try {
            this.getNext().write(packet);
        }
        finally {
            this.writeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        try {
            this.writeLock.acquire();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        try {
            this.getNext().flush();
        }
        finally {
            this.writeLock.release();
        }
    }

    public synchronized void dispose() {
        super.dispose();
    }

    public synchronized Object narrow(Class target) {
        return super.narrow(target);
    }

    public synchronized void start() throws IOException {
        super.start();
    }

    public synchronized void stop(long timeout) throws IOException {
        super.stop(timeout);
    }

    public Sync getReadLock() {
        return this.readLock;
    }

    public Sync getWriteLock() {
        return this.writeLock;
    }
}

