/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.journal.active;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.activeio.Disposable;
import org.activeio.Packet;
import org.activeio.packet.ByteBufferPacket;

public final class ControlFile
implements Disposable {
    private final RandomAccessFile file;
    private final FileChannel channel;
    private final ByteBufferPacket controlData;
    private long controlDataVersion = 0L;
    private FileLock lock;
    private boolean disposed;

    public ControlFile(File fileName, int controlDataSize) throws IOException {
        boolean existed = fileName.exists();
        this.file = new RandomAccessFile(fileName, "rw");
        this.channel = this.file.getChannel();
        this.controlData = new ByteBufferPacket(ByteBuffer.allocateDirect(controlDataSize));
    }

    public void lock() throws IOException {
        if (this.lock == null) {
            this.lock = this.channel.tryLock();
            if (this.lock == null) {
                throw new IOException("Journal is allready opened by another application");
            }
        }
    }

    public void unlock() throws IOException {
        if (this.lock != null) {
            this.lock.release();
            this.lock = null;
        }
    }

    public boolean load() throws IOException {
        long l = this.file.length();
        if (l < (long)this.controlData.capacity()) {
            this.controlDataVersion = 0L;
            this.controlData.position(0);
            this.controlData.limit(0);
            return false;
        }
        this.file.seek(0L);
        long v1 = this.file.readLong();
        this.file.seek(this.controlData.capacity() + 8);
        long v1check = this.file.readLong();
        this.file.seek(this.controlData.capacity() + 16);
        long v2 = this.file.readLong();
        this.file.seek(this.controlData.capacity() * 2 + 24);
        long v2check = this.file.readLong();
        if (v2 == v2check) {
            this.controlDataVersion = v2;
            this.file.seek(this.controlData.capacity() + 24);
            this.controlData.clear();
            this.channel.read(this.controlData.getByteBuffer());
        } else if (v1 == v1check) {
            this.controlDataVersion = v1;
            this.file.seek(this.controlData.capacity() + 8);
            this.controlData.clear();
            this.channel.read(this.controlData.getByteBuffer());
        } else {
            throw new IOException("Control data corrupted.");
        }
        return true;
    }

    public void store() throws IOException {
        ++this.controlDataVersion;
        this.file.setLength(this.controlData.capacity() * 2 + 32);
        this.file.seek(0L);
        this.file.writeLong(this.controlDataVersion);
        this.controlData.clear();
        this.channel.write(this.controlData.getByteBuffer());
        this.file.writeLong(this.controlDataVersion);
        this.file.writeLong(this.controlDataVersion);
        this.controlData.clear();
        this.channel.write(this.controlData.getByteBuffer());
        this.file.writeLong(this.controlDataVersion);
        this.channel.force(false);
    }

    public Packet getControlData() {
        this.controlData.clear();
        return this.controlData;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        try {
            this.unlock();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

