/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import com.ibm.io.async.AsyncServerSocketChannel;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import org.activeio.AsynchChannel;
import org.activeio.Channel;
import org.activeio.SynchChannelServer;
import org.activeio.filter.WriteBufferedAsynchChannel;
import org.activeio.net.AIOAsynchChannel;
import org.activeio.packet.ByteBufferPacket;

public class AIOSynchChannelServer
implements SynchChannelServer {
    private final AsyncServerSocketChannel serverSocket;
    private final URI bindURI;
    private final URI connectURI;
    private int curentSoTimeout;

    public AIOSynchChannelServer(AsyncServerSocketChannel serverSocket, URI bindURI, URI connectURI) throws IOException {
        this.serverSocket = serverSocket;
        this.bindURI = bindURI;
        this.connectURI = connectURI;
        this.curentSoTimeout = serverSocket.socket().getSoTimeout();
    }

    public URI getBindURI() {
        return this.bindURI;
    }

    public URI getConnectURI() {
        return this.connectURI;
    }

    public void dispose() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void start() throws IOException {
    }

    public synchronized void stop(long timeout) {
    }

    public Channel accept(long timeout) throws IOException {
        try {
            if (timeout == -1L) {
                this.setSoTimeout(0);
            } else if (timeout == 0L) {
                this.setSoTimeout(1);
            } else {
                this.setSoTimeout((int)timeout);
            }
            AsynchChannel channel = new AIOAsynchChannel(this.serverSocket.accept());
            channel = new WriteBufferedAsynchChannel(channel, ByteBufferPacket.createDefaultBuffer(true), false);
            return channel;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return null;
        }
    }

    private void setSoTimeout(int i) throws SocketException {
        if (this.curentSoTimeout != i) {
            this.serverSocket.socket().setSoTimeout(i);
            this.curentSoTimeout = i;
        }
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "AIO Server: " + this.getConnectURI();
    }
}

