/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.packet;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.activeio.Packet;
import org.activeio.packet.EmptyPacket;

public final class EOSPacket
implements Packet {
    public static final EOSPacket EOS_PACKET = new EOSPacket();

    private EOSPacket() {
    }

    public void writeTo(OutputStream out) throws IOException {
    }

    public void writeTo(DataOutput out) throws IOException {
    }

    public int position() {
        return 1;
    }

    public void position(int position) {
    }

    public int limit() {
        return 0;
    }

    public void limit(int limit) {
    }

    public void flip() {
    }

    public int remaining() {
        return -1;
    }

    public void rewind() {
    }

    public boolean hasRemaining() {
        return false;
    }

    public void clear() {
    }

    public int capacity() {
        return 0;
    }

    public Packet slice() {
        return this;
    }

    public Packet duplicate() {
        return this;
    }

    public Object duplicate(ClassLoader cl) throws IOException {
        try {
            Class<?> clazz = cl.loadClass(EOSPacket.class.getName());
            return clazz.getField("EOS_PACKET").get(null);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not duplicate packet in a different classloader: " + e).initCause(e);
        }
    }

    public int read() {
        return -1;
    }

    public int read(byte[] data, int offset, int length) {
        return -1;
    }

    public boolean write(int data) {
        return false;
    }

    public int write(byte[] data, int offset, int length) {
        return -1;
    }

    public Packet.ByteSequence asByteSequence() {
        return EmptyPacket.EMPTY_BYTE_SEQUENCE;
    }

    public byte[] sliceAsBytes() {
        return EmptyPacket.EMPTY_BYTE_ARRAY;
    }

    public int read(Packet dest) {
        return 0;
    }

    public String toString() {
        return "{position=" + this.position() + ",limit=" + this.limit() + ",capacity=" + this.capacity() + "}";
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void dispose() {
    }
}

