/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.packet;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.activeio.Packet;

public final class EmptyPacket
implements Packet {
    public static final EmptyPacket EMPTY_PACKET = new EmptyPacket();
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final Packet.ByteSequence EMPTY_BYTE_SEQUENCE = new Packet.ByteSequence(EMPTY_BYTE_ARRAY, 0, 0);

    private EmptyPacket() {
    }

    public void writeTo(OutputStream out) throws IOException {
    }

    public void writeTo(DataOutput out) throws IOException {
    }

    public int position() {
        return 0;
    }

    public void position(int position) {
    }

    public int limit() {
        return 0;
    }

    public void limit(int limit) {
    }

    public void flip() {
    }

    public int remaining() {
        return 0;
    }

    public void rewind() {
    }

    public boolean hasRemaining() {
        return false;
    }

    public void clear() {
    }

    public int capacity() {
        return 0;
    }

    public Packet slice() {
        return this;
    }

    public Packet duplicate() {
        return this;
    }

    public Object duplicate(ClassLoader cl) throws IOException {
        try {
            Class<?> clazz = cl.loadClass(EmptyPacket.class.getName());
            return clazz.getField("EMPTY_PACKET").get(null);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not duplicate packet in a different classloader: " + e).initCause(e);
        }
    }

    public int read() {
        return -1;
    }

    public int read(byte[] data, int offset, int length) {
        return -1;
    }

    public boolean write(int data) {
        return false;
    }

    public int write(byte[] data, int offset, int length) {
        return -1;
    }

    public Packet.ByteSequence asByteSequence() {
        return EMPTY_BYTE_SEQUENCE;
    }

    public byte[] sliceAsBytes() {
        return EMPTY_BYTE_ARRAY;
    }

    public int read(Packet dest) {
        return -1;
    }

    public String toString() {
        return "{position=" + this.position() + ",limit=" + this.limit() + ",capacity=" + this.capacity() + "}";
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void dispose() {
    }
}

