/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.packet;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import org.activeio.Packet;
import org.activeio.packet.FilterPacket;

public abstract class PacketPool {
    public static final int DEFAULT_POOL_SIZE = Integer.parseInt(System.getProperty("org.activeio.journal.active.DefaultPoolSize", "5"));
    public static final int DEFAULT_PACKET_SIZE = Integer.parseInt(System.getProperty("org.activeio.journal.active.DefaultPacketSize", "4194304"));
    private final ArrayList pool = new ArrayList();
    private final int maxPackets;
    private int currentPoolSize;

    public PacketPool(int maxPackets) {
        this.maxPackets = maxPackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getPacket() throws InterruptedException {
        Packet answer = null;
        PacketPool packetPool = this;
        synchronized (packetPool) {
            while (answer == null) {
                if (this.pool.size() > 0) {
                    answer = (Packet)this.pool.remove(this.pool.size() - 1);
                } else if (this.currentPoolSize < this.maxPackets) {
                    answer = this.allocateNewPacket();
                    ++this.currentPoolSize;
                }
                if (answer != null) continue;
                this.wait();
            }
        }
        return new PooledPacket(answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnPacket(Packet packet) {
        packet.clear();
        PacketPool packetPool = this;
        synchronized (packetPool) {
            this.pool.add(packet);
            this.notify();
        }
    }

    protected abstract Packet allocateNewPacket();

    public class PooledPacket
    extends FilterPacket {
        private final SynchronizedInt referenceCounter;

        public PooledPacket(Packet next) {
            this(next, new SynchronizedInt(0));
        }

        private PooledPacket(Packet next, SynchronizedInt referenceCounter) {
            super(next);
            this.referenceCounter = referenceCounter;
            this.referenceCounter.increment();
        }

        public Packet filter(Packet packet) {
            return new PooledPacket(this.next, this.referenceCounter);
        }

        int getReferenceCounter() {
            return this.referenceCounter.get();
        }

        public void dispose() {
            if (this.referenceCounter.decrement() == 0) {
                PacketPool.this.returnPacket(this.next);
            }
        }
    }
}

