/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockBean;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLConcurrencyBlockDAO
extends AbstractDAO
implements ConcurrencyBlockDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String BLOCK_ID = "BLOCK_ID";
    public static final String UPPER_BLOCK_ID = "UPPER_BLOCK_ID";
    public static final String PROC_ID = "PROC_ID";
    public static final String ACT_ID = "ACT_ID";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from CONCURBLOCK where PROC_ID = ? AND BLOCK_ID = ? ";
    private static final String SQL_SELECT_COUNT_EXIST_BY_BLOCK_ID = "select COUNT(*) from CONCURBLOCK where PROC_ID = ? AND UPPER_BLOCK_ID = ? ";
    private static final String SQL_SELECT_COUNT_EXIST_BY_PROC_ID = "select COUNT(*) from CONCURBLOCK where PROC_ID = ? ";
    private static final String SQL_INSERT = "insert into CONCURBLOCK (BLOCK_ID, UPPER_BLOCK_ID, PROC_ID, ACT_ID) values (?,?,?,?)";
    private static final String SQL_DELETE = "delete from CONCURBLOCK where PROC_ID = ? AND BLOCK_ID = ? ";

    MySQLConcurrencyBlockDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrencyBlockBean findByPrimaryKey(String pid, String bid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, pid);
            st.setString(2, bid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ConcurrencyBlockBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ConcurrencyBlockBean concurrencyBlockBean = bean;
            return concurrencyBlockBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findSubblockExistenceByBlockID(String pid, String bid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_COUNT_EXIST_BY_BLOCK_ID);
        try {
            st.setString(1, pid);
            st.setString(2, bid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            return n;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findSubblockExistenceByProcessID(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_COUNT_EXIST_BY_PROC_ID);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            return n;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ConcurrencyBlockBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getBlockID());
            st.setString(2, bean.getUpperBlockID());
            st.setString(3, bean.getProcID());
            st.setString(4, bean.getActID());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0015");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String pid, String bid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_DELETE);
        try {
            st.setString(1, pid);
            st.setString(2, bid);
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0014");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private ConcurrencyBlockBean createBean(ResultSet rs) throws SQLException {
        ConcurrencyBlockBean bean = new ConcurrencyBlockBean();
        bean.setBlockID(rs.getString(BLOCK_ID));
        bean.setUpperBlockID(rs.getString(UPPER_BLOCK_ID));
        bean.setProcID(rs.getString(PROC_ID));
        bean.setActID(rs.getString(ACT_ID));
        return bean;
    }
}

