/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import jp.co.argo21.nautica.workflow.filter.AttributeFilter;
import jp.co.argo21.nautica.workflow.filter.FilterConverter;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;

public class WorkItemFilterConverter
implements FilterConverter {
    private boolean hasAttributeFilter;

    public String convertToSQL(Filter filter) throws InvalidFilterException {
        if (filter == null) {
            return "";
        }
        if (filter instanceof AttributeFilter) {
            return this.convertToSQL((AttributeFilter)filter);
        }
        if (filter instanceof GroupFilter) {
            return this.convertToSQL((GroupFilter)filter);
        }
        String errMsg = StringManager.get("E0004");
        throw new InvalidFilterException(errMsg);
    }

    private String convertToSQL(AttributeFilter filter) throws InvalidFilterException {
        String name = filter.getFilterName();
        if (name == null) {
            String errMsg = StringManager.get("E0004");
            throw new InvalidFilterException(errMsg);
        }
        name = "'" + name + "'";
        this.hasAttributeFilter = true;
        String fs = filter.getFilterString();
        fs = fs == null ? "NULL" : "'" + fs + "'";
        String sql = "( v.NAME = " + name + " AND v." + "VALUE" + this.getComparisonString(filter.getComparison()) + fs + ")";
        return sql;
    }

    private String convertToSQL(GroupFilter filter) throws InvalidFilterException {
        Filter[] children = filter.getChild();
        int count = children.length;
        if (count == 0) {
            return "";
        }
        String s = this.convertToSQL(children[0]);
        for (int i = 1; i < count; ++i) {
            s = s + " AND " + this.convertToSQL(children[i]);
        }
        return s;
    }

    private String getComparisonString(int comparison) {
        switch (comparison) {
            case 1: {
                return " = ";
            }
            case 6: {
                return " >= ";
            }
            case 5: {
                return " > ";
            }
            case 4: {
                return " <= ";
            }
            case 3: {
                return " < ";
            }
            case 2: {
                return " <> ";
            }
            case 7: {
                return " LIKE ";
            }
        }
        return " <> ";
    }

    public boolean hasAttributeFilter() {
        return this.hasAttributeFilter;
    }
}

