/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.VariableFilterConverter;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.DefinitionRepositoryImpl;
import jp.co.argo21.nautica.workflow.engine.EndActivityRequestMessage;
import jp.co.argo21.nautica.workflow.engine.InterWorkflowConnectorImpl;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.StartActivityRequestMessage;
import jp.co.argo21.nautica.workflow.engine.SystemMessageTransporter;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.omg.AlreadyRunningException;
import jp.co.argo21.nautica.workflow.omg.AlreadySuspendedException;
import jp.co.argo21.nautica.workflow.omg.CannotChangeRequesterException;
import jp.co.argo21.nautica.workflow.omg.CannotResumeException;
import jp.co.argo21.nautica.workflow.omg.CannotStartException;
import jp.co.argo21.nautica.workflow.omg.CannotStopException;
import jp.co.argo21.nautica.workflow.omg.CannotSuspendException;
import jp.co.argo21.nautica.workflow.omg.HistoryNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.InvalidDataException;
import jp.co.argo21.nautica.workflow.omg.InvalidStateException;
import jp.co.argo21.nautica.workflow.omg.NotRunningException;
import jp.co.argo21.nautica.workflow.omg.NotSuspendedException;
import jp.co.argo21.nautica.workflow.omg.ResultNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.UpdateNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfEvent;
import jp.co.argo21.nautica.workflow.omg.WfNameValue;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfProcessManager;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.DurationHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.FormalParameter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import org.apache.log4j.Logger;

class ProcessInternal
implements WfProcess {
    private static final long serialVersionUID = 20050000000000001L;
    private static Logger eLog = LogManager.getEngineLogger();
    private Process process;
    private FormalParameter[] params;
    private WfRequester requester;

    public ProcessInternal(Process proc, FormalParameter[] params) {
        this.process = proc;
        this.params = params;
    }

    public WfRequester getRequester() throws WorkflowException {
        return this.requester;
    }

    public WfProcessManager getManager() throws WorkflowException {
        ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
        ProcessManager pm = pmf.getOwnerProcessManager(this.process.getID());
        return pm;
    }

    public String getID() throws WorkflowException {
        return this.process.getID();
    }

    public String getName() throws WorkflowException {
        return this.process.getName();
    }

    public String getDescription() throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfState getState() throws WorkflowException {
        return ProcessState.getState(this.process.getProcessState());
    }

    public WfState[] getTransitableStates() throws WorkflowException {
        return ProcessState.getTransitableStates(this.process.getProcessState());
    }

    public String getLastStateTime() throws WorkflowException {
        return this.process.getUpdateDate().toString();
    }

    public WfNameValue[] getContext() throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            WfNameValue[] beans = variableDAO.findByProcessID(this.process.getID());
            return beans;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0032 = StringManager.get("E0032");
            throw new WorkflowException(E0032, ex);
        }
    }

    public WfNameValue getContext(String name) throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            VariableBean beans = variableDAO.findByName(this.process.getID(), name);
            return beans;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0032 = StringManager.get("E0032");
            throw new WorkflowException(E0032, ex);
        }
    }

    public WfNameValue[] getResult() throws ResultNotAvailableException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public int getHistoryCount() throws HistoryNotAvailableException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfEvent getHistory(int index) throws HistoryNotAvailableException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfEvent[] getAllHistories() throws HistoryNotAvailableException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfActivity[] getActivitiesInState(String state) throws InvalidStateException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfActivity[] getAllSteps() throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfActivity getStep(String aid) throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ActivityDAO actDAO = daoFactory.getActivityDAO();
            ActivityBean bean = actDAO.findByPrimaryKey(this.process.getID(), aid);
            ActivityInternal act = null;
            if (bean != null) {
                act = new ActivityInternal(bean);
            }
            return act;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0124 = StringManager.get("E0124") + "(" + aid + ")";
            throw new WorkflowException(E0124, ex);
        }
    }

    public int getStepCount() throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public boolean isMemberOfStep(WfActivity act) throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public void setName(String name) throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO processDAO = daoFactory.getProcessDAO();
            processDAO.updateName((ProcessBean)this.process, name);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0125 = StringManager.get("E0125");
            throw new WorkflowException(E0125, ex);
        }
    }

    public void setRequester(WfRequester requester) throws CannotChangeRequesterException, WorkflowException {
        this.requester = requester;
    }

    public void setDescription(String desc) throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public void setContext(WfNameValue[] context) throws InvalidDataException, UpdateNotAllowedException, WorkflowException {
        try {
            long now = System.currentTimeMillis();
            Timestamp ts = DataAccessManager.getAccessTime();
            this.setContext(context, ts);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0080 = StringManager.get("E0080");
            throw new WorkflowException(E0080, ex);
        }
    }

    public void setContext(WfNameValue context) throws InvalidDataException, UpdateNotAllowedException, WorkflowException {
        try {
            long now = System.currentTimeMillis();
            Timestamp ts = DataAccessManager.getAccessTime();
            this.setContext(context, ts);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0080 = StringManager.get("E0080");
            throw new WorkflowException(E0080, ex);
        }
    }

    public void changeState(WfState state) throws InvalidStateException, TransitionNotAllowedException, WorkflowException {
        if (!(state instanceof ProcessState)) {
            String E0126 = StringManager.get("E0126");
            throw new InvalidStateException(E0126);
        }
        if (ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
            String E0127 = StringManager.get("E0127");
            throw new TransitionNotAllowedException(E0127);
        }
        if (ProcessState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
            this.suspend();
        } else if (ProcessState.OPEN_RUNNING.equals(state)) {
            if (ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(this.getState())) {
                this.start();
            } else {
                this.resume();
            }
        } else if (ProcessState.CLOSED_COMPLETED.equals(state)) {
            this.complete();
        } else if (ProcessState.CLOSED_TERMINATED.equals(state)) {
            this.terminate();
        } else if (ProcessState.CLOSED_ABORTED.equals(state)) {
            this.abort();
        }
        String pid = this.process.getID();
        String useInterWorkflow = System.getProperty("nautica.workflow.interworkflow");
        if (useInterWorkflow != null && useInterWorkflow.equals("enable")) {
            InterWorkflowConnectorImpl iwc = (InterWorkflowConnectorImpl)InterWorkflowConnectorImpl.getInstance();
            iwc.processStateChangedLocal(pid, (ProcessState)state);
        }
    }

    public void start() throws CannotStartException, AlreadyRunningException, WorkflowException {
        try {
            ProcessState state = (ProcessState)this.getState();
            if (ProcessState.CLOSED_COMPLETED.equals(state) || ProcessState.CLOSED_TERMINATED.equals(state) || ProcessState.CLOSED_ABORTED.equals(state)) {
                String E0128 = StringManager.get("E0128");
                throw new NotRunningException(E0128);
            }
            if (!ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
                String E0129 = StringManager.get("E0129");
                throw new AlreadyRunningException(E0129);
            }
            ProcessBean pbean = this.getBean();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            procDAO.updateState(pbean, ProcessState.OPEN_RUNNING, ts);
            String pdid = this.process.getProcDefinitionID();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
            ProcessDefinition pd = rep.getProcessDefinition(pdid);
            ActivityDefinition ad = this.findStartActivity(pd);
            ActivityBean abean = this.createActivity(pd, ad, pbean);
            String pid = abean.getProcessID();
            String aid = abean.getActivityID();
            StartActivityRequestMessage sarmsg = new StartActivityRequestMessage(pid, aid);
            SystemMessageTransporter mt = new SystemMessageTransporter("START_ACTIVITY_REQUEST");
            mt.sendMessage(sarmsg);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0132 = StringManager.get("E0132");
            throw new WorkflowException(E0132, ex);
        }
    }

    public void resume() throws CannotResumeException, NotRunningException, NotSuspendedException, WorkflowException {
        try {
            ProcessState state = (ProcessState)this.getState();
            if (ProcessState.CLOSED_COMPLETED.equals(state) || ProcessState.CLOSED_TERMINATED.equals(state) || ProcessState.CLOSED_ABORTED.equals(state)) {
                String E0128 = StringManager.get("E0128");
                throw new NotRunningException(E0128);
            }
            if (!ProcessState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
                String E0138 = StringManager.get("E0138");
                throw new NotSuspendedException(E0138);
            }
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            procDAO.updateState(this.getBean(), ProcessState.OPEN_RUNNING, ts);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0133 = StringManager.get("E0133");
            throw new WorkflowException(E0133, ex);
        }
    }

    public void suspend() throws CannotSuspendException, NotRunningException, AlreadySuspendedException, WorkflowException {
        try {
            ProcessState state = (ProcessState)this.getState();
            if (ProcessState.CLOSED_COMPLETED.equals(state) || ProcessState.CLOSED_TERMINATED.equals(state) || ProcessState.CLOSED_ABORTED.equals(state)) {
                String E0128 = StringManager.get("E0128");
                throw new NotRunningException(E0128);
            }
            if (ProcessState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
                String E0130 = StringManager.get("E0130");
                throw new AlreadySuspendedException(E0130);
            }
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            procDAO.updateState(this.getBean(), ProcessState.OPEN_NOT_RUNNING_SUSPENDED, ts);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0134 = StringManager.get("E0134");
            throw new WorkflowException(E0134, ex);
        }
    }

    public void complete() throws CannotStopException, NotRunningException, WorkflowException {
        try {
            boolean closedAlready = false;
            ProcessState state = (ProcessState)this.getState();
            if (ProcessState.CLOSED_COMPLETED.equals(state) || ProcessState.CLOSED_TERMINATED.equals(state) || ProcessState.CLOSED_ABORTED.equals(state)) {
                closedAlready = true;
            }
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            if (closedAlready) {
                procDAO.updateDate(this.getBean(), ts);
            } else {
                procDAO.updateState(this.getBean(), ProcessState.CLOSED_COMPLETED, ts);
            }
            String pid = this.process.getID();
            ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
            ProcessWaitActivityBean pwbean = pwDAO.findBySubprocessID(pid);
            if (pwbean != null && !closedAlready) {
                String rpid = pwbean.getProcID();
                String raid = pwbean.getActID();
                WorkflowEngine engine = WorkflowEngine.getInstance();
                EndActivityRequestMessage earmsg = new EndActivityRequestMessage(rpid, raid);
                SystemMessageTransporter mt = new SystemMessageTransporter("END_ACTIVITY_REQUEST");
                mt.sendMessage(earmsg);
            } else {
                String I0047 = StringManager.get("I0047") + "(" + pid + ")";
                eLog.info((Object)I0047);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0135 = StringManager.get("E0135");
            throw new WorkflowException(E0135, ex);
        }
    }

    public void terminate() throws CannotStopException, NotRunningException, WorkflowException {
        this.terminate(true);
    }

    public void abort() throws CannotStopException, NotRunningException, WorkflowException {
        this.abort(true);
    }

    WfNameValue[] getContext(Filter filter) throws WorkflowException {
        try {
            String sqlPart = new VariableFilterConverter().convertToSQL(filter);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            WfNameValue[] beans = variableDAO.findBySQLPart(this.process.getID(), sqlPart);
            return beans;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0032 = StringManager.get("E0032");
            throw new WorkflowException(E0032, ex);
        }
    }

    void setContext(WfNameValue[] context, Timestamp ts) throws InvalidDataException, UpdateNotAllowedException, WorkflowException {
        if (context == null) {
            String E0131 = StringManager.get("E0131");
            throw new InvalidDataException(E0131);
        }
        try {
            String pid = this.process.getID();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            for (int i = 0; i < context.length; ++i) {
                if (!(context[i] instanceof Attribute)) {
                    String E0139 = StringManager.get("E0139");
                    throw new InvalidDataException(E0139);
                }
                Attribute attr = (Attribute)context[i];
                VariableBean bean = new VariableBean();
                bean.setName(attr.getName());
                bean.setType(attr.getType());
                bean.setValue(attr.getValue());
                VariableBean check = variableDAO.findByPrimaryKey(bean.getProcessID(), bean.getID());
                if (check == null) {
                    bean.setProcessID(pid);
                    bean.setUpdateDate(ts);
                    bean.setID(UniqueKeyGenerator.generate("VRI"));
                    variableDAO.insert(bean, null);
                    continue;
                }
                variableDAO.update(check, bean.getValue(), null, ts);
            }
            String useInterWorkflow = System.getProperty("nautica.workflow.interworkflow");
            if (useInterWorkflow != null && useInterWorkflow.equals("enable")) {
                InterWorkflowConnectorImpl iwc = (InterWorkflowConnectorImpl)InterWorkflowConnectorImpl.getInstance();
                iwc.processAttributesChangedLocal(pid, (Attribute[])context);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0080 = StringManager.get("E0080");
            throw new WorkflowException(E0080, ex);
        }
    }

    void setContext(WfNameValue context, Timestamp ts) throws InvalidDataException, UpdateNotAllowedException, WorkflowException {
        if (context == null) {
            String E0131 = StringManager.get("E0131");
            throw new InvalidDataException(E0131);
        }
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            if (!(context instanceof Attribute)) {
                String E0139 = StringManager.get("E0139");
                throw new InvalidDataException(E0139);
            }
            Attribute attr = (Attribute)context;
            VariableBean bean = new VariableBean();
            bean.setProcessID(this.process.getID());
            bean.setName(attr.getName());
            bean.setType(attr.getType());
            bean.setValue(attr.getValue());
            VariableBean check = variableDAO.findByName(bean.getProcessID(), bean.getName());
            if (check == null) {
                bean.setUpdateDate(ts);
                bean.setID(UniqueKeyGenerator.generate("VRI"));
                variableDAO.insert(bean, null);
            } else {
                variableDAO.update(check, bean.getValue(), null, ts);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0080 = StringManager.get("E0080");
            throw new WorkflowException(E0080, ex);
        }
    }

    Activity[] getActivities(Filter filter) throws InvalidFilterException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ActivityDAO actDAO = daoFactory.getActivityDAO();
            Activity[] beans = actDAO.findByFilter(this.process.getID(), filter);
            return beans;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0124 = StringManager.get("E0124");
            throw new InvalidFilterException(E0124, ex);
        }
    }

    ProcessBean getBean() {
        return (ProcessBean)this.process;
    }

    void terminate(boolean checkChild) throws CannotStopException, NotRunningException, WorkflowException {
        try {
            boolean closedAlready = false;
            ProcessState state = (ProcessState)this.getState();
            if (ProcessState.CLOSED_COMPLETED.equals(state) || ProcessState.CLOSED_TERMINATED.equals(state) || ProcessState.CLOSED_ABORTED.equals(state)) {
                closedAlready = true;
            }
            String pid = this.process.getID();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            if (closedAlready) {
                procDAO.updateDate(this.getBean(), ts);
            } else {
                procDAO.updateState(this.getBean(), ProcessState.CLOSED_TERMINATED, ts);
                if (checkChild) {
                    ActivityDAO actDAO = daoFactory.getActivityDAO();
                    ActivityBean[] acts = actDAO.findOpeningActivityByProcessID(pid);
                    for (int i = 0; i < acts.length; ++i) {
                        String aid = acts[i].getActivityID();
                        ActivityInternal act = (ActivityInternal)this.getStep(aid);
                        act.abort();
                    }
                }
            }
            ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
            ProcessWaitActivityBean pwbean = pwDAO.findBySubprocessID(pid);
            if (pwbean != null && !closedAlready) {
                String rpid = pwbean.getProcID();
                String raid = pwbean.getActID();
                WorkflowEngine engine = WorkflowEngine.getInstance();
                EndActivityRequestMessage earmsg = new EndActivityRequestMessage(rpid, raid, ProcessState.CLOSED_TERMINATED);
                SystemMessageTransporter mt = new SystemMessageTransporter("END_ACTIVITY_REQUEST");
                mt.sendMessage(earmsg);
            } else {
                String I0048 = StringManager.get("I0048") + "(" + pid + ")";
                eLog.info((Object)I0048);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0136 = StringManager.get("E0136");
            throw new WorkflowException(E0136, ex);
        }
    }

    void abort(boolean checkChild) throws CannotStopException, NotRunningException, WorkflowException {
        try {
            boolean closedAlready = false;
            ProcessState state = (ProcessState)this.getState();
            if (ProcessState.CLOSED_COMPLETED.equals(state) || ProcessState.CLOSED_TERMINATED.equals(state) || ProcessState.CLOSED_ABORTED.equals(state)) {
                closedAlready = true;
            }
            String pid = this.process.getID();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            if (closedAlready) {
                procDAO.updateDate(this.getBean(), ts);
            } else {
                procDAO.updateState(this.getBean(), ProcessState.CLOSED_ABORTED, ts);
                if (checkChild) {
                    ActivityDAO actDAO = daoFactory.getActivityDAO();
                    ActivityBean[] acts = actDAO.findOpeningActivityByProcessID(pid);
                    for (int i = 0; i < acts.length; ++i) {
                        String aid = acts[i].getActivityID();
                        ActivityInternal act = (ActivityInternal)this.getStep(aid);
                        act.abort();
                    }
                }
            }
            ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
            ProcessWaitActivityBean pwbean = pwDAO.findBySubprocessID(pid);
            if (pwbean != null && !closedAlready) {
                String rpid = pwbean.getProcID();
                String raid = pwbean.getActID();
                WorkflowEngine engine = WorkflowEngine.getInstance();
                EndActivityRequestMessage earmsg = new EndActivityRequestMessage(rpid, raid, ProcessState.CLOSED_ABORTED);
                SystemMessageTransporter mt = new SystemMessageTransporter("END_ACTIVITY_REQUEST");
                mt.sendMessage(earmsg);
            } else if (!closedAlready) {
                String I0049 = StringManager.get("I0049") + "(" + pid + ")";
                eLog.info((Object)I0049);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0137 = StringManager.get("E0137");
            throw new WorkflowException(E0137, ex);
        }
    }

    private ActivityDefinition findStartActivity(ProcessDefinition pd) throws Exception {
        List acts = pd.getActivities();
        Iterator it = acts.iterator();
        ActivityDefinition ad = null;
        while (it.hasNext()) {
            ActivityDefinition def = (ActivityDefinition)it.next();
            if (!def.getType().equals("START")) continue;
            ad = def;
            break;
        }
        if (ad == null) {
            String E0140 = StringManager.get("E0140");
            throw new WorkflowException(E0140);
        }
        return ad;
    }

    private ActivityBean createActivity(ProcessDefinition pd, ActivityDefinition ad, ProcessBean pbean) throws Exception {
        Timestamp ts = DataAccessManager.getAccessTime();
        int du = pd.getDurationUnit();
        int limit = ad.getLimit();
        long durationLimit = ts.getTime() + DurationHelper.calculateDuration(du, limit);
        Timestamp limitTs = new Timestamp(durationLimit);
        ActivityBean abean = new ActivityBean();
        abean.setActivityDefinitionID(ad.getID());
        abean.setActivityID(UniqueKeyGenerator.generate("ACI"));
        abean.setActivityState(ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.toInt());
        abean.setActorID("__SYSTEM__");
        abean.setDurationLimit(limitTs);
        abean.setProcessID(pbean.getID());
        abean.setStartDate(ts);
        abean.setStarterID(pbean.getStarterID());
        abean.setUpdateDate(ts);
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        actDAO.insert(abean);
        return abean;
    }
}

