/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import jp.co.argo21.nautica.workflow.ta.AbstractToolAgent;
import jp.co.argo21.nautica.workflow.ta.AppExecutionInfo;
import jp.co.argo21.nautica.workflow.ta.ScriptingConfig;
import jp.co.argo21.nautica.workflow.ta.ScriptingConfigFactory;
import jp.co.argo21.nautica.workflow.ta.ScriptingExecutionInfo;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationBusyException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotDefinedException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotStoppedException;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.InvalidToolAgentException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;

public class ScriptingToolAgent
extends AbstractToolAgent {
    public static final String LOCAL_SCRIPT_PATH;

    ScriptingToolAgent(String userId, String passwd) {
        this.userId = userId;
        this.passwd = passwd;
    }

    public void terminateApplication(int toolAgentHandle, String wid) throws ApplicationNotStoppedException, InvalidToolAgentException, InvalidWorkItemException, ApplicationBusyException {
        String errMsg = StringManager.get("E2002") + "(ToolAgentHandler=" + toolAgentHandle + ", " + "WorkItemID=" + wid + ")";
        this.log.error((Object)errMsg);
        throw new ApplicationNotStoppedException(errMsg);
    }

    protected String getToolAgentClassName() {
        return this.getClass().getName();
    }

    protected String getQueueName() {
        return "SCRIPTING";
    }

    protected AppExecutionInfo getExecInfo(String appName, String wid, int handler, Attribute[] attrList) {
        return new ScriptingExecutionInfo(appName, this.getToolAgentClassName(), wid, handler, attrList);
    }

    protected void checkApplicationDefined(String appName) throws ApplicationNotDefinedException {
        ScriptingConfig config = null;
        try {
            config = ScriptingConfigFactory.getConfig();
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E2004") + "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg, ex);
        }
        if (config == null || !config.existApplication(appName)) {
            String errMsg = StringManager.get("E2004") + "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg);
        }
    }

    static {
        String separator = System.getProperty("file.separator");
        LOCAL_SCRIPT_PATH = TOOLAGENT_PATH + separator + "scripting";
    }
}

