/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.ta.AbstractToolAgent;
import jp.co.argo21.nautica.workflow.ta.AppExecutionInfo;
import jp.co.argo21.nautica.workflow.ta.ApplicationState;
import jp.co.argo21.nautica.workflow.ta.SystemCommandConfig;
import jp.co.argo21.nautica.workflow.ta.SystemCommandConfigFactory;
import jp.co.argo21.nautica.workflow.ta.SystemCommandExecutionInfo;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationBusyException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotDefinedException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotStoppedException;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.InvalidToolAgentException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;

public class SystemCommandToolAgent
extends AbstractToolAgent {
    private static Map processes = Collections.synchronizedMap(new HashMap());
    public static final String LOCAL_COMMAND_PATH;

    SystemCommandToolAgent(String userId, String passwd) {
        this.userId = userId;
        this.passwd = passwd;
    }

    public static void setProcess(long handle, Process process) {
        processes.put(new Long(handle), process);
    }

    protected static Process getProcess(long handle) {
        return (Process)processes.get(new Long(handle));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminateApplication(int toolAgentHandle, String wid) throws ApplicationNotStoppedException, InvalidToolAgentException, InvalidWorkItemException, ApplicationBusyException {
        String msg = StringManager.get("I2003") + "(ToolAgentHandler=" + toolAgentHandle + ", " + "WorkItemID=" + wid + ")";
        this.log.info((Object)msg);
        Process process = SystemCommandToolAgent.getProcess(toolAgentHandle);
        if (process == null) {
            String errMsg = StringManager.get("E2002") + "(ToolAgentHandler=" + toolAgentHandle + ", " + "WorkItemID=" + wid + ")";
            this.log.error((Object)errMsg);
            throw new InvalidToolAgentException(errMsg);
        }
        Connection conn = null;
        String session = null;
        try {
            try {
                DataSource ds = DataAccessManager.getDataSource();
                conn = ds.getConnection();
                WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
                AppExecutionDAO appExecutionDao = factory.getAppExecutionDAO(conn);
                List beans = appExecutionDao.findByExecID(toolAgentHandle);
                if (beans.size() != 1) {
                    String errMsg = StringManager.get("E2002") + "(ToolAgentHandler=" + toolAgentHandle + ", " + "WorkItemID=" + wid + ")";
                    throw new InvalidToolAgentException(errMsg);
                }
                AppExecutionBean bean = (AppExecutionBean)beans.get(0);
                conn.setAutoCommit(false);
                process.destroy();
                appExecutionDao.updateState(bean.getAppName(), bean.getToolAgent(), bean.getExecId(), bean.getAppState(), ApplicationState.TERMINATED, new Timestamp(System.currentTimeMillis()));
                conn.commit();
                WorkflowEngine manager = WorkflowEngine.getInstance();
                session = this.connect();
                WorkItemHandler handler = manager.getWorkItemHandler(session);
                handler.changeWorkItemState(session, wid, WorkItemState.CLOSED_TERMINATED);
            }
            catch (Exception ex) {
                try {
                    conn.rollback();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                String errMsg = StringManager.get("E2002") + "(ToolAgentHandler=" + toolAgentHandle + ", " + "WorkItemID=" + wid + ")";
                this.log.error((Object)errMsg, (Throwable)ex);
                throw new InvalidToolAgentException(errMsg);
            }
            Object var15_19 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
                if (session == null) throw throwable;
                this.disconnect(session);
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
        if (session != null) {
            this.disconnect(session);
        }
        this.log.info((Object)StringManager.get("I2004"));
    }

    protected String getToolAgentClassName() {
        return this.getClass().getName();
    }

    protected String getQueueName() {
        return "SYSTEM_COMMAND";
    }

    protected AppExecutionInfo getExecInfo(String appName, String wid, int handler, Attribute[] attrList) {
        return new SystemCommandExecutionInfo(appName, this.getToolAgentClassName(), wid, handler, attrList);
    }

    protected void checkApplicationDefined(String appName) throws ApplicationNotDefinedException {
        SystemCommandConfig config = null;
        try {
            config = SystemCommandConfigFactory.getConfig();
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E2004") + "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg, ex);
        }
        if (config == null || !config.existApplication(appName)) {
            String errMsg = StringManager.get("E2004") + "(ApplicationName=" + appName + ")";
            throw new ApplicationNotDefinedException(errMsg);
        }
    }

    static {
        String separator = System.getProperty("file.separator");
        LOCAL_COMMAND_PATH = TOOLAGENT_PATH + separator + "commands";
    }
}

