/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nautica.workflow.definition.ApplicationDefinition;
import jp.co.argo21.nautica.workflow.definition.Definition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.definition.impl.ApplicationDefinitionImpl;
import jp.co.argo21.nautica.workflow.definition.impl.ParticipantDefinitionImpl;
import jp.co.argo21.nautica.workflow.definition.impl.ProcessDefinitionImpl;
import jp.co.argo21.nautica.workflow.definition.impl.VariableDefinitionImpl;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;
import org.wfmc.x2002.xpdl10.ApplicationDocument;
import org.wfmc.x2002.xpdl10.ApplicationsDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataFieldsDocument;
import org.wfmc.x2002.xpdl10.PackageDocument;
import org.wfmc.x2002.xpdl10.PackageHeaderDocument;
import org.wfmc.x2002.xpdl10.ParticipantDocument;
import org.wfmc.x2002.xpdl10.ParticipantsDocument;
import org.wfmc.x2002.xpdl10.RedefinableHeaderDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessesDocument;

public class PackageDefinitionImpl
implements PackageDefinition {
    private static final long serialVersionUID = 20050000000000001L;
    private static final String UNINITIALIZED_ID = "--UNINITIALIZED--";
    private String id;
    private String name;
    private String description;
    private String createdDate;
    private String version;
    private String author;
    private List participants = new ArrayList();
    private List applications = new ArrayList();
    private List variables = new ArrayList();
    private List processes = new ArrayList();

    public PackageDefinitionImpl(PackageDocument doc) {
        Definition e;
        int i;
        int count;
        PackageDocument.Package p = doc.getPackage();
        String id = p.getId();
        if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
            this.setID(IDGenerator.generate("PK"));
        } else {
            this.setID(id);
        }
        this.setName(p.getName());
        PackageHeaderDocument.PackageHeader phd = p.getPackageHeader();
        this.setDescription(phd.getDescription());
        this.setCreatedDate(phd.getCreated());
        if (p.isSetRedefinableHeader()) {
            RedefinableHeaderDocument.RedefinableHeader rhd = p.getRedefinableHeader();
            this.setAuthor(rhd.getAuthor());
            this.setVersion(rhd.getVersion());
        }
        if (p.isSetApplications()) {
            ApplicationsDocument.Applications apps = p.getApplications();
            count = apps.sizeOfApplicationArray();
            for (i = 0; i < count; ++i) {
                ApplicationDocument.Application app = apps.getApplicationArray(i);
                e = new ApplicationDefinitionImpl(app);
                this.addApplication((ApplicationDefinition)e);
            }
        }
        if (p.isSetParticipants()) {
            ParticipantsDocument.Participants pts = p.getParticipants();
            count = pts.sizeOfParticipantArray();
            for (i = 0; i < count; ++i) {
                ParticipantDocument.Participant pt = pts.getParticipantArray(i);
                e = new ParticipantDefinitionImpl(pt);
                this.addParticipant((ParticipantDefinition)e);
            }
        }
        if (p.isSetDataFields()) {
            DataFieldsDocument.DataFields dfs = p.getDataFields();
            count = dfs.sizeOfDataFieldArray();
            for (i = 0; i < count; ++i) {
                DataFieldDocument.DataField df = dfs.getDataFieldArray(i);
                e = new VariableDefinitionImpl(df);
                this.addVariable((VariableDefinition)e);
            }
        }
        if (p.isSetWorkflowProcesses()) {
            WorkflowProcessesDocument.WorkflowProcesses wps = p.getWorkflowProcesses();
            count = wps.sizeOfWorkflowProcessArray();
            for (i = 0; i < count; ++i) {
                WorkflowProcessDocument.WorkflowProcess proc = wps.getWorkflowProcessArray(i);
                e = new ProcessDefinitionImpl(proc);
                this.addProcess((ProcessDefinition)e);
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List getApplications() {
        return this.applications;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public List getParticipants() {
        return this.participants;
    }

    public List getProcesses() {
        return this.processes;
    }

    public List getVariables() {
        return this.variables;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    private void setID(String id) {
        this.id = id;
    }

    private void setDescription(String desc) {
        this.description = desc;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setCreatedDate(String s) {
        this.createdDate = s;
    }

    private void setVersion(String s) {
        this.version = s;
    }

    private void setAuthor(String s) {
        this.author = s;
    }

    private void addApplication(ApplicationDefinition app) {
        this.applications.add(app);
    }

    private void addParticipant(ParticipantDefinition part) {
        this.participants.add(part);
    }

    private void addProcess(ProcessDefinition proc) {
        this.processes.add(proc);
    }

    private void addVariable(VariableDefinition var) {
        this.variables.add(var);
    }
}

