/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.Definition;
import jp.co.argo21.nautica.workflow.definition.ParameterDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.definition.impl.ActivityDefinitionImpl;
import jp.co.argo21.nautica.workflow.definition.impl.ParameterDefinitionImpl;
import jp.co.argo21.nautica.workflow.definition.impl.TransitionDefinitionImpl;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;
import org.wfmc.x2002.xpdl10.ActivitiesDocument;
import org.wfmc.x2002.xpdl10.ActivityDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributesDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;
import org.wfmc.x2002.xpdl10.FormalParametersDocument;
import org.wfmc.x2002.xpdl10.ProcessHeaderDocument;
import org.wfmc.x2002.xpdl10.RedefinableHeaderDocument;
import org.wfmc.x2002.xpdl10.ResponsiblesDocument;
import org.wfmc.x2002.xpdl10.TransitionDocument;
import org.wfmc.x2002.xpdl10.TransitionsDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;

public class ProcessDefinitionImpl
implements ProcessDefinition {
    private static final long serialVersionUID = 20050000000000001L;
    private static final String UNINITIALIZED_ID = "--UNINITIALIZED--";
    private String id;
    private String name;
    private String description;
    private int durationUnit;
    private int limit;
    private int accessLevel;
    private int logicalWidth;
    private int logicalHeight;
    private List responsibles = new ArrayList();
    private List parameters = new ArrayList();
    private List activities = new ArrayList();
    private List transitions = new ArrayList();

    public ProcessDefinitionImpl(WorkflowProcessDocument.WorkflowProcess proc) {
        Definition e;
        int i;
        RedefinableHeaderDocument.RedefinableHeader rhd;
        String id = proc.getId();
        if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
            this.setID(IDGenerator.generate("PS"));
        } else {
            this.setID(id);
        }
        this.setName(proc.getName());
        ProcessHeaderDocument.ProcessHeader ph = proc.getProcessHeader();
        this.setDescription(ph.getDescription());
        this.setDurationUnit(ph.getDurationUnit().intValue());
        try {
            this.setLimit(Integer.parseInt(ph.getLimit()));
        }
        catch (Exception ex) {
            this.setLimit(0);
        }
        this.setAccessLevel(proc.getAccessLevel().intValue());
        if (proc.isSetRedefinableHeader() && (rhd = proc.getRedefinableHeader()).isSetResponsibles()) {
            ResponsiblesDocument.Responsibles rsps = rhd.getResponsibles();
            int count = rsps.sizeOfResponsibleArray();
            for (int i2 = 0; i2 < count; ++i2) {
                String rsp = rsps.getResponsibleArray(i2);
                this.addResponsible(rsp);
            }
        }
        if (proc.isSetExtendedAttributes()) {
            ExtendedAttributesDocument.ExtendedAttributes eas = proc.getExtendedAttributes();
            int count = eas.sizeOfExtendedAttributeArray();
            for (i = 0; i < count; ++i) {
                ExtendedAttributeDocument.ExtendedAttribute ea = eas.getExtendedAttributeArray(i);
                String n = ea.getName();
                String v = ea.getValue();
                if (n.equals("LOGICAL_WIDTH")) {
                    this.setLogicalWidth(Integer.parseInt(v));
                    continue;
                }
                if (!n.equals("LOGICAL_HEIGHT")) continue;
                this.setLogicalHeight(Integer.parseInt(v));
            }
        }
        if (proc.isSetFormalParameters()) {
            FormalParametersDocument.FormalParameters pms = proc.getFormalParameters();
            int count = pms.sizeOfFormalParameterArray();
            for (i = 0; i < count; ++i) {
                FormalParameterDocument.FormalParameter pm = pms.getFormalParameterArray(i);
                e = new ParameterDefinitionImpl(pm);
                this.addParameter((ParameterDefinition)e);
            }
        }
        if (proc.isSetActivities()) {
            ActivitiesDocument.Activities acts = proc.getActivities();
            int count = acts.sizeOfActivityArray();
            for (i = 0; i < count; ++i) {
                ActivityDocument.Activity act = acts.getActivityArray(i);
                e = new ActivityDefinitionImpl(act);
                this.addActivity((ActivityDefinition)e);
            }
        }
        if (proc.isSetTransitions()) {
            TransitionsDocument.Transitions trs = proc.getTransitions();
            int count = trs.sizeOfTransitionArray();
            for (i = 0; i < count; ++i) {
                TransitionDocument.Transition tr = trs.getTransitionArray(i);
                e = new TransitionDefinitionImpl(tr, this.getActivities());
                this.addTransition((TransitionDefinition)e);
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List getActivities() {
        return this.activities;
    }

    public int getDurationUnit() {
        return this.durationUnit;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    public int getLogicalWidth() {
        return this.logicalWidth;
    }

    public List getParameters() {
        return this.parameters;
    }

    public List getTransitions() {
        return this.transitions;
    }

    public List getResponsibles() {
        return this.responsibles;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    private void setID(String id) {
        this.id = id;
    }

    private void setAccessLevel(int i) {
        this.accessLevel = i;
    }

    private void setDescription(String desc) {
        this.description = desc;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setDurationUnit(int i) {
        this.durationUnit = i;
    }

    private void setLimit(int i) {
        this.limit = i;
    }

    private void setLogicalHeight(int i) {
        this.logicalHeight = i;
    }

    private void setLogicalWidth(int i) {
        this.logicalWidth = i;
    }

    private void addActivity(ActivityDefinition act) {
        this.activities.add(act);
    }

    private void addParameter(ParameterDefinition param) {
        this.parameters.add(param);
    }

    private void addResponsible(String r) {
        this.responsibles.add(r);
    }

    private void addTransition(TransitionDefinition tr) {
        this.transitions.add(tr);
    }
}

