/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.security.SessionManager;

public class AuditPrefix {
    private static final String INITIAL_PI_ID = "argo21";
    private static final String DOMAIN_ID = "nautica";
    private static final String NODE_ID = System.getProperty("nautica.workflow.scope");
    private String currentPI = "";
    private String state = "";
    private String eventcode = "";
    private String userID = "";
    private String infoID = "WfMC";

    AuditPrefix(String currentPI, String eventcode, String sid) {
        this.currentPI = currentPI;
        this.eventcode = eventcode;
        if (sid == null || sid.trim().equals("")) {
            return;
        }
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
        SessionManager manager = factory.getSessionManager();
        try {
            this.userID = manager.getSessionUser(sid).getID();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    AuditPrefix(String currentPI, String eventcode) {
        this.currentPI = currentPI;
        this.eventcode = eventcode;
    }

    AuditPrefix(String eventcode) {
        this.eventcode = eventcode;
    }

    AuditPrefix() {
    }

    void setCurrentPI(String currentPI) {
        this.currentPI = currentPI;
    }

    void setState(String state) {
        this.state = state;
    }

    void setEventCode(String eventcode) {
        this.eventcode = eventcode;
    }

    void setUserID(String userID) {
        this.userID = userID;
    }

    void setInfoID(String infoID) {
        this.infoID = infoID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(InitialProcessInstanceID=argo21)");
        sb.append("(DomainID=nautica)");
        sb.append("(NodeID=" + NODE_ID + ")");
        sb.append("(CurrentProcessInstanceID=" + this.currentPI + ")");
        sb.append("(ProcessState=" + this.state + ")");
        sb.append("(EventCode=" + this.eventcode + ")");
        sb.append("(UserID=" + this.userID + ")");
        sb.append("(InformationID=" + this.infoID + ")");
        return sb.toString();
    }
}

