/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.EndActivityRequestMessage;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import org.apache.log4j.Logger;

class EndActivityRequestWatcher
extends WorkflowMessageAdapter {
    private static Logger eLog = LogManager.getEngineLogger();
    public static final String NAME = "END_ACTIVITY_REQUEST";

    EndActivityRequestWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(WorkflowMessage message) {
        if (!(message instanceof EndActivityRequestMessage)) {
            String E0099 = StringManager.get("E0099");
            eLog.error((Object)E0099);
            return;
        }
        EndActivityRequestMessage msg = (EndActivityRequestMessage)message;
        String pid = msg.getProcessID();
        String aid = msg.getActivityID();
        ActivityInternal act = null;
        try {
            DataAccessManager.begin(false);
            ProcessState subprocState = msg.getSubprocessState();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
            act = (ActivityInternal)proc.getStep(aid);
            if (subprocState == null || ProcessState.CLOSED_COMPLETED.equals(subprocState)) {
                act.complete();
            } else if (ProcessState.CLOSED_TERMINATED.equals(subprocState)) {
                act.terminate(false);
            } else if (ProcessState.CLOSED_ABORTED.equals(subprocState)) {
                act.abort(false);
            }
        }
        catch (Exception ex) {
            try {
                String E0103 = StringManager.get("E0103");
                eLog.error((Object)E0103, (Throwable)ex);
                act.terminate(false);
            }
            catch (Exception ex2) {
                String F0103 = StringManager.get("F0103");
                eLog.fatal((Object)F0103, (Throwable)ex);
            }
        }
        finally {
            try {
                DataAccessManager.commit();
            }
            catch (Exception ex3) {}
        }
    }
}

