/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.engine.AuditDataRecord;
import jp.co.argo21.nautica.workflow.engine.AuditPrefix;
import jp.co.argo21.nautica.workflow.engine.AuditSuffix;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.engine.WorkItemContainer;
import jp.co.argo21.nautica.workflow.engine.WorkItemPool;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSourceUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidTargetUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;
import org.apache.log4j.Logger;

public class WorkItemHandlerImpl
implements WorkItemHandler {
    private static Logger eLog = LogManager.getEngineLogger();
    private static Logger audit = LogManager.getAuditLogger();

    WorkItemHandlerImpl() {
    }

    public WorkItem[] getWorkItems(String session, Filter filter) throws InvalidSessionException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getWorkItems,session = [" + session + "]," + "filter = [" + filter + "])";
        try {
            DataAccessManager.begin(false);
            this.validateSession(session);
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            WorkItem[] workItems = container.getWorkItems(filter);
            DataAccessManager.commit();
            return workItems;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0174 = StringManager.get("E0174") + argInfo;
            eLog.error((Object)E0174, (Throwable)ex);
            throw new InvalidFilterException(E0174, ex);
        }
    }

    public WorkItem getWorkItem(String session, String wid) throws InvalidSessionException, InvalidWorkItemException {
        String argInfo = "(NAUTICA API = getWorkItem,session = [" + session + "]," + "work item id = [" + wid + "])";
        try {
            this.checkWorkItemID(wid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMSelectedWorkitem", session), new AuditSuffix());
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            WorkItem workItem = container.getWorkItem(wid);
            data.setDataElement("ActivityInstanceID", workItem.getActivityID());
            DataAccessManager.commit();
            data.setDataElement("WorkItemID", wid);
            audit.info((Object)data);
            return workItem;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0116 = StringManager.get("E0116") + argInfo;
            eLog.error((Object)E0116, (Throwable)ex);
            throw new InvalidWorkItemException(E0116, ex);
        }
    }

    public void completeWorkItem(String session, String wid) throws InvalidSessionException, InvalidWorkItemException {
        String argInfo = "(NAUTICA API = completeWorkItem,session = [" + session + "]," + "work item id = [" + wid + "])";
        try {
            this.checkWorkItemID(wid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMCompletedWorkitem", session), new AuditSuffix());
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            data.setDataElement("ActivityInstanceID", container.getWorkItem(wid).getActivityID());
            container.changeWorkItemState(session, wid, WorkItemState.CLOSED_COMPLETED);
            DataAccessManager.commit();
            data.setDataElement("WorkItemID", wid);
            data.setDataElement("WorkItemState", WorkItemState.CLOSED_COMPLETED);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0175 = StringManager.get("E0175") + argInfo;
            eLog.error((Object)E0175, (Throwable)ex);
            throw new InvalidWorkItemException(E0175, ex);
        }
    }

    public WorkItemState[] getWorkItemStates(String session, String wid, Filter filter) throws InvalidSessionException, InvalidWorkItemException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getWorkItemStates,session = [" + session + "]," + "work item id = [" + wid + "]," + "filter = [" + filter + "])";
        try {
            this.checkWorkItemID(wid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            WorkItemState[] states = container.getWorkItemStates(wid, filter);
            DataAccessManager.commit();
            return states;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0176 = StringManager.get("E0176") + argInfo;
            eLog.error((Object)E0176, (Throwable)ex);
            throw new InvalidWorkItemException(E0176, ex);
        }
    }

    public void changeWorkItemState(String session, String wid, WorkItemState state) throws InvalidSessionException, InvalidWorkItemException, InvalidStateException, TransitionNotAllowedException {
        String argInfo = "(NAUTICA API = changeWorkItemState,session = [" + session + "]," + "work item id = [" + wid + "]," + "state = [" + state + "])";
        try {
            this.checkWorkItemID(wid);
            if (state == null) {
                String E0191 = StringManager.get("E0191");
                throw new InvalidStateException(E0191);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            String aid = container.getWorkItem(wid).getActivityID();
            container.changeWorkItemState(session, wid, state);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMChangedWorkitemState", session), new AuditSuffix());
            data.setDataElement("ActivityInstanceID", aid);
            data.setDataElement("WorkItemID", wid);
            data.setDataElement("WorkItemState", state);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidStateException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            String E0177 = StringManager.get("E0177") + argInfo;
            eLog.error((Object)E0177, (Throwable)ex);
            throw new InvalidWorkItemException(E0177, ex);
        }
    }

    public void reassignWorkItem(String session, Participant sourceUser, Participant targetUser, String wid) throws InvalidSessionException, InvalidWorkItemException, InvalidSourceUserException, InvalidTargetUserException {
        String argInfo = "(NAUTICA API = reassignWorkItem,session = [" + session + "]," + "sourceUser = [" + sourceUser + "]," + "targetUser = [" + targetUser + "]," + "work item id = [" + wid + "])";
        try {
            if (sourceUser == null) {
                String E0195 = StringManager.get("E0195");
                throw new InvalidSourceUserException(E0195);
            }
            if (targetUser == null) {
                String E0196 = StringManager.get("E0196");
                throw new InvalidTargetUserException(E0196);
            }
            this.checkWorkItemID(wid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMReassignedWorkitem", session), new AuditSuffix());
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            data.setDataElement("ActivityInstanceID", container.getWorkItem(wid).getActivityID());
            container.reassignWorkItem(wid, sourceUser, targetUser);
            DataAccessManager.commit();
            data.setDataElement("WorkItemID", wid);
            data.setDataElement("TargetDomainID", "nautica");
            data.setDataElement("TargetNodeID", System.getProperty("nautica.workflow.scope"));
            data.setDataElement("SourceUserID", sourceUser.getID());
            data.setDataElement("TargetUserID", targetUser.getID());
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidTargetUserException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0178 = StringManager.get("E0178") + argInfo;
            eLog.error((Object)E0178, (Throwable)ex);
            throw new InvalidWorkItemException(E0178, ex);
        }
    }

    public Attribute[] getWorkItemAttributes(String session, String wid, Filter filter) throws InvalidSessionException, InvalidWorkItemException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getWorkItemAttributes,session = [" + session + "]," + "work item id = [" + wid + "]," + "filter = [" + filter + "])";
        try {
            this.checkWorkItemID(wid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            Attribute[] attrs = container.getWorkItemAttributes(session, wid, filter);
            DataAccessManager.commit();
            return attrs;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0179 = StringManager.get("E0179") + argInfo;
            eLog.error((Object)E0179, (Throwable)ex);
            throw new InvalidWorkItemException(E0179, ex);
        }
    }

    public Attribute getWorkItemAttributeValue(String session, String wid, String name) throws InvalidSessionException, InvalidWorkItemException, InvalidAttributeException {
        String argInfo = "(NAUTICA API = getWorkItemAttributeValue,session = [" + session + "]," + "work item id = [" + wid + "]," + "attr name = [" + name + "])";
        try {
            this.checkWorkItemID(wid);
            if (name == null || name.trim().equals("")) {
                String E0194 = StringManager.get("E0194");
                throw new InvalidAttributeException(E0194);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            DataAccessManager.commit();
            return container.getWorkItemAttributeValue(wid, name);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0179 = StringManager.get("E0179") + argInfo;
            eLog.error((Object)E0179, (Throwable)ex);
            throw new InvalidAttributeException(E0179, ex);
        }
    }

    public void assignWorkItemAttribute(String session, String wid, Attribute attr) throws InvalidSessionException, InvalidWorkItemException, InvalidAttributeException, AttributeAssignmentFailedException {
        String argInfo = "(NAUTICA API = assignWorkItemAttribute,session = [" + session + "]," + "work item id = [" + wid + "]," + "attr = [" + attr + "])";
        try {
            this.checkWorkItemID(wid);
            if (attr == null) {
                String E0193 = StringManager.get("E0193");
                throw new InvalidAttributeException(E0193);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMAssignedWorkitemAttributes", session), new AuditSuffix());
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemContainer container = pool.getWorkItemContainer(session);
            container.assignWorkItemAttribute(session, wid, attr);
            data.setDataElement("ActivityInstanceID", container.getWorkItem(wid).getActivityID());
            DataAccessManager.commit();
            data.setDataElement("WorkItemID", wid);
            data.setDataElement("AttributeName", attr.getName());
            data.setDataElement("AttributeType", attr.getType());
            data.setDataElement("NewAttributeValue", attr.getValue());
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (AttributeAssignmentFailedException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0180 = StringManager.get("E0180") + argInfo;
            eLog.error((Object)E0180, (Throwable)ex);
            throw new InvalidWorkItemException(E0180, ex);
        }
    }

    private void rollbackAndLogging(Exception ex, String argInfo) {
        try {
            DataAccessManager.rollback();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        String msg = ex.getMessage() + argInfo;
        eLog.error((Object)msg, (Throwable)ex);
    }

    private void checkWorkItemID(String wid) throws InvalidWorkItemException {
        if (wid == null || wid.trim().equals("")) {
            String E0192 = StringManager.get("E0192");
            throw new InvalidWorkItemException(E0192);
        }
    }

    private void validateSession(String session) throws InvalidSessionException {
        if (session == null || session.trim().equals("")) {
            String E0170 = StringManager.get("E0170");
            throw new InvalidSessionException(E0170);
        }
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
        SessionManager manager = factory.getSessionManager();
        manager.validateSession(session);
    }
}

