/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisedSupportListener;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.UnknownAdviceTypeException;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.OrderComparator;

public class ProxyFactoryBean
extends AdvisedSupport
implements FactoryBean,
BeanFactoryAware,
AdvisedSupportListener {
    public static final String GLOBAL_SUFFIX = "*";
    private String[] interceptorNames;
    private boolean singleton = true;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private BeanFactory beanFactory;
    private String targetName;
    private Map sourceMap = new HashMap();
    private Object singletonInstance;
    static /* synthetic */ Class class$org$springframework$aop$Advisor;
    static /* synthetic */ Class class$org$aopalliance$intercept$Interceptor;

    public void setProxyInterfaces(String[] interfaceNames) throws ClassNotFoundException {
        Class[] interfaces = AopUtils.toInterfaceArray(interfaceNames);
        this.setInterfaces(interfaces);
    }

    public void setInterceptorNames(String[] interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.createAdvisorChain();
        if (this.singleton) {
            this.getSingletonInstance();
            this.addListener(this);
        }
    }

    public Object getObject() throws BeansException {
        return this.singleton ? this.getSingletonInstance() : this.newPrototypeInstance();
    }

    public Class getObjectType() {
        return this.singleton ? this.getSingletonInstance().getClass() : this.getTargetSource().getTargetClass();
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    private Object getSingletonInstance() {
        if (this.singletonInstance == null) {
            this.singletonInstance = this.createAopProxy().getProxy();
        }
        return this.singletonInstance;
    }

    private synchronized Object newPrototypeInstance() {
        this.refreshAdvisorChain();
        this.refreshTarget();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating copy of prototype ProxyFactoryBean config: " + this));
        }
        AdvisedSupport copy = new AdvisedSupport();
        copy.copyConfigurationFrom(this);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Copy has config: " + copy));
        }
        return copy.createAopProxy().getProxy();
    }

    private void createAdvisorChain() throws AopConfigException, BeansException {
        if (this.interceptorNames == null || this.interceptorNames.length == 0) {
            return;
        }
        if (this.interceptorNames[this.interceptorNames.length - 1].endsWith(GLOBAL_SUFFIX) && this.targetSource == EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("Target required after globals");
        }
        for (int i = 0; i < this.interceptorNames.length; ++i) {
            String name = this.interceptorNames[i];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Configuring advisor or advice '" + name + "'"));
            }
            if (name.endsWith(GLOBAL_SUFFIX)) {
                if (!(this.beanFactory instanceof ListableBeanFactory)) {
                    throw new AopConfigException("Can only use global advisors or interceptors with a ListableBeanFactory");
                }
                this.addGlobalAdvisor((ListableBeanFactory)this.beanFactory, name.substring(0, name.length() - GLOBAL_SUFFIX.length()));
                continue;
            }
            Object advice = null;
            if (this.isSingleton() || this.beanFactory.isSingleton(this.interceptorNames[i])) {
                advice = this.beanFactory.getBean(this.interceptorNames[i]);
            }
            this.addAdvisorOnChainCreation(advice, this.interceptorNames[i]);
        }
    }

    private void refreshAdvisorChain() {
        Advisor[] advisors = this.getAdvisors();
        for (int i = 0; i < advisors.length; ++i) {
            String beanName = (String)this.sourceMap.get(advisors[i]);
            if (beanName != null) {
                Object bean;
                Object refreshedAdvisor;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Refreshing bean named '" + beanName + "'"));
                }
                if ((refreshedAdvisor = this.namedBeanToAdvisorOrTargetSource(bean = this.beanFactory.getBean(beanName))) instanceof Advisor) {
                    this.replaceAdvisor(advisors[i], (Advisor)refreshedAdvisor);
                } else {
                    this.setTargetSource((TargetSource)refreshedAdvisor);
                }
                this.sourceMap.put(refreshedAdvisor, beanName);
                continue;
            }
            this.logger.debug((Object)("Cannot find bean name for Advisor [" + advisors[i] + "] when refreshing advisor chain"));
        }
    }

    private void addGlobalAdvisor(ListableBeanFactory beanFactory, String prefix) {
        Object bean;
        String name;
        int i;
        String[] globalAdvisorNames = BeanFactoryUtils.beanNamesIncludingAncestors(beanFactory, class$org$springframework$aop$Advisor == null ? (class$org$springframework$aop$Advisor = ProxyFactoryBean.class$("org.springframework.aop.Advisor")) : class$org$springframework$aop$Advisor);
        String[] globalInterceptorNames = BeanFactoryUtils.beanNamesIncludingAncestors(beanFactory, class$org$aopalliance$intercept$Interceptor == null ? (class$org$aopalliance$intercept$Interceptor = ProxyFactoryBean.class$("org.aopalliance.intercept.Interceptor")) : class$org$aopalliance$intercept$Interceptor);
        ArrayList<Object> beans = new ArrayList<Object>(globalAdvisorNames.length + globalInterceptorNames.length);
        HashMap<Object, String> names = new HashMap<Object, String>();
        for (i = 0; i < globalAdvisorNames.length; ++i) {
            name = globalAdvisorNames[i];
            bean = beanFactory.getBean(name);
            beans.add(bean);
            names.put(bean, name);
        }
        for (i = 0; i < globalInterceptorNames.length; ++i) {
            name = globalInterceptorNames[i];
            bean = beanFactory.getBean(name);
            beans.add(bean);
            names.put(bean, name);
        }
        Collections.sort(beans, new OrderComparator());
        Iterator it = beans.iterator();
        while (it.hasNext()) {
            Object bean2 = it.next();
            String name2 = (String)names.get(bean2);
            if (!name2.startsWith(prefix)) continue;
            this.addAdvisorOnChainCreation(bean2, name2);
        }
    }

    private void addAdvisorOnChainCreation(Object next, String name) {
        this.logger.debug((Object)("Adding advisor or TargetSource [" + next + "] with name [" + name + "]"));
        if (this.targetName != null) {
            throw new AopConfigException("TargetSource specified more than once in interceptorNames list:Specify in targetSource property or ONCE at the END of the interceptorNames list");
        }
        Object advisor = this.namedBeanToAdvisorOrTargetSource(next);
        if (advisor instanceof Advisor) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding advisor with name [" + name + "]"));
            }
            this.addAdvisor((Advisor)advisor);
            this.sourceMap.put(advisor, name);
        } else {
            if (this.targetSource != EMPTY_TARGET_SOURCE) {
                throw new AopConfigException("TargetSource specified more than once: Specify in targetSource property or at the END of the interceptorNames list");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding TargetSource [" + advisor + "] with name [" + name + "]"));
            }
            this.setTargetSource((TargetSource)advisor);
            this.targetName = name;
        }
    }

    private void refreshTarget() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshing target with name '" + this.targetName + "'"));
        }
        if (this.targetName == null) {
            throw new AopConfigException("Target name cannot be null when refreshing!");
        }
        Object target = this.beanFactory.getBean(this.targetName);
        this.setTarget(target);
    }

    private Object namedBeanToAdvisorOrTargetSource(Object next) {
        try {
            Advisor adv = this.advisorAdapterRegistry.wrap(next);
            return adv;
        }
        catch (UnknownAdviceTypeException ex) {
            if (next instanceof TargetSource) {
                return (TargetSource)next;
            }
            return new SingletonTargetSource(next);
        }
    }

    public void activated(AdvisedSupport advisedSupport) {
    }

    public void adviceChanged(AdvisedSupport advisedSupport) {
        this.logger.info((Object)"Advice has changed; recaching singleton instance");
        this.singletonInstance = null;
        this.getSingletonInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

