/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.IOException;
import java.io.OutputStream;

final class ByteBuffer {
    byte[] buffer;
    int size = 0;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int size) {
        this.buffer = new byte[size];
    }

    public void add(byte b) {
        if (this.size + 1 > this.buffer.length) {
            byte[] newBuf = new byte[(this.size + 1) * 2];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
        this.buffer[this.size++] = b;
    }

    public void add(short s) {
        this.set(s, this.size);
    }

    public void set(short s, int offset) {
        if (offset + 2 > this.buffer.length) {
            byte[] newBuf = new byte[(offset + 2) * 2];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.size);
            this.buffer = newBuf;
        }
        this.buffer[offset] = (byte)(s >> 8);
        this.buffer[offset + 1] = (byte)s;
        if (offset + 2 > this.size) {
            this.size = offset + 2;
        }
    }

    public void add(int s) {
        this.set(s, this.size);
    }

    public void set(int s, int offset) {
        if (offset + 4 > this.buffer.length) {
            byte[] newBuf = new byte[(offset + 4) * 2];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
        this.buffer[offset] = (byte)(s >> 24);
        this.buffer[offset + 1] = (byte)(s >> 16);
        this.buffer[offset + 2] = (byte)(s >> 8);
        this.buffer[offset + 3] = (byte)s;
        if (offset + 4 > this.size) {
            this.size = offset + 4;
        }
    }

    public void add(long l) {
        if (this.size + 8 > this.buffer.length) {
            byte[] newBuf = new byte[(this.size + 8) * 2];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
        this.buffer[this.size++] = (byte)(l >> 56);
        this.buffer[this.size++] = (byte)(l >> 48);
        this.buffer[this.size++] = (byte)(l >> 40);
        this.buffer[this.size++] = (byte)(l >> 32);
        this.buffer[this.size++] = (byte)(l >> 24);
        this.buffer[this.size++] = (byte)(l >> 16);
        this.buffer[this.size++] = (byte)(l >> 8);
        this.buffer[this.size++] = (byte)l;
    }

    public void add(byte[] b, int offset, int len) {
        this.add(b, offset, len, this.size);
    }

    public void add(byte[] b, int offset, int len, int dst_offset) {
        if (dst_offset + len > this.buffer.length) {
            byte[] newBuf = new byte[(dst_offset + 1) * 2 + len];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.size);
            this.buffer = newBuf;
        }
        System.arraycopy(b, offset, this.buffer, dst_offset, len);
        if (dst_offset + len > this.size) {
            this.size = dst_offset + len;
        }
    }

    public void prepend(ByteBuffer buf) {
        int len = buf.size();
        if (len + this.size > this.buffer.length) {
            byte[] newBuf = new byte[len * 2 + this.size];
            System.arraycopy(this.buffer, 0, newBuf, len, this.size);
            System.arraycopy(buf.buffer, 0, newBuf, 0, len);
            this.buffer = newBuf;
        } else {
            System.arraycopy(this.buffer, 0, this.buffer, len, this.size);
            System.arraycopy(buf.buffer, 0, this.buffer, 0, len);
        }
        this.size += len;
    }

    public void append(ByteBuffer buf) {
        this.add(buf.buffer, 0, buf.size());
    }

    public void set(byte b, int offset) {
        this.buffer[offset] = b;
    }

    public void copyTo(int offset, byte[] dest, int off, int len) {
        System.arraycopy(this.buffer, offset, dest, off, len);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.size);
    }
}

