/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.pnuts.util.Cell;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.lang.ImportEnv;
import pnuts.lang.ModuleList;
import pnuts.lang.Package;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsInterpreter;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.StackFrame;
import pnuts.lang.SymbolTable;
import pnuts.lang.Visitor;

public class Function
extends Runtime
implements Serializable {
    static final long serialVersionUID = 1707784010507793472L;
    protected String funcName;
    protected String name;
    boolean anonymous;
    protected int nargs;
    protected String[] locals;
    protected transient Object file;
    protected SimpleNode node;
    SymbolTable lexicalScope;
    protected ImportEnv importEnv;
    protected ModuleList moduleList;
    protected Function outer;
    protected String pkgName;
    protected PnutsFunction function;
    protected transient Package pkg;
    protected Configuration config;

    protected Function() {
    }

    Function(Function func) {
        this.funcName = func.funcName;
        this.name = func.name;
        this.anonymous = func.anonymous;
        this.locals = func.locals;
        this.nargs = func.nargs;
        this.pkg = func.pkg;
        this.pkgName = func.pkgName;
        this.lexicalScope = func.lexicalScope;
        this.importEnv = func.importEnv;
        this.moduleList = func.moduleList;
        this.file = func.file;
        this.outer = func.outer;
        this.node = func.node;
        this.config = func.config;
        this.function = func.function;
    }

    protected Function(String func, String[] locals, int nargs, SimpleNode node, Package pkg, Context context) {
        if (context.frame != null) {
            this.outer = context.frame;
            this.file = this.outer.file;
            this.importEnv = this.outer.importEnv;
        } else {
            Cell c = context.loadingResource;
            if (c != null) {
                this.file = c.object;
            }
            this.importEnv = context.importEnv;
        }
        this.config = context.config;
        this.moduleList = context.localModuleList();
        if (func != null) {
            this.name = func;
        } else {
            this.name = "";
            this.anonymous = true;
        }
        this.nargs = nargs;
        this.locals = locals;
        this.node = node;
        this.pkg = pkg;
        this.pkgName = pkg.getName();
        StackFrame lex = context.stackFrame;
        if (lex != null) {
            SymbolTable tab = new SymbolTable();
            lex.makeLexicalScope(tab);
            this.lexicalScope = tab;
        }
    }

    public synchronized String getName() {
        if (this.funcName == null) {
            Function of = this.outer;
            this.funcName = of != null ? of.getName() + "." + this.name : this.name;
        }
        return this.funcName;
    }

    public int getNumberOfParameter() {
        return this.nargs;
    }

    public Object getScriptSource() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object exec(Object[] args, Context context) {
        try {
            context.open(this, args);
            Object object = this.node.accept(PnutsInterpreter.instance, context);
            return object;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            Runtime.checkException(context, t);
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            context.close(this, args);
        }
    }

    public Package getPackage() {
        return this.pkg;
    }

    public String[] getImportEnv() {
        return this.importEnv.list();
    }

    String paramString() {
        String s = "";
        s = s + "(";
        if (this.nargs != 0) {
            s = s + this.locals[0];
        }
        if (this.nargs == -1) {
            s = s + "[]";
        } else {
            for (int i = 1; i < this.nargs; ++i) {
                s = s + ",";
                s = s + this.locals[i];
            }
        }
        s = s + ")";
        return s;
    }

    protected PnutsFunction register(PnutsFunction pf) {
        return this.register(pf, false);
    }

    protected PnutsFunction register(PnutsFunction pf, boolean isChild) {
        if (pf == null) {
            pf = this.anonymous ? new PnutsFunction() : new PnutsFunction(this.name);
            pf.pkg = this.pkg;
        } else if (isChild || pf.count == 0 || pf.pkg != this.pkg) {
            PnutsFunction func = new PnutsFunction(this.name, pf);
            func.pkg = this.pkg;
            func.put(this.nargs, this);
            return func;
        }
        pf.put(this.nargs, this);
        return pf;
    }

    protected Object accept(Visitor visitor, Context context) {
        return this.node.jjtGetParent().accept(visitor, context);
    }

    protected String unparse(Context context) {
        return Runtime.unparse(this.node.jjtGetParent(), context);
    }

    public String toString() {
        String s = "function ";
        s = s + this.getName();
        s = s + this.paramString();
        return s;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (int i = 0; i < this.locals.length; ++i) {
            this.locals[i] = this.locals[i].intern();
        }
        this.pkg = Package.getPackage(this.pkgName, null);
    }
}

