/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import pnuts.lang.Builtin;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.lang.Escape;
import pnuts.lang.Function;
import pnuts.lang.ImportEnv;
import pnuts.lang.Jump;
import pnuts.lang.ModuleList;
import pnuts.lang.Package;
import pnuts.lang.PnutsException;
import pnuts.lang.Runtime;
import pnuts.lang.Visitor;

public class PnutsFunction
extends Runtime
implements Cloneable,
Serializable {
    static final long serialVersionUID = 39323137418961689L;
    private transient Function[] functions = new Function[4];
    int count = 0;
    protected String name;
    static final String _getContext = "getContext".intern();
    static final String _package = "package".intern();
    static final String _import = "import".intern();
    static final String _catch = "catch".intern();
    static final String _throw = "throw".intern();
    static final String _eval = "eval".intern();
    static final String _loadFile = "loadFile".intern();
    static final String _load = "load".intern();
    static final String _autoload = "autoload".intern();
    static final String _quit = "quit".intern();
    static final String _defined = "defined".intern();
    static final String _use = "use".intern();
    static final String _unuse = "unuse".intern();
    static final String _class = "class".intern();
    static final String _require = "require".intern();
    public static final PnutsFunction GET_CONTEXT = new Builtin(_getContext);
    public static final PnutsFunction PACKAGE = new Builtin(_package);
    public static final PnutsFunction IMPORT = new Builtin(_import);
    public static final PnutsFunction CATCH = new Builtin(_catch);
    public static final PnutsFunction THROW = new Builtin(_throw);
    public static final PnutsFunction EVAL = new Builtin(_eval);
    public static final PnutsFunction LOAD_FILE = new Builtin(_loadFile);
    public static final PnutsFunction LOAD = new Builtin(_load);
    public static final PnutsFunction AUTOLOAD = new Builtin(_autoload);
    public static final PnutsFunction QUIT = new Builtin(_quit);
    public static final PnutsFunction DEFINED = new Builtin(_defined);
    public static final PnutsFunction USE = new Builtin(_use);
    public static final PnutsFunction UNUSE = new Builtin(_unuse);
    public static final PnutsFunction CLASS = new Builtin(_class);
    public static final PnutsFunction REQUIRE = new Builtin(_require);
    public static final PnutsFunction[] primitives = new PnutsFunction[]{GET_CONTEXT, PACKAGE, IMPORT, THROW, EVAL, LOAD_FILE, LOAD, AUTOLOAD, QUIT, DEFINED, USE, UNUSE, CLASS, REQUIRE};
    protected transient Package pkg = Package.globalPackage;
    private PnutsFunction parent = null;

    protected PnutsFunction() {
        this(null);
    }

    protected PnutsFunction(String name) {
        this.name = name;
    }

    protected PnutsFunction(String name, PnutsFunction parent) {
        this.name = name;
        this.parent = parent;
    }

    synchronized void put(int narg, Function f) {
        int n = narg + 1;
        if (this.functions.length < n + 1) {
            Function[] func = new Function[(n + 1) * 2];
            System.arraycopy(this.functions, 0, func, 0, this.functions.length);
            this.functions = func;
        }
        this.functions[n] = f;
        f.function = this;
        ++this.count;
        this.added(narg);
    }

    protected void added(int narg) {
    }

    public final Function get(int narg) {
        int n = narg + 1;
        if (n >= this.functions.length) {
            return null;
        }
        return this.functions[n];
    }

    public boolean defined(int narg) {
        if (this.get(narg) instanceof Function) {
            return true;
        }
        return this.parent != null && this.parent.defined(narg);
    }

    public String getName() {
        return this.name;
    }

    public final Object call(Object[] args, Context context) {
        return this.exec(args, context);
    }

    protected Object exec(Object[] args, Context context) {
        Function f = null;
        try {
            f = this.functions[args.length + 1];
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (f == null) {
            f = this.functions[0];
            if (f == null) {
                if (this.parent != null) {
                    return this.parent.exec(args, context);
                }
                this.undefined(args, context);
            } else {
                args = new Object[]{args};
            }
        }
        Function caller = context.frame;
        int line = context.beginLine;
        ImportEnv saved = context.importEnv;
        Package outerPackage = context.currentPackage;
        boolean eval = context.eval;
        Configuration config = context.config;
        ModuleList moduleList = context.moduleList;
        ModuleList localModuleList = context.localModuleList;
        context.importEnv = f.importEnv;
        context.currentPackage = f.pkg;
        context.eval = false;
        context.frame = f;
        context.config = f.config;
        context.moduleList = f.moduleList;
        context.localModuleList = null;
        try {
            Object object = f.exec(args, context);
            return object;
        }
        catch (Jump jump) {
            Object object = jump.getValue();
            return object;
        }
        catch (Escape esc) {
            throw esc;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            PnutsException p = null;
            p = t instanceof PnutsException ? (PnutsException)t : new PnutsException(t, context);
            if (caller != null) {
                p.backtrace(new PnutsException.TraceInfo(f.name, args, caller.file, line));
            } else {
                p.backtrace(new PnutsException.TraceInfo(f.name, args, null, line));
            }
            throw p;
        }
        finally {
            context.frame = caller;
            context.importEnv = saved;
            context.eval = eval;
            context.currentPackage = outerPackage;
            context.config = config;
            context.moduleList = moduleList;
            context.localModuleList = localModuleList;
        }
    }

    protected void undefined(Object[] args, Context context) {
        throw new PnutsException("function.notDefined", new Object[]{this.name, new Integer(args.length)}, context);
    }

    public String toString() {
        Function f;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.functions.length) {
            if ((f = this.functions[i++]) == null) continue;
            buf.append(f.toString());
            break;
        }
        while (i < this.functions.length) {
            if ((f = this.functions[i++]) == null) continue;
            buf.append(",");
            buf.append(f.paramString());
        }
        if (buf.length() < 1) {
            buf.append("function " + this.name);
        }
        if (this.parent == null) {
            return buf.toString();
        }
        return buf + ", ...";
    }

    public static Object call(String name, Object[] args, Context context) {
        Object o = context.resolveSymbol(name.intern());
        if (o instanceof PnutsFunction) {
            return PnutsFunction.exec((PnutsFunction)o, args, context);
        }
        throw new PnutsException("function.notDefined", new Object[]{name, new Integer(args.length)}, context);
    }

    protected static Object exec(PnutsFunction func, Object[] args, Context context) {
        return func.call(args, context);
    }

    public String unparse(int narg) {
        Function f = this.get(narg);
        if (f != null) {
            return f.unparse(null);
        }
        return null;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public String[] getImportEnv(int narg) {
        Function f = this.get(narg);
        if (f != null) {
            return f.importEnv.list();
        }
        return null;
    }

    public boolean isBuiltin() {
        return false;
    }

    public Object accept(int narg, Visitor visitor, Context context) {
        Function f = this.get(narg);
        if (f != null) {
            return f.accept(visitor, context);
        }
        return null;
    }

    public Object clone() {
        try {
            PnutsFunction f = (PnutsFunction)super.clone();
            f.functions = (Function[])this.functions.clone();
            return f;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Enumeration elements() {
        if (this.count > 0) {
            return new Enum();
        }
        return null;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int n = this.functions.length;
        s.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Function f = this.functions[i];
            s.writeObject(f);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int n = s.readInt();
        this.functions = new Function[n];
        for (int i = 0; i < n; ++i) {
            this.functions[i] = (Function)s.readObject();
        }
    }

    static /* synthetic */ Function[] access$000(PnutsFunction x0) {
        return x0.functions;
    }

    class Enum
    implements Enumeration {
        int idx = 0;
        int size = PnutsFunction.access$000(PnutsFunction.this).length;

        Enum() {
        }

        public boolean hasMoreElements() {
            while (!PnutsFunction.this.defined(this.idx - 1) && this.idx < this.size) {
                ++this.idx;
            }
            return this.idx < this.size;
        }

        public Object nextElement() {
            if (this.idx < this.size) {
                while (!PnutsFunction.this.defined(this.idx - 1)) {
                    ++this.idx;
                }
                return PnutsFunction.this.get(this.idx++ - 1);
            }
            throw new NoSuchElementException(PnutsFunction.this.toString());
        }
    }
}

