/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.pnuts.util.LRUCache;
import org.pnuts.util.Stack;
import pnuts.ext.UnparseVisitor;
import pnuts.lang.AutoloadHook;
import pnuts.lang.BinaryOperator;
import pnuts.lang.Binding;
import pnuts.lang.BooleanOperator;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.lang.Escape;
import pnuts.lang.Executable;
import pnuts.lang.Function;
import pnuts.lang.Jump;
import pnuts.lang.ModuleList;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.QuantityFactory;
import pnuts.lang.SimpleNode;
import pnuts.lang.StackFrame;
import pnuts.lang.UnaryOperator;
import pnuts.lang.Value;

public class Runtime
implements Executable {
    private static final boolean DEBUG = false;
    private static final Object[] noarg = new Object[0];
    protected static final String CLONE = "clone".intern();
    private static LRUCache mtab = new LRUCache(512);
    private static LRUCache ctab = new LRUCache(512);
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static LRUCache beanAccessors = new LRUCache(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Throwable;

    protected Runtime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(Context context) {
        context.runtime = this;
        try {
            Object object = this.exec(context);
            return object;
        }
        catch (Throwable t) {
            Runtime.checkException(context, t);
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            PrintWriter pw = context.getWriter();
            if (pw != null) {
                pw.flush();
            }
        }
    }

    public Object execute(Context context) {
        return this.run(context);
    }

    protected Object exec(Context context) {
        return null;
    }

    public static Object callMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        return context.config.callMethod(context, c, name, args, types, target);
    }

    public static Object callConstructor(Context context, Class c, Object[] args, Class[] types) {
        return context.config.callConstructor(context, c, args, types);
    }

    protected Object _callMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        boolean _static;
        Method method = null;
        boolean bl = _static = target == null;
        if (name == CLONE && args.length == 0) {
            if (target instanceof Object[]) {
                return ((Object[])target).clone();
            }
            if (target instanceof int[]) {
                return ((int[])target).clone();
            }
            if (target instanceof byte[]) {
                return ((byte[])target).clone();
            }
            if (target instanceof short[]) {
                return ((short[])target).clone();
            }
            if (target instanceof char[]) {
                return ((char[])target).clone();
            }
            if (target instanceof long[]) {
                return ((long[])target).clone();
            }
            if (target instanceof float[]) {
                return ((float[])target).clone();
            }
            if (target instanceof double[]) {
                return ((double[])target).clone();
            }
            if (target instanceof boolean[]) {
                return ((boolean[])target).clone();
            }
        }
        Method[] m = Runtime.getMethods(context, c, name);
        try {
            int count = 0;
            int min = Integer.MAX_VALUE;
            Stack methods = new Stack();
            block7: for (int i = 0; i < m.length; ++i) {
                boolean st;
                Method mi = m[i];
                Class<?>[] p = mi.getParameterTypes();
                if (p.length != args.length) continue;
                count = 0;
                for (int j = 0; j < p.length; ++j) {
                    int t;
                    Class tj;
                    Class<?> pj = p[j];
                    if (types != null && (tj = types[j]) != null && pj != tj && !pj.isAssignableFrom(tj) || (t = Runtime.matchType(pj, args[j])) < 0) continue block7;
                    count += t;
                }
                if (count > min || (st = Modifier.isStatic(mi.getModifiers())) != _static) continue;
                if (count < min) {
                    methods.removeAllElements();
                    methods.push(mi);
                    min = count;
                    continue;
                }
                if (count != min) continue;
                methods.push(mi);
            }
            block9: for (Class clazz = c; clazz != null; clazz = clazz.getSuperclass()) {
                int size = methods.size();
                for (int i = 0; i < size; ++i) {
                    method = (Method)methods.pop();
                    if (!_static && method.getDeclaringClass() == clazz) break block9;
                }
            }
            if (method != null) {
                if (args.length > 0) {
                    Class<?>[] p = method.getParameterTypes();
                    for (int j = 0; j < p.length; ++j) {
                        Class<?> pj = p[j];
                        if (!pj.isArray() || args[j] == null || !Runtime.isArray(args[j]) || pj.isInstance(args[j])) continue;
                        args[j] = Runtime.transform(Runtime.getBottomType(pj), args[j]);
                    }
                }
                try {
                    return method.invoke(target, args);
                }
                catch (InvocationTargetException ita) {
                    throw new PnutsException(ita.getTargetException(), method, context);
                }
            }
            throw new PnutsException("method.notFound", new Object[]{name, "" + (target == null ? c : target), "" + Pnuts.format(args)}, context);
        }
        catch (IllegalAccessException pe) {
            Class<?> cls = method.getDeclaringClass();
            try {
                Method _m;
                if (!Modifier.isPublic(cls.getModifiers()) && (_m = Runtime.findCallableMethod(cls, name, method.getParameterTypes())) != null) {
                    for (int i = 0; i < m.length; ++i) {
                        if (m[i] != method) continue;
                        m[i] = _m;
                        break;
                    }
                    return _m.invoke(target, args);
                }
                return Configuration.normalConfiguration.reInvoke(pe, method, target, args);
            }
            catch (IllegalAccessException iae) {
                throw new PnutsException(iae, context);
            }
            catch (InvocationTargetException ita) {
                throw new PnutsException(ita.getTargetException(), method, context);
            }
        }
    }

    protected static Method findCallableMethod(Class clazz, String name, Class[] args) {
        while (clazz != null) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                try {
                    Method method = clazz.getMethod(name, args);
                    if (method != null && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                        return method;
                    }
                }
                catch (NoSuchMethodException nme) {
                    // empty catch block
                }
            }
            Class<?>[] it = clazz.getInterfaces();
            for (int i = 0; i < it.length; ++i) {
                Method m = Runtime.findCallableMethod(it[i], name, args);
                if (m == null) continue;
                return m;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    protected Object _callConstructor(Context context, Class c, Object[] args, Class[] types) {
        try {
            Constructor[] cs = Runtime.getConstructors(context, c);
            Constructor cons = null;
            int count = 0;
            int min = Integer.MAX_VALUE;
            block6: for (int i = 0; i < cs.length; ++i) {
                Class<?>[] p = cs[i].getParameterTypes();
                if (p.length != args.length) continue;
                count = 0;
                for (int j = 0; j < p.length; ++j) {
                    int t;
                    Class tj;
                    Class<?> pj = p[j];
                    if (types != null && (tj = types[j]) != null && pj != tj && !pj.isAssignableFrom(tj) || (t = Runtime.matchType(pj, args[j])) < 0) continue block6;
                    count += t;
                }
                if (count >= min) continue;
                min = count;
                cons = cs[i];
            }
            if (cons != null) {
                Class<?>[] p = cons.getParameterTypes();
                for (int j = 0; j < p.length; ++j) {
                    Class<?> pj = p[j];
                    if (!pj.isArray() || args[j] == null || !Runtime.isArray(args[j]) || pj.isInstance(args[j])) continue;
                    args[j] = Runtime.transform(Runtime.getBottomType(pj), args[j]);
                }
                try {
                    return cons.newInstance(args);
                }
                catch (InvocationTargetException ita) {
                    throw new PnutsException(ita.getTargetException(), cons, context);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException e2) {
            throw new PnutsException("constructor.notFound", new Object[]{c, Pnuts.format(args)}, context);
        }
        catch (PnutsException e3) {
            throw e3;
        }
        catch (Throwable e4) {
            throw new PnutsException(e4, context);
        }
    }

    public static void putStaticField(Context context, Class clazz, String name, Object expr) {
        context.config.putStaticField(context, clazz, name, expr);
    }

    public static Object getStaticField(Context context, Class clazz, String name) {
        return context.config.getStaticField(context, clazz, name);
    }

    public static void putField(Context context, Object target, String name, Object expr) {
        context.config.putField(context, target, name, expr);
    }

    public static Object getField(Context context, Object target, String name) {
        return context.config.getField(context, target, name);
    }

    public static Class getBottomType(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static Class arrayType(Class c, int dim) {
        if (dim == 0) {
            return c;
        }
        return Runtime.arrayType(Array.newInstance(c, 0).getClass(), dim - 1);
    }

    protected static int arraydim(Object o) {
        if (Runtime.isArray(o)) {
            int len = Runtime.getArrayLength(o);
            int maxDim = 0;
            for (int i = 0; i < len; ++i) {
                int dim = Runtime.arraydim(Array.get(o, i));
                if (dim <= maxDim) continue;
                maxDim = dim;
            }
            return maxDim + 1;
        }
        return 0;
    }

    public static Object transform(Class baseType, Object array) {
        int dim = Runtime.arraydim(array);
        Class targetClass = Runtime.arrayType(baseType, dim);
        int len = Runtime.getArrayLength(array);
        Object ret = Array.newInstance(targetClass.getComponentType(), len);
        for (int i = 0; i < len; ++i) {
            Object e = Array.get(array, i);
            if (Runtime.isArray(e)) {
                e = Runtime.transform(baseType, e);
            }
            Array.set(ret, i, e);
        }
        return ret;
    }

    protected static int matchType(Class type, Object obj) {
        if (obj == null) {
            if (type.isPrimitive()) {
                return -1;
            }
            return 0;
        }
        Class<?> clazz = obj.getClass();
        if (clazz == type) {
            return 0;
        }
        if (type == Boolean.TYPE) {
            return clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Runtime.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? 0 : -1;
        }
        if (type == Byte.TYPE) {
            return Runtime.distance(0, clazz);
        }
        if (type == Character.TYPE) {
            if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Runtime.class$("java.lang.Short")) : class$java$lang$Short)) {
                return -1;
            }
            return Runtime.distance(1, clazz);
        }
        if (type == Short.TYPE) {
            if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Runtime.class$("java.lang.Character")) : class$java$lang$Character)) {
                return -1;
            }
            return Runtime.distance(1, clazz);
        }
        if (type == Integer.TYPE) {
            return Runtime.distance(2, clazz);
        }
        if (type == Long.TYPE) {
            return Runtime.distance(3, clazz);
        }
        if (type == Float.TYPE) {
            return Runtime.distance(4, clazz);
        }
        if (type == Double.TYPE) {
            return Runtime.distance(5, clazz);
        }
        if (type.isAssignableFrom(clazz)) {
            return 1;
        }
        if (type.isArray() && clazz.isArray()) {
            int j = 1;
            for (int i = 0; i < Runtime.getArrayLength(obj); ++i) {
                int s = Runtime.matchType(type.getComponentType(), Array.get(obj, i));
                if (s < 0) {
                    return -1;
                }
                j += s;
            }
            return j;
        }
        return -1;
    }

    private static int distance(int pos, Class clazz) {
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Runtime.class$("java.lang.Double")) : class$java$lang$Double)) {
            return pos - 5;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Runtime.class$("java.lang.Float")) : class$java$lang$Float)) {
            return pos - 4;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Runtime.class$("java.lang.Long")) : class$java$lang$Long)) {
            return pos - 3;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Runtime.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return pos - 2;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Runtime.class$("java.lang.Short")) : class$java$lang$Short)) {
            return pos - 1;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Runtime.class$("java.lang.Character")) : class$java$lang$Character)) {
            return pos - 1;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Runtime.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return pos;
        }
        return -1;
    }

    private static synchronized Method[] getMethods(Context context, Class cls, String name) {
        Object v;
        LRUCache cache = (LRUCache)mtab.get(cls);
        if (cache == null) {
            cache = new LRUCache(512);
            mtab.put(cls, cache);
        }
        if ((v = cache.get(name)) instanceof Method[]) {
            return (Method[])v;
        }
        Method[] m = context.config.getMethods(cls);
        if (m == null) {
            throw new NoClassDefFoundError("" + cls);
        }
        int j = 0;
        for (int i = 0; i < m.length; ++i) {
            String m_name = m[i].getName();
            if (!m_name.equals(name) || i < j) continue;
            m[j] = m[i];
            ++j;
        }
        Method[] m2 = new Method[j];
        System.arraycopy(m, 0, m2, 0, j);
        cache.put(name, m2);
        return m2;
    }

    protected static Method[] getMethods(Context context, Class cls) {
        return context.config.getMethods(cls);
    }

    protected static synchronized Constructor[] getConstructors(Context context, Class cls) {
        Object v = ctab.get(cls);
        if (v instanceof Constructor[]) {
            return (Constructor[])v;
        }
        Constructor[] con = context.config.getConstructors(cls);
        ctab.put(cls, con);
        return con;
    }

    public static Object[] parseInt(String str) throws ParseException {
        char c1 = str.charAt(0);
        if (c1 == '#') {
            return Runtime.parseInt(str.substring(1), 16, true);
        }
        if (c1 == '0') {
            if (str.length() > 1) {
                char c2 = str.charAt(1);
                if (c2 == 'x' || c2 == 'X') {
                    return Runtime.parseInt(str.substring(2), 16, false);
                }
                return Runtime.parseInt(str, 8, false);
            }
            return new Object[]{new Integer(0), null};
        }
        return Runtime.parseInt(str, 10, false);
    }

    static Object[] parseInt(String str, int radix, boolean shrink) throws ParseException {
        char ch;
        boolean overflow = false;
        long value = 0L;
        int len = str.length();
        int i = 0;
        block9: for (i = 0; i < len; ++i) {
            ch = str.charAt(i);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    if (radix == 8) {
                        if ((value = (value << 3) + (long)Character.toLowerCase(ch) - 48L) >= 0L) continue block9;
                        overflow = true;
                        break block9;
                    }
                }
                case '8': 
                case '9': {
                    if (radix == 10) {
                        int c = ch - 48;
                        if ((value = value * 10L + (long)c) >= 0L) continue block9;
                        overflow = true;
                        break block9;
                    }
                    if (radix == 16) {
                        if ((value = (value << 4) + (long)Character.toLowerCase(ch) - 48L) >= 0L) continue block9;
                        overflow = true;
                        break block9;
                    }
                    if (radix == 8) {
                        throw new ParseException();
                    }
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (radix == 10) break block9;
                    if (radix == 8) {
                        throw new ParseException();
                    }
                    if ((value = (value << 4) + 10L + (long)Character.toLowerCase(ch) - 97L) >= 0L) continue block9;
                    overflow = true;
                    break block9;
                }
            }
        }
        block10: while (i < len) {
            ch = str.charAt(i);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (radix != 10) break;
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            ++i;
        }
        Number number = null;
        if (overflow) {
            String s = str;
            if (str.length() > i) {
                s = str.substring(0, i);
            }
            number = Runtime.decimalNumber(s, radix);
        } else {
            number = value >= 0L && value <= 255L && radix == 16 ? (Number)(shrink ? (Number)new Byte((byte)value) : (Number)new Integer((int)value)) : (Number)(value <= Integer.MIN_VALUE || value >= Integer.MAX_VALUE ? (Number)new Long(value) : (Number)new Integer((int)value));
        }
        if (str.length() > i) {
            if (radix == 16) {
                i += 2;
            }
            return new Object[]{number, new int[]{i}};
        }
        return new Object[]{number, null};
    }

    public static Object[] parseFloat(String str) {
        char ch;
        int i = 0;
        int len = str.length();
        block6: for (i = 0; i < len; ++i) {
            ch = str.charAt(i);
            switch (ch) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block6;
                }
            }
        }
        if (i < len && ((ch = str.charAt(i)) == 'e' || ch == 'E')) {
            ++i;
            block7: while (i < len) {
                ch = str.charAt(i);
                switch (ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break;
                    }
                    default: {
                        break block7;
                    }
                }
                ++i;
            }
        }
        String s = str;
        if (i < len) {
            s = str.substring(0, i);
        }
        Number n = null;
        n = s.length() > 16 ? (Number)Runtime.decimalNumber(s, 10) : (Number)Double.valueOf(s);
        if (i < len) {
            return new Object[]{n, new int[]{i}};
        }
        return new Object[]{n, null};
    }

    public static String parseString(String str) throws ParseException {
        StringBuffer buf = new StringBuffer();
        boolean backquote = str.charAt(0) == '`';
        int length = str.length();
        block15: for (int i = 1; i < length - 1; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && !backquote) {
                switch (str.charAt(++i)) {
                    case '\"': {
                        buf.append('\"');
                        continue block15;
                    }
                    case 'b': {
                        buf.append('\b');
                        continue block15;
                    }
                    case 'f': {
                        buf.append('\f');
                        continue block15;
                    }
                    case 't': {
                        buf.append('\t');
                        continue block15;
                    }
                    case 'r': {
                        buf.append('\r');
                        continue block15;
                    }
                    case 'n': {
                        buf.append('\n');
                        continue block15;
                    }
                    case '0': {
                        buf.append('\u0000');
                        continue block15;
                    }
                    case '\\': {
                        buf.append('\\');
                        continue block15;
                    }
                    case 'U': 
                    case 'u': {
                        if (i + 6 > length) {
                            throw new ParseException();
                        }
                        int value = 0;
                        block16: for (int j = 0; j < 4; ++j) {
                            char c = str.charAt(++i);
                            switch (c) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    value = (value << 4) + (c - 48);
                                    continue block16;
                                }
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    value = (value << 4) + 10 + Character.toLowerCase(c) - 97;
                                    continue block16;
                                }
                                default: {
                                    throw new ParseException();
                                }
                            }
                        }
                        buf.append((char)value);
                        continue block15;
                    }
                    default: {
                        throw new ParseException();
                    }
                }
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static Character parseChar(String str) throws ParseException {
        if (str.charAt(1) == '\\') {
            switch (str.charAt(2)) {
                case '\'': {
                    return new Character('\'');
                }
                case 'b': {
                    return new Character('\b');
                }
                case 'f': {
                    return new Character('\f');
                }
                case 't': {
                    return new Character('\t');
                }
                case 'r': {
                    return new Character('\r');
                }
                case 'n': {
                    return new Character('\n');
                }
                case '0': {
                    return new Character('\u0000');
                }
                case '\\': {
                    return new Character('\\');
                }
                case 'U': 
                case 'u': {
                    int len = str.length();
                    if (len != 8) {
                        throw new ParseException();
                    }
                    int value = 0;
                    block15: for (int p = 3; p < 7; ++p) {
                        char ch = str.charAt(p);
                        switch (ch) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + (ch - 48);
                                continue block15;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + Character.toLowerCase(ch) - 97;
                                continue block15;
                            }
                            default: {
                                throw new ParseException();
                            }
                        }
                    }
                    return new Character((char)value);
                }
            }
            throw new ParseException();
        }
        if (str.length() > 3) {
            throw new ParseException();
        }
        return new Character(str.charAt(1));
    }

    public static Object quantity(Number number, String numberString, String unit, Context context) {
        QuantityFactory factory;
        Hashtable units = context.unitTable;
        if (units != null && (factory = (QuantityFactory)units.get(unit)) != null) {
            return factory.make(number, unit);
        }
        if ("f".equals(unit) || "F".equals(unit)) {
            return new Float(number.floatValue());
        }
        if ("d".equals(unit) || "D".equals(unit)) {
            return new Double(number.doubleValue());
        }
        if ("l".equals(unit) || "L".equals(unit)) {
            return new Long(number.longValue());
        }
        if ("b".equals(unit) || "B".equals(unit)) {
            return Runtime.decimalNumber(numberString, 10);
        }
        throw new PnutsException("unitName.notDefined", new Object[]{unit}, context);
    }

    public static Object primitive(Context context, Class primitiveType, Object param, boolean flag) {
        return Runtime.primitive(context, primitiveType, param, flag, 10);
    }

    static Object primitive(Context context, Class primitiveType, Object param, boolean flag, int radix) {
        if (primitiveType == Integer.TYPE) {
            if (param instanceof Byte) {
                byte b = (Byte)param;
                return new Integer(b);
            }
            if (param instanceof Character) {
                return new Integer(((Character)param).charValue());
            }
            if (param instanceof Number) {
                return new Integer(((Number)param).intValue());
            }
            if (flag) {
                if (param == null) {
                    return null;
                }
                return new Integer(Integer.parseInt(param.toString().trim(), radix));
            }
        } else if (primitiveType == Byte.TYPE) {
            if (param instanceof Character) {
                return new Byte((byte)((Character)param).charValue());
            }
            if (param instanceof Number) {
                return new Byte(((Number)param).byteValue());
            }
            if (flag) {
                if (param == null) {
                    return null;
                }
                return new Byte(Byte.parseByte(param.toString().trim(), radix));
            }
        } else if (primitiveType == Character.TYPE) {
            if (param instanceof Number) {
                int i = ((Number)param).intValue();
                if (i >= 0 && i <= 65535) {
                    return new Character((char)i);
                }
                throw new PnutsException("char.outOfBound", PnutsException.NO_PARAM, context);
            }
            if (param instanceof Character) {
                return param;
            }
        } else if (primitiveType == Long.TYPE) {
            if (param instanceof Number) {
                return new Long(((Number)param).longValue());
            }
            if (flag) {
                if (param == null) {
                    return null;
                }
                return new Long(Long.parseLong(param.toString().trim(), radix));
            }
        } else if (primitiveType == Short.TYPE) {
            if (param instanceof Character) {
                return new Short((short)((Character)param).charValue());
            }
            if (param instanceof Number) {
                return new Short(((Number)param).shortValue());
            }
            if (flag) {
                if (param == null) {
                    return null;
                }
                return new Short(Short.parseShort(param.toString().trim(), radix));
            }
        } else if (primitiveType == Double.TYPE) {
            if (param instanceof Number) {
                return new Double(((Number)param).doubleValue());
            }
            if (flag) {
                if (param == null) {
                    return null;
                }
                return Double.valueOf(param.toString().trim());
            }
        } else if (primitiveType == Float.TYPE) {
            if (param instanceof Number) {
                return new Float(((Number)param).floatValue());
            }
            if (flag) {
                if (param == null) {
                    return null;
                }
                return Float.valueOf(param.toString().trim());
            }
        } else if (primitiveType == Boolean.TYPE) {
            if (param instanceof Boolean) {
                return param;
            }
            if (param == null) {
                return Boolean.FALSE;
            }
            if (flag) {
                if (param == null) {
                    return null;
                }
                return Boolean.valueOf(param.toString().trim());
            }
        }
        throw new ClassCastException("(" + primitiveType.getName() + ")" + Pnuts.format(param));
    }

    public static Object cast(Context context, Class type, Object object, boolean flag) {
        if (type.isPrimitive()) {
            return Runtime.primitive(context, type, object, false);
        }
        if (object == null) {
            return null;
        }
        if (type.isInstance(object)) {
            return object;
        }
        if (type.isArray() && Runtime.isArray(object)) {
            Class<?> compType = type.getComponentType();
            for (int i = 0; i < Runtime.getArrayLength(object); ++i) {
                int s = Runtime.matchType(compType, Array.get(object, i));
                if (s >= 0) continue;
                throw new ClassCastException("(" + Runtime.getClassName(type) + ")" + Pnuts.format(object));
            }
            if (flag) {
                return Runtime.transform(Runtime.getBottomType(compType), object);
            }
            return object;
        }
        throw new ClassCastException("(" + Runtime.getClassName(type) + ")" + Pnuts.format(object));
    }

    public static final boolean isArray(Object obj) {
        return obj instanceof Object[] || obj instanceof int[] || obj instanceof char[] || obj instanceof boolean[] || obj instanceof byte[] || obj instanceof double[] || obj instanceof long[] || obj instanceof short[] || obj instanceof float[];
    }

    public static final int getArrayLength(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        throw new IllegalArgumentException();
    }

    public static Object getRange(Object target, Object idx1, Object idx2, Context context) {
        return context.config.getRange(context, target, idx1, idx2);
    }

    public static Object setRange(Object target, Object idx1, Object idx2, Object expr, Context context) {
        return context.config.setRange(context, target, idx1, idx2, expr);
    }

    protected static void checkException(Context context, Throwable throwable) {
        TypeMap tmap;
        StackFrame stackFrame;
        if (throwable instanceof ParseException) {
            context.beginLine = ((ParseException)throwable).getErrorLine();
        }
        if ((stackFrame = context.stackFrame) != null) {
            NamedValue b;
            StackFrame frame = stackFrame;
            if (stackFrame.parent != null && (b = frame.lookup(Context.exceptionHandlerTableSymbol)) != null) {
                Runtime.checkException(context, throwable, (TypeMap)b.get());
                return;
            }
        }
        if ((tmap = (TypeMap)context.resolveSymbol(Context.exceptionHandlerTableSymbol)) != null) {
            Runtime.checkException(context, throwable, tmap);
            return;
        }
        if (throwable instanceof Escape) {
            throw (Escape)throwable;
        }
        if (throwable instanceof PnutsException) {
            throw (PnutsException)throwable;
        }
        throw new PnutsException(throwable, context);
    }

    protected static void checkException(Context context, Throwable throwable, TypeMap tmap) {
        Throwable e = throwable;
        if (e instanceof PnutsException) {
            throwable = ((PnutsException)e).getThrowable();
        }
        if (throwable instanceof Escape) {
            throw (Escape)throwable;
        }
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        PnutsFunction f = null;
        while (tmap != null) {
            Class type = tmap.type;
            if (type == null || type.isInstance(throwable)) {
                f = (PnutsFunction)tmap.value;
                break;
            }
            tmap = tmap.next;
        }
        if (f == null) {
            if (e instanceof PnutsException) {
                throw (PnutsException)e;
            }
            throw new PnutsException(throwable, context);
        }
        Object ret = f.exec(new Object[]{throwable}, context);
        PrintWriter pw = context.getWriter();
        if (pw != null) {
            pw.flush();
        }
        throw new Jump(ret);
    }

    protected static void catchException(Class type, PnutsFunction func, Context context) {
        Package pkg = context.getCurrentPackage();
        TypeMap typemap = null;
        if (type != (class$java$lang$Throwable == null ? (class$java$lang$Throwable = Runtime.class$("java.lang.Throwable")) : class$java$lang$Throwable)) {
            typemap = (TypeMap)pkg.get(Context.exceptionHandlerTableSymbol, context);
        }
        pkg.set(Context.exceptionHandlerTableSymbol, new TypeMap(type, func, typemap), context);
    }

    public static Object getElement(Object target, Object key, Context context) {
        return context.config.getElement(context, target, key);
    }

    public static void setElement(Object target, Object key, Object value, Context context) {
        context.config.setElement(context, target, key, value);
    }

    public static Enumeration toEnumeration(Object target, Context context) {
        return context.config.toEnumeration(target);
    }

    protected static final Object callFunction(Context context, PnutsFunction func, Object[] args) {
        return func.exec(args, context);
    }

    protected static final Object call(Context context, Object funcOrClass, Object[] args, Class[] casts) {
        if (funcOrClass instanceof PnutsFunction) {
            return ((PnutsFunction)funcOrClass).exec(args, context);
        }
        if (funcOrClass instanceof Class) {
            Class c = (Class)funcOrClass;
            if (c.isPrimitive()) {
                try {
                    int nargs = args.length;
                    switch (nargs) {
                        case 1: {
                            return Runtime.primitive(context, c, args[0], true);
                        }
                        case 2: {
                            int radix = (Integer)args[1];
                            return Runtime.primitive(context, c, args[0], true, radix);
                        }
                    }
                    throw new IllegalArgumentException(Pnuts.format(args));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (c.isArray()) {
                return Runtime.cast(context, c, args[0], true);
            }
            return context.config.callConstructor(context, c, args, casts);
        }
        throw new PnutsException("funcOrType.expected", new Object[]{Pnuts.format(funcOrClass)}, context);
    }

    protected static final Object call(Context context, Object funcOrClass, Object[] args, Class[] casts, int line) {
        Object ret;
        if (funcOrClass instanceof PnutsFunction) {
            ret = ((PnutsFunction)funcOrClass).exec(args, context);
        } else if (funcOrClass instanceof Class) {
            Class c = (Class)funcOrClass;
            if (c.isPrimitive()) {
                try {
                    int nargs = args.length;
                    switch (nargs) {
                        case 1: {
                            return Runtime.primitive(context, c, args[0], true);
                        }
                        case 2: {
                            int radix = (Integer)args[1];
                            return Runtime.primitive(context, c, args[0], true, radix);
                        }
                    }
                    throw new IllegalArgumentException(Pnuts.format(args));
                }
                catch (NumberFormatException e) {
                    context.updateLine(null, line, line);
                    return null;
                }
            }
            ret = c.isArray() ? Runtime.cast(context, c, args[0], true) : context.config.callConstructor(context, c, args, casts);
        } else {
            throw new PnutsException("funcOrType.expected", new Object[]{Pnuts.format(funcOrClass)}, context);
        }
        context.updateLine(null, line, line);
        return ret;
    }

    protected static Object newInstance(Context context, Class c, Object[] args, Class[] casts) {
        return context.config.callConstructor(context, c, args, casts);
    }

    protected static void jump(Object v) {
        throw new Jump(v);
    }

    protected static void escape(Object v) {
        throw new Escape(v);
    }

    protected static void setLine(Context context, int beginLine, int endLine) {
        context.updateLine(null, beginLine, endLine);
    }

    protected static void setLine(Context context, int line) {
        context.updateLine(line);
    }

    protected static int getBeginLine(Context context) {
        return context.beginLine;
    }

    protected static int getEndLine(Context context) {
        return context.endLine;
    }

    protected static Function getFunction(PnutsFunction pf, int nargs) {
        return pf.get(nargs);
    }

    protected static Enumeration getFunctions(PnutsFunction pf) {
        return pf.elements();
    }

    protected static Runtime getRuntime(Context context) {
        return context.runtime;
    }

    protected static Object getScriptSource(Context context) {
        return context.getScriptSource();
    }

    protected static Function getFunction(Context context) {
        return context.frame;
    }

    protected static void setPackage(Package pkg, Context context) {
        pkg.init(context);
    }

    public static String format(Object object, int maxArrayLength) {
        return Runtime.format(object, maxArrayLength, null);
    }

    static String format(Object object, int maxArrayLength, Class[] stopClasses) {
        int length;
        if (object == null) {
            return "null";
        }
        if (!Runtime.isArray(object)) {
            if (object instanceof String) {
                String str = (String)object;
                int len = str.length();
                StringBuffer buf = new StringBuffer();
                buf.append('\"');
                block19: for (int i = 0; i < len; ++i) {
                    char ch = str.charAt(i);
                    switch (ch) {
                        case '\\': {
                            buf.append("\\\\");
                            continue block19;
                        }
                        case '\b': {
                            buf.append("\\b");
                            continue block19;
                        }
                        case '\f': {
                            buf.append("\\f");
                            continue block19;
                        }
                        case '\t': {
                            buf.append("\\t");
                            continue block19;
                        }
                        case '\n': {
                            buf.append('\n');
                            continue block19;
                        }
                        case '\r': {
                            buf.append("\\r");
                            continue block19;
                        }
                        case '\"': {
                            buf.append("\\\"");
                            continue block19;
                        }
                        default: {
                            char[] cbuf = new char[]{ch};
                            byte[] conv = new String(cbuf).getBytes();
                            if (ch == '?' || !Character.isISOControl(ch) && (conv.length != 1 || conv[0] != 63)) {
                                buf.append(ch);
                                continue block19;
                            }
                            buf.append("\\u" + hexDigit[ch >> 12 & 0xF] + hexDigit[ch >> 8 & 0xF] + hexDigit[ch >> 4 & 0xF] + hexDigit[ch >> 0 & 0xF]);
                        }
                    }
                }
                buf.append('\"');
                return buf.toString();
            }
            if (object instanceof Character) {
                char ch = ((Character)object).charValue();
                switch (ch) {
                    case '\\': {
                        return "'\\'";
                    }
                    case '\b': {
                        return "'\\b'";
                    }
                    case '\f': {
                        return "'\\f'";
                    }
                    case '\t': {
                        return "'\\t'";
                    }
                    case '\n': {
                        return "'\\n'";
                    }
                    case '\r': {
                        return "'\\r'";
                    }
                    case '\'': {
                        return "'\\''";
                    }
                    case '?': {
                        return "'?'";
                    }
                }
                char[] buf = new char[]{ch};
                byte[] conv = new String(buf).getBytes();
                if (!(Character.isISOControl(ch) || conv.length == 1 && conv[0] == 63)) {
                    return "'" + ch + "'";
                }
                return "'\\u" + hexDigit[ch >> 12 & 0xF] + hexDigit[ch >> 8 & 0xF] + hexDigit[ch >> 4 & 0xF] + hexDigit[ch >> 0 & 0xF] + "'";
            }
            if (object instanceof Class) {
                Class c = (Class)object;
                String suffix = null;
                suffix = c.isInterface() ? " interface" : (c.isPrimitive() ? " type" : " class");
                return Runtime.getClassName(c) + suffix;
            }
            if (object instanceof Byte) {
                byte value = (Byte)object;
                return "#" + hexDigit[value >> 4 & 0xF] + hexDigit[value & 0xF];
            }
            if (object instanceof Float) {
                return object.toString() + "f";
            }
            if (object instanceof Calendar) {
                Calendar cal = (Calendar)object;
                DateFormat f = DateFormat.getDateTimeInstance();
                f.setTimeZone(cal.getTimeZone());
                return f.format(cal.getTime());
            }
            return object.toString();
        }
        String s = "";
        int last = length = Runtime.getArrayLength(object);
        s = s + "[";
        if (length > 0) {
            Object obj = Array.get(object, 0);
            s = s + Runtime.formatElement(obj, maxArrayLength, stopClasses);
        }
        if (maxArrayLength > 0 && maxArrayLength < length) {
            last = maxArrayLength;
        }
        for (int j = 1; j < last; ++j) {
            Object obj = Array.get(object, j);
            s = s + ", ";
            s = s + Runtime.formatElement(obj, maxArrayLength, stopClasses);
        }
        if (maxArrayLength > 0 && maxArrayLength < length) {
            s = s + ", ...";
        }
        s = s + "]";
        return s;
    }

    static String formatElement(Object obj, int maxArrayLength, Class[] stopClasses) {
        boolean stop = false;
        if (stopClasses != null) {
            for (int i = 0; i < stopClasses.length; ++i) {
                Class c = stopClasses[i];
                if (!c.isInstance(obj)) continue;
                stop = true;
                break;
            }
        }
        if (stop) {
            return obj.getClass().getName() + "@" + obj.hashCode();
        }
        return Runtime.format(obj, maxArrayLength);
    }

    static String getClassName(Class cls) {
        if (cls.isArray()) {
            StringBuffer buf = new StringBuffer();
            while (cls.isArray()) {
                buf.append("[]");
                cls = cls.getComponentType();
            }
            buf.insert(0, cls.getName());
            return buf.toString();
        }
        return cls.getName();
    }

    public static final Object add1(Object n) {
        return UnaryOperator.Add1.instance.operateOn(n);
    }

    protected static final Object add1(Object n, Context context) {
        return context._add1.operateOn(n);
    }

    public static final Object subtract1(Object n) {
        return UnaryOperator.Subtract1.instance.operateOn(n);
    }

    protected static final Object subtract1(Object n, Context context) {
        return context._subtract1.operateOn(n);
    }

    public static final Object negate(Object n) {
        return UnaryOperator.Negate.instance.operateOn(n);
    }

    protected static final Object negate(Object n, Context context) {
        return context._negate.operateOn(n);
    }

    public static final Object not(Object n) {
        return UnaryOperator.Not.instance.operateOn(n);
    }

    protected static final Object not(Object n, Context context) {
        return context._not.operateOn(n);
    }

    public static final Object add(Object n1, Object n2) {
        return BinaryOperator.Add.instance.operateOn(n1, n2);
    }

    protected static final Object add(Object n1, Object n2, Context context) {
        return context._add.operateOn(n1, n2);
    }

    public static final Object subtract(Object n1, Object n2) {
        return BinaryOperator.Subtract.instance.operateOn(n1, n2);
    }

    protected static final Object subtract(Object n1, Object n2, Context context) {
        return context._subtract.operateOn(n1, n2);
    }

    public static final Object multiply(Object n1, Object n2) {
        return BinaryOperator.Multiply.instance.operateOn(n1, n2);
    }

    protected static final Object multiply(Object n1, Object n2, Context context) {
        return context._multiply.operateOn(n1, n2);
    }

    public static final Object divide(Object n1, Object n2) {
        return BinaryOperator.Divide.instance.operateOn(n1, n2);
    }

    protected static final Object divide(Object n1, Object n2, Context context) {
        return context._divide.operateOn(n1, n2);
    }

    public static final Object mod(Object n1, Object n2) {
        return BinaryOperator.Mod.instance.operateOn(n1, n2);
    }

    protected static final Object mod(Object n1, Object n2, Context context) {
        return context._mod.operateOn(n1, n2);
    }

    public static final Object shiftLeft(Object n1, Object n2) {
        return BinaryOperator.ShiftLeft.instance.operateOn(n1, n2);
    }

    protected static final Object shiftLeft(Object n1, Object n2, Context context) {
        return context._shiftLeft.operateOn(n1, n2);
    }

    public static final Object shiftRight(Object n1, Object n2) {
        return BinaryOperator.ShiftRight.instance.operateOn(n1, n2);
    }

    protected static final Object shiftRight(Object n1, Object n2, Context context) {
        return context._shiftRight.operateOn(n1, n2);
    }

    public static Object shiftArithmetic(Object n1, Object n2) {
        return BinaryOperator.ShiftArithmetic.instance.operateOn(n1, n2);
    }

    protected static final Object shiftArithmetic(Object n1, Object n2, Context context) {
        return context._shiftArithmetic.operateOn(n1, n2);
    }

    public static final Object or(Object n1, Object n2) {
        return BinaryOperator.Or.instance.operateOn(n1, n2);
    }

    protected static final Object or(Object n1, Object n2, Context context) {
        return context._or.operateOn(n1, n2);
    }

    public static final Object and(Object n1, Object n2) {
        return BinaryOperator.And.instance.operateOn(n1, n2);
    }

    protected static final Object and(Object n1, Object n2, Context context) {
        return context._and.operateOn(n1, n2);
    }

    public static final Object xor(Object n1, Object n2) {
        return BinaryOperator.Xor.instance.operateOn(n1, n2);
    }

    protected static final Object xor(Object n1, Object n2, Context context) {
        return context._xor.operateOn(n1, n2);
    }

    public static final boolean lt(Object n1, Object n2) {
        return BooleanOperator.LT.instance.operateOn(n1, n2);
    }

    protected static final boolean lt(Object n1, Object n2, Context context) {
        return context._lt.operateOn(n1, n2);
    }

    public static final boolean gt(Object n1, Object n2) {
        return BooleanOperator.GT.instance.operateOn(n1, n2);
    }

    protected static final boolean gt(Object n1, Object n2, Context context) {
        return context._gt.operateOn(n1, n2);
    }

    public static final boolean ge(Object n1, Object n2) {
        return BooleanOperator.GE.instance.operateOn(n1, n2);
    }

    protected static final boolean ge(Object n1, Object n2, Context context) {
        return context._ge.operateOn(n1, n2);
    }

    public static final boolean le(Object n1, Object n2) {
        return BooleanOperator.LE.instance.operateOn(n1, n2);
    }

    protected static final boolean le(Object n1, Object n2, Context context) {
        return context._le.operateOn(n1, n2);
    }

    public static final boolean eq(Object n1, Object n2) {
        return BooleanOperator.EQ.instance.operateOn(n1, n2);
    }

    protected static final boolean eq(Object n1, Object n2, Context context) {
        return context._eq.operateOn(n1, n2);
    }

    public static final boolean ne(Object n1, Object n2) {
        return !BooleanOperator.EQ.instance.operateOn(n1, n2);
    }

    protected static final boolean ne(Object n1, Object n2, Context context) {
        return !context._eq.operateOn(n1, n2);
    }

    public static final int compareTo(Object n1, Object n2) {
        if (Runtime.gt(n1, n2)) {
            return 1;
        }
        if (Runtime.lt(n1, n2)) {
            return -1;
        }
        return 0;
    }

    protected static final int compareTo(Object n1, Object n2, Context context) {
        if (Runtime.gt(n1, n2, context)) {
            return 1;
        }
        if (Runtime.lt(n1, n2, context)) {
            return -1;
        }
        return 0;
    }

    public static URL getScriptURL(String name, Context context) {
        URL url = null;
        try {
            PrintWriter out;
            url = Pnuts.getResource(name, context);
            if (url == null) {
                url = Pnuts.getResource("/" + name, context);
            }
            if (url == null) {
                return null;
            }
            URLConnection conn = url.openConnection();
            conn.connect();
            if (context.verbose && (out = context.getTerminalWriter()) != null) {
                out.println("[loading " + url + "]");
                out.flush();
            }
        }
        catch (IOException ioe) {
            return null;
        }
        return url;
    }

    public static Executable getCompiledScript(String name, Context context) {
        String prefix = Pnuts.getCompiledClassPrefix();
        Object rt = null;
        try {
            Class cls;
            String cname = name.replace('/', '.').replace('-', '_');
            if (prefix != null) {
                cname = prefix + cname;
            }
            if ((rt = (cls = Pnuts.loadClass(cname, context)).newInstance()) instanceof Executable) {
                return rt;
            }
        }
        catch (Exception t) {
            // empty catch block
        }
        return null;
    }

    public static URL fileToURL(File file) throws IOException {
        String path = new File(file.getCanonicalPath()).getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public static Reader getScriptReader(InputStream in, Context context) {
        String encoding = context.encoding;
        if (encoding == null) {
            return new InputStreamReader(in);
        }
        try {
            return new InputStreamReader(in, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PnutsException(e, context);
        }
    }

    public static void printError(Throwable t, Context context) {
        context.onError(t);
        PrintWriter err = context.getErrorWriter();
        if (err != null) {
            if (context.verbose) {
                t.printStackTrace(err);
            } else {
                err.println(t);
            }
            err.flush();
        } else {
            t.printStackTrace();
        }
    }

    static String getMessage(String bundleName, String key, Object[] a) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
            String fmt = bundle.getString(key);
            if (fmt == null) {
                return null;
            }
            return MessageFormat.format(fmt, a);
        }
        catch (MissingResourceException e) {
            return bundleName + ":" + key + Runtime.format(a, 64);
        }
    }

    static Number compress(Number n) {
        if (n instanceof BigInteger) {
            BigInteger b = (BigInteger)n;
            if (b.compareTo(BinaryOperator.maxLong) > 0 || b.compareTo(BinaryOperator.minLong) < 0) {
                return n;
            }
            long l = b.longValue();
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }
        if (n instanceof BigDecimal) {
            int j = 0;
            String f = n.toString();
            int p = f.indexOf(46);
            if (p > 0) {
                char[] ca = f.toCharArray();
                for (int i = 0; i < ca.length - 2 && i < ca.length - p - 2 && ca[ca.length - i - 1] == '0'; ++i) {
                    ++j;
                }
                f = f.substring(0, ca.length - j);
            }
            if (f.length() < 16) {
                return new Double(n.doubleValue());
            }
            if (j > 0) {
                return new BigDecimal(f);
            }
            return n;
        }
        if (n instanceof Long) {
            long l = (Long)n;
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }
        return n;
    }

    static Number decimalNumber(String s, int radix) {
        if (radix == 16 || radix == 8) {
            return new BigInteger(s, radix);
        }
        return new BigDecimal(Runtime.deNormalize(s));
    }

    private static String deNormalize(String fmt) {
        char[] b;
        int pt = fmt.indexOf(46);
        int exp = fmt.indexOf(69);
        if (exp < 0) {
            return fmt;
        }
        int e = Integer.parseInt(fmt.substring(exp + 1));
        int i = 0;
        int k = 0;
        if (e < 0) {
            int j;
            b = new char[exp - e];
            i = 0;
            if (fmt.charAt(k) == '-') {
                b[i++] = 45;
                ++k;
            }
            b[i++] = 48;
            b[i++] = 46;
            for (j = 0; j < -e - 1; ++j) {
                b[i++] = 48;
            }
            b[i++] = fmt.charAt(k++);
            ++k;
            for (j = 0; j < exp - pt - 1; ++j) {
                b[i++] = fmt.charAt(k++);
            }
        } else if (exp - pt - 1 > e) {
            int j;
            b = new char[exp];
            i = 0;
            if (fmt.charAt(k) == '-') {
                b[i++] = 45;
            }
            int n = i++;
            int n2 = ++k;
            ++k;
            b[n] = fmt.charAt(n2);
            ++k;
            for (j = 0; j < e; ++j) {
                b[i++] = fmt.charAt(k++);
            }
            b[i++] = 46;
            for (j = 0; j < exp - pt - 1 - e; ++j) {
                b[i++] = fmt.charAt(k++);
            }
        } else {
            int j;
            b = new char[exp - 1 + (e - (exp - pt - 1))];
            i = 0;
            if (fmt.charAt(k) == '-') {
                b[i++] = 45;
            }
            int n = i++;
            int n3 = ++k;
            ++k;
            b[n] = fmt.charAt(n3);
            ++k;
            for (j = 0; j < exp - pt - 1; ++j) {
                b[i++] = fmt.charAt(k++);
            }
            for (j = 0; j < e - (exp - pt - 1); ++j) {
                b[i++] = 48;
            }
        }
        return new String(b);
    }

    public static String getProperty(final String key) {
        String v;
        Properties p = Pnuts.defaultSettings;
        if (p != null && (v = p.getProperty(key)) != null) {
            return v;
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(key);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    protected synchronized Accessor getAccessor(Class cls, Class stopClass) {
        Object key = stopClass == null ? cls : new BeanInfoParam(cls, stopClass);
        Accessor a = (Accessor)beanAccessors.get(key);
        if (a == null) {
            a = this.createBeanAccessor(cls, stopClass);
            beanAccessors.put(key, a);
        }
        return a;
    }

    protected Accessor createBeanAccessor(Class cls, Class stopClass) {
        return new Accessor(cls, stopClass);
    }

    public static void setBeanProperty(Context context, Object target, String name, Object value) {
        try {
            context.runtime.setBeanProperty(target, name, value, null);
        }
        catch (IllegalAccessException e1) {
            throw new PnutsException(e1, context);
        }
        catch (InvocationTargetException e2) {
            throw new PnutsException(e2.getTargetException(), context);
        }
    }

    public static Object getBeanProperty(Context context, Object target, String name) {
        try {
            return context.runtime.getBeanProperty(target, name, null);
        }
        catch (IllegalAccessException e1) {
            throw new PnutsException(e1, context);
        }
        catch (InvocationTargetException e2) {
            throw new PnutsException(e2.getTargetException(), context);
        }
    }

    public Object getBeanProperty(Object target, String name) throws IllegalAccessException, InvocationTargetException {
        return this.getBeanProperty(target, name, null);
    }

    protected Object getBeanProperty(Object target, String name, Class stopClass) throws IllegalAccessException, InvocationTargetException {
        Accessor a = this.getAccessor(target.getClass(), stopClass);
        Method readMethod = (Method)a.findReadMethod(name);
        if (readMethod != null) {
            try {
                return readMethod.invoke(target, noarg);
            }
            catch (IllegalAccessException e1) {
                Method _m;
                Class<?> cls = readMethod.getDeclaringClass();
                if (!Modifier.isPublic(cls.getModifiers()) && (_m = Runtime.findCallableMethod(cls, readMethod.getName(), readMethod.getParameterTypes())) != null) {
                    a.addReadMethod(name, _m);
                    try {
                        return _m.invoke(target, noarg);
                    }
                    catch (IllegalAccessException iae) {
                        // empty catch block
                    }
                }
                return Configuration.normalConfiguration.reInvoke(e1, readMethod, target, noarg);
            }
        }
        throw new IllegalArgumentException("not readable property: target=" + target + ", fieldName=" + name);
    }

    public void setBeanProperty(Object target, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        this.setBeanProperty(target, name, value, null);
    }

    protected void setBeanProperty(Object target, String name, Object value, Class stopClass) throws IllegalAccessException, InvocationTargetException {
        Accessor a = this.getAccessor(target.getClass(), stopClass);
        Method writeMethod = (Method)a.findWriteMethod(name);
        if (writeMethod != null) {
            Class<?> type = writeMethod.getParameterTypes()[0];
            if (type.isArray() && !type.isInstance(value)) {
                value = Runtime.transform(Runtime.getBottomType(type), value);
            }
            Object[] arg = new Object[]{value};
            try {
                writeMethod.invoke(target, arg);
                return;
            }
            catch (IllegalAccessException e1) {
                Method _m;
                Class<?> cls = writeMethod.getDeclaringClass();
                if (!Modifier.isPublic(cls.getModifiers()) && (_m = Runtime.findCallableMethod(cls, writeMethod.getName(), writeMethod.getParameterTypes())) != null) {
                    a.addWriteMethod(name, _m);
                    try {
                        _m.invoke(target, arg);
                        return;
                    }
                    catch (IllegalAccessException iae) {
                        // empty catch block
                    }
                }
                Configuration.normalConfiguration.reInvoke(e1, writeMethod, target, arg);
                return;
            }
        }
        throw new IllegalArgumentException("not writable property: target=" + target + ", fieldName=" + name);
    }

    public Class getBeanPropertyType(Class cls, String name) {
        return this.getAccessor(cls, null).getType(name);
    }

    protected static PnutsFunction defineUnboundFunction(Function f, String symbol, Package pkg) {
        Object o;
        Binding v = pkg.lookup0(symbol);
        if (v != null && (o = v.get()) instanceof PnutsFunction) {
            return f.register((PnutsFunction)o, true);
        }
        return f.register(null);
    }

    static Object lookupTopLevelValue(String symbol, Context context) {
        Value v;
        ModuleList moduleList = context.moduleList;
        if (moduleList != null && (v = moduleList.resolve(symbol, context)) != null) {
            return v.get();
        }
        for (Package parent = context.currentPackage.getParent(); parent != null; parent = parent.getParent()) {
            v = parent.lookup(symbol);
            if (v == null) continue;
            return v.get();
        }
        return null;
    }

    protected static PnutsFunction defineTopLevelFunction(Function f, String symbol, Package pkg, Context context) {
        NamedValue value = pkg.lookup(symbol);
        Object o = null;
        if (value != null) {
            o = value.get();
        }
        PnutsFunction pf = o instanceof PnutsFunction ? f.register((PnutsFunction)o) : ((o = Runtime.lookupTopLevelValue(symbol, context)) instanceof PnutsFunction ? f.register((PnutsFunction)o, true) : f.register(null));
        pkg.set(symbol, pf, context);
        return pf;
    }

    public static String unparse(SimpleNode node, Context context) {
        UnparseVisitor unparseVisitor = new UnparseVisitor();
        return (String)node.accept(unparseVisitor, context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class BeanInfoParam {
        Class targetClass;
        Class stopClass;

        BeanInfoParam(Class targetClass, Class stopClass) {
            this.targetClass = targetClass;
            this.stopClass = stopClass;
        }

        public int hashCode() {
            return this.targetClass.hashCode() ^ this.stopClass.hashCode();
        }

        public boolean equals(Object that) {
            if (that instanceof BeanInfoParam) {
                BeanInfoParam p = (BeanInfoParam)that;
                return p.targetClass == this.targetClass && p.stopClass == this.stopClass;
            }
            return false;
        }
    }

    protected static class Accessor {
        protected Class beanClass;
        protected Class stopClass;
        HashMap readMethods;
        HashMap writeMethods;
        HashMap types;

        protected Accessor(Class cls, Class stopClass) {
            this.init(cls, stopClass);
        }

        BeanInfo getBeanInfo(Class targetClass, Class stopClass) throws IntrospectionException {
            if (stopClass == null) {
                return Introspector.getBeanInfo(targetClass);
            }
            return Introspector.getBeanInfo(targetClass, stopClass);
        }

        void init(Class cls, Class stopClass) {
            this.beanClass = cls;
            this.stopClass = stopClass;
            this.readMethods = new HashMap();
            this.writeMethods = new HashMap();
            this.types = new HashMap();
            try {
                BeanInfo beanInfo = this.getBeanInfo(cls, stopClass);
                PropertyDescriptor[] pd = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < pd.length; ++i) {
                    PropertyDescriptor p = pd[i];
                    String name = p.getName();
                    Method m = p.getReadMethod();
                    this.types.put(name, p.getPropertyType());
                    if (m != null) {
                        this.addReadMethod(name, m);
                    }
                    if ((m = p.getWriteMethod()) == null) continue;
                    this.addWriteMethod(name, m);
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }

        public void addReadMethod(String name, Object m) {
            this.readMethods.put(name, m);
        }

        public void addWriteMethod(String name, Object m) {
            this.writeMethods.put(name, m);
        }

        public Object findReadMethod(String name) {
            return this.readMethods.get(name);
        }

        public Object findWriteMethod(String name) {
            return this.writeMethods.get(name);
        }

        public Class getType(String name) {
            return (Class)this.types.get(name);
        }
    }

    protected static class TypeMap {
        Class type;
        Object value;
        TypeMap next;

        public TypeMap(Class type, Object value, TypeMap next) {
            this.type = type;
            this.value = value;
            this.next = next;
        }
    }

    static class AutoloadScript
    implements AutoloadHook,
    Serializable {
        String file;
        ModuleList moduleList;
        Package pkg;
        String encoding;
        Configuration config;

        AutoloadScript(String file, Context context) {
            this.file = file;
            this.pkg = context.rootPackage;
            this.moduleList = context.moduleList;
            this.encoding = context.encoding;
            this.config = context.config;
        }

        public synchronized void load(String name, Context context) {
            try {
                Context ctx = (Context)context.clone();
                ctx.moduleList = this.moduleList;
                ctx.localModuleList = null;
                ctx.setCurrentPackage(this.pkg);
                ctx.encoding = this.encoding;
                ctx.config = this.config;
                Pnuts.load(this.file, ctx);
            }
            catch (Escape esc) {
                throw esc;
            }
            catch (FileNotFoundException e) {
                throw new PnutsException(e, context);
            }
        }
    }
}

