/*
 * Decompiled with CFR 0.152.
 */
package pnuts.security;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import pnuts.security.PackagePermission;

final class PackagePermissionCollection
extends PermissionCollection
implements Serializable {
    private Hashtable permissions = new Hashtable(10);
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        PackagePermission pp = (PackagePermission)permission;
        this.permissions.put(pp.getName(), permission);
        if (!this.all_allowed && pp.getName().equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            return false;
        }
        PackagePermission pp = (PackagePermission)permission;
        if (this.all_allowed) {
            return true;
        }
        String path = pp.getName();
        Permission x = (Permission)this.permissions.get(path);
        if (x != null) {
            return x.implies(permission);
        }
        int offset = path.length() - 1;
        while (true) {
            int last1 = path.lastIndexOf("::", offset);
            int last2 = path.lastIndexOf(".", offset);
            if (last1 == -1 && last2 == -1) break;
            int last = last2 > last1 ? last2 : last1;
            x = (Permission)this.permissions.get(path = path.substring(0, last + 1) + "*");
            if (x != null) {
                return x.implies(permission);
            }
            offset = last - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

