/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import pnuts.ext.NonPublicMemberAccessor;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsFunction;
import pnuts.tools.DebugContext;
import pnuts.tools.StackFrameInspector;
import pnuts.tools.VisualDebuggerView;

class ContextView {
    private static final Font monospaced = Font.getFont("monospaced");
    private static final Configuration debugConfig = new NonPublicMemberAccessor();
    private JTextField currentPackage;
    private JTextField classLoader;
    private JList imports;
    private JList modules;
    private JTable locals;
    private JTable contextLocals;
    private JTextField inspect;
    private JTextArea result;
    private Context context;
    private GridBagLayout gb;

    public JFrame getFrame() {
        JFrame jfr = new JFrame();
        this.setupGUI(jfr.getContentPane());
        return jfr;
    }

    public Container getContainer() {
        JPanel panel = new JPanel();
        this.setupGUI(panel);
        return panel;
    }

    static void add(GridBagLayout gb, Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int weightx, int weighty, int anchor, int fill) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = gridheight;
        c.weightx = weightx;
        c.weighty = weighty;
        c.anchor = anchor;
        c.fill = fill;
        c.insets = new Insets(2, 2, 2, 2);
        gb.setConstraints(component, c);
        container.add(component);
    }

    void addLabel(Container container, Component component, int gridx, int gridy) {
        ContextView.add(this.gb, container, component, gridx, gridy, 1, 1, 0, 0, 12, 0);
    }

    void add_h(Container container, Component component, int gridx, int gridy) {
        ContextView.add(this.gb, container, component, gridx, gridy, 1, 1, 1, 0, 10, 2);
    }

    void add_b(Container container, Component component, int gridx, int gridy) {
        ContextView.add(this.gb, container, component, gridx, gridy, 1, 1, 1, 1, 10, 1);
    }

    static JLabel createJLabel(String key) {
        return new JLabel(VisualDebuggerView.getResourceString(key + ".label"));
    }

    public void setupGUI(Container contentPane) {
        this.gb = new GridBagLayout();
        Font monospaced = Font.getFont("monospaced");
        contentPane.setLayout(this.gb);
        this.addLabel(contentPane, ContextView.createJLabel("currentPackage"), 0, 0);
        this.currentPackage = new JTextField(20);
        this.currentPackage.setEditable(false);
        this.currentPackage.setBackground(Color.white);
        this.currentPackage.setSelectionColor(Color.white);
        this.currentPackage.setFont(monospaced);
        this.currentPackage.setAutoscrolls(true);
        this.add_h(contentPane, this.currentPackage, 1, 0);
        this.addLabel(contentPane, ContextView.createJLabel("classLoader"), 0, 1);
        this.classLoader = new JTextField(20);
        this.classLoader.setFont(monospaced);
        this.classLoader.setAutoscrolls(true);
        this.classLoader.setEditable(false);
        this.classLoader.setSelectionColor(Color.white);
        this.classLoader.setBackground(Color.white);
        this.add_h(contentPane, this.classLoader, 1, 1);
        this.addLabel(contentPane, ContextView.createJLabel("imports"), 0, 3);
        this.imports = new JList();
        this.imports.setFont(monospaced);
        this.imports.setFocusable(false);
        this.imports.setSelectionBackground(this.imports.getBackground());
        JScrollPane importspane = new JScrollPane(this.imports);
        importspane.setPreferredSize(new Dimension(300, 70));
        this.add_h(contentPane, importspane, 1, 3);
        this.addLabel(contentPane, ContextView.createJLabel("modules"), 0, 4);
        this.modules = new JList();
        this.modules.setSelectionBackground(this.modules.getBackground());
        this.modules.setFont(monospaced);
        this.modules.setFocusable(false);
        JScrollPane modulespane = new JScrollPane(this.modules);
        modulespane.setPreferredSize(new Dimension(300, 70));
        this.add_h(contentPane, modulespane, 1, 4);
        Object[] columnNames = new String[]{VisualDebuggerView.getResourceString("keyLabel"), VisualDebuggerView.getResourceString("valueLabel")};
        this.addLabel(contentPane, ContextView.createJLabel("locals"), 0, 5);
        this.locals = new JTable(new DefaultTableModel(columnNames, 0));
        this.locals.setRowSelectionAllowed(false);
        JScrollPane localspane = new JScrollPane(this.locals);
        localspane.setPreferredSize(new Dimension(300, 130));
        this.add_h(contentPane, localspane, 1, 5);
        this.addLabel(contentPane, ContextView.createJLabel("contextLocals"), 0, 6);
        this.contextLocals = new JTable(new DefaultTableModel(columnNames, 0));
        this.contextLocals.setRowSelectionAllowed(false);
        JScrollPane contextlocalpane = new JScrollPane(this.contextLocals);
        contextlocalpane.setPreferredSize(new Dimension(300, 70));
        this.add_h(contentPane, contextlocalpane, 1, 6);
        ContextView.add(this.gb, contentPane, ContextView.createJLabel("inspectWatch"), 0, 7, 1, 2, 0, 0, 12, 0);
        this.inspect = new JTextField(20);
        this.inspect.setBackground(Color.white);
        this.inspect.setFont(monospaced);
        this.inspect.setAutoscrolls(true);
        ContextView.add(this.gb, contentPane, this.inspect, 1, 7, 1, 1, 1, 0, 10, 1);
        this.result = new JTextArea(2, 0);
        this.result.setLineWrap(true);
        this.result.setEditable(false);
        JScrollPane resultpane = new JScrollPane(this.result);
        resultpane.setPreferredSize(new Dimension(300, 1));
        this.add_b(contentPane, resultpane, 1, 8);
        this.inspect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ContextView.this.context == null) {
                    return;
                }
                try {
                    Context c = (Context)((DebugContext)ContextView.this.context).clone(false, false, true);
                    c.setConfiguration(debugConfig);
                    Object r = Pnuts.eval(ContextView.this.inspect.getText(), c);
                    ContextView.this.result.setText(Pnuts.format(r));
                }
                catch (Exception e2) {
                    ContextView.this.result.setText(e2.toString());
                }
            }
        });
    }

    public void setContext(Context context) {
        this.context = context;
        this.currentPackage.setText(String.valueOf(context.getCurrentPackage()));
        this.classLoader.setText(String.valueOf(context.getClassLoader()));
        this.imports.setListData((String[])PnutsFunction.IMPORT.call(new Object[0], context));
        this.modules.setListData(context.usedPackages());
        DefaultTableModel dtm = (DefaultTableModel)this.locals.getModel();
        dtm.setRowCount(0);
        TreeMap localSymbols = new TreeMap();
        try {
            StackFrameInspector.localSymbols(context, localSymbols);
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator it = localSymbols.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            dtm.addRow(new Object[]{entry.getKey(), Pnuts.format(entry.getValue())});
        }
        DefaultTableModel dtm2 = (DefaultTableModel)this.contextLocals.getModel();
        TreeMap<String, Object> tmap = new TreeMap<String, Object>();
        Enumeration keys = context.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            tmap.put(name, context.get(name));
        }
        dtm2.setRowCount(0);
        Iterator it2 = tmap.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            dtm2.addRow(new Object[]{entry.getKey(), Pnuts.format(entry.getValue())});
        }
        String watch = this.inspect.getText();
        if (watch != null && watch.length() > 0) {
            try {
                Context c = (Context)((DebugContext)context).clone(false, false, true);
                c.setConfiguration(debugConfig);
                Object r = Pnuts.eval(watch, c);
                this.result.setText(Pnuts.format(r));
            }
            catch (Exception e2) {
                this.result.setText(e2.toString());
            }
        } else {
            this.result.setText("");
        }
    }
}

