/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.util.Enumeration;
import java.util.Vector;
import pnuts.lang.Context;
import pnuts.lang.Function;
import pnuts.lang.Package;
import pnuts.lang.PnutsImpl;
import pnuts.lang.SimpleNode;
import pnuts.tools.CommandEvent;
import pnuts.tools.CommandListener;
import pnuts.tools.Debugger;

public class DebugContext
extends Context {
    private static final boolean DEBUG = false;
    private Vector listeners = null;
    private int callDepth = 0;
    private int lastCallDepth = 0;
    private Debugger debugger;

    public DebugContext() {
        this.setImplementation(new PnutsImpl());
    }

    public DebugContext(Package pkg) {
        super(pkg);
        this.setImplementation(new PnutsImpl());
    }

    public DebugContext(Context context) {
        super(context);
        this.setImplementation(new PnutsImpl());
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    protected void open(Function f, Object[] args) {
        super.open(f, args);
        ++this.callDepth;
        this.fireCommandEvent(3, new Object[]{f, args});
    }

    protected void close(Function f, Object[] args) {
        this.fireCommandEvent(4, new Object[]{f, args});
        super.close(f, args);
        --this.callDepth;
    }

    public int getEvalDepth() {
        return this.depth;
    }

    public int getCallDepth() {
        return this.callDepth;
    }

    protected int getBeginLine() {
        return this.beginLine;
    }

    protected int getEndLine() {
        return this.endLine;
    }

    protected Object getScriptSource() {
        return super.getScriptSource();
    }

    protected void updateLine(SimpleNode node, int beginLine, int endLine) {
        int line = beginLine;
        if (line > 0 && (this.beginLine != line || this.callDepth != this.lastCallDepth)) {
            this.beginLine = line;
            this.endLine = endLine;
            this.lastCallDepth = this.callDepth;
            this.fireCommandEvent(0, node);
        }
    }

    protected void onError(Throwable t) {
        this.fireCommandEvent(1, t);
    }

    protected void onExit(Object arg) {
        this.fireCommandEvent(2, arg);
    }

    void fireCommandEvent(int type, Object arg) {
        if (this.listeners != null) {
            Vector vec = (Vector)this.listeners.clone();
            CommandEvent event = new CommandEvent(this, type, arg);
            Enumeration e = vec.elements();
            while (e.hasMoreElements()) {
                ((CommandListener)e.nextElement()).signal(event);
            }
        }
    }

    public synchronized void addCommandListener(CommandListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public synchronized void removeCommandListener(CommandListener listener) {
        this.listeners.removeElement(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    public Object clone(boolean clear_attributes, boolean clear_locals, boolean clear_listeners) {
        DebugContext ret = (DebugContext)super.clone(clear_attributes, clear_locals);
        if (clear_listeners) {
            ret.listeners = null;
        }
        return ret;
    }
}

