/* $Id: ApprovalAction.java,v 1.14 2005/08/26 04:45:07 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.ServiceException;

import jp.co.argo21.nautica.workflow.sample.actionform.ApprovalCommentForm;
import jp.co.argo21.nautica.workflow.sample.actionform.UserBean;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.StatusConstants;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * \ʂŏF{^̏sANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.14 $
 * @since   Nautica Workflow 0.9
 */
public class ApprovalAction extends Action {

    /**
     * \FB
     * 
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return ANVtH[h
     */
    public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
    	            
    	// ZbVуNGXg\e擾
        ApprovalCommentForm approvalForm = (ApprovalCommentForm)form;
        UserBean user = (UserBean)request.getSession().getAttribute("user");
        String sessionID = user.getSessionID();
        Application app = (Application) request.getSession().getAttribute("appmodel");
        String appID = app.getId();
        String wid = (String) request.getSession().getAttribute("wid");
        
        try {
            // \gUNVe[u[]"WAIT"ŁA
            // [FubNԍ]ŏ̃R[h擾
            AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
            AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appID);
            AppTransaction appTrans = null;
            AppTransaction nextAppTrans = null;
            for (int i = 0; i < appTranses.length; i++) {
                String status = appTranses[i].getAppStatus();
                if ((StatusConstants.STATUS_TRANS_WAIT).equals(status)) {
                    appTrans = appTranses[i];
                    if ( i < appTranses.length-1) {
                        nextAppTrans = appTranses[i+1];
                    }
                    break;
                }
            }
            
            // 擾\gUNVe[u
            // [][\/F҃[UID][Rg][Ώۓ]XV
            if (appTrans != null) {
                appTrans.setAppStatus(StatusConstants.STATUS_TRANS_APPROVE);
                appTrans.setAppUserID(user.getUserID());
                appTrans.setComment(approvalForm.getComment());
                appTrans.setDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                appTransDao.updateAppTransaction(appTrans);
            }
                        
            // \gUNVe[u̍XṼR[h
            // []"WAIT"ɍXV
            int approveAccount = app.getKind().getApproveAccount();
            if (nextAppTrans != null && nextAppTrans.getApproveAccountID() < approveAccount) {
                nextAppTrans.setAppStatus(StatusConstants.STATUS_TRANS_WAIT);
                appTransDao.updateStatus(nextAppTrans);
            }
            
            // ƍڂ̃vZXϐ[F]"ACK"ɐݒ
            WorkItemHandler wfWorkitemHandler = SingletonServices.getInstance().getWfWorkitemHandler();
            Attribute attr = new Attribute();
            attr.setName(Constants.APPROVAL_RESULT);
            attr.setValue(Constants.ACK);
            attr.setType(1);
            wfWorkitemHandler.assignWorkItemAttribute(sessionID, wid, attr);
            
            // ŏIF҂̏ꍇAvZXϐ[]"CONFIRM_WAIT"ɍXV
            int approveCount = app.getKind().getApproveAccount();
            if (approveCount == appTrans.getApproveAccountID()+1) {
                Attribute status = new Attribute();
                status.setName(Constants.STATUS);
                status.setValue(StatusConstants.CONFIRM_WAIT);
                status.setType(1);
                wfWorkitemHandler.assignWorkItemAttribute(sessionID, wid, status);
            }
            
            // ƍڂ̊
            wfWorkitemHandler.completeWorkItem(sessionID,wid);

            // \ԍNGXgɐݒ
            request.setAttribute("appid", appID);
            
            return mapping.findForward(Constants.SUCCESS);
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (RemoteException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (ServiceException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);
        }
    }
}