/* $Id: ShowStatusAction.java,v 1.9 2005/08/26 04:45:09 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.rmi.RemoteException;
import java.sql.SQLException;

import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.argo21.nautica.workflow.sample.actionform.ApplicationContentBean;
import jp.co.argo21.nautica.workflow.sample.actionform.BeanFactory;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.security.simple.UserManagerRemote;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * ꌏ̏F󋵂\ANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class ShowStatusAction extends Action {
    
	/**
	 * F󋵂ꌏ\B
	 * 
	 * @param mapping ANV}bsO
	 * @param form ANVtH[
	 * @param request NGXg
	 * @param response X|X
	 * @return ANVtH[h
	 */
	public ActionForward execute(
	        ActionMapping mapping,
	        ActionForm form,
	        HttpServletRequest request,
	        HttpServletResponse response)
	{
        // NGXg\ԍ擾
	    String appID = request.getParameter("appid");
	    
	    try {
		    // \擾
	        Application appinfo = DAOFactory.getApplicationDAO().getApplicationByID(appID);
	        AppKind appkind = appinfo.getKind();
	        BeanFactory factory = BeanFactory.getInstance(appkind.getAppkindID());
	        ApplicationContentBean contentBeanFromModel = factory.getContentBeanFromModel(appinfo);
	        AppTransaction[] apptransaction = DAOFactory.getAppTransactionDAO().getAppTransactionsByAppID(appID);

	        // \̂߁A\ҁEF҂̖OZbg
            // [w̏ꍇA[ɑΉgDZbg
	        UserManagerRemote userManager = SingletonServices.getInstance().getUserManager();
	        for (int i = 0; i < apptransaction.length; i++) {
	            String userID = apptransaction[i].getAppUserID();
	            if (userID != null && !userID.equals("")) {
	                String userName = userManager.getUser(userID).getName();
	                apptransaction[i].setAppUserID(userName);
	            } else {
                    String roleID = apptransaction[i].getAppRoleID();
                    if ((AppTransactionDAO.JINJI_ROLE).equals(roleID)) {
                        apptransaction[i].setAppUserID(Constants.JINJI_DEPT);
                    }                 
                }
	        }
	        
	        // NGXgɒlZbg
	        request.setAttribute("app", contentBeanFromModel);
	        request.setAttribute("apptransaction",apptransaction);
	        
	        return mapping.findForward(Constants.SUCCESS);
	    
	    } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // R[h̎擾Ɏs
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
	        return mapping.findForward(Constants.FATAL_ERROR);
	    } catch (NamingException e) {
            // ZbV
            request.getSession().invalidate();
            // GWڑɎsi[UǗ擾sj
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
	        return mapping.findForward(Constants.FATAL_ERROR);
	    } catch (RemoteException e) {
            // ZbV
            request.getSession().invalidate();
            // GWڑɎsi[U擾sj
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
	        return mapping.findForward(Constants.FATAL_ERROR);
	    } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[ʂ֑J
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);	        
	    }
    }
}