/* $Id: SingletonServices.java,v 1.5 2005/08/26 04:45:00 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.rpc.ServiceException;

import jp.co.argo21.nautica.workflow.security.simple.OrganizationManagerRemote;
import jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote;
import jp.co.argo21.nautica.workflow.security.simple.UserManagerRemote;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandlerServiceLocator;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandlerServiceLocator;
import jp.co.argo21.nautica.workflow.soap.WorkflowServiceConnector;
import jp.co.argo21.nautica.workflow.soap.WorkflowServiceConnectorServiceLocator;

/**
 * [Nt[GWƂ̐ڑ擾NXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class SingletonServices {

    private WorkflowServiceConnector conn;
    private UserManagerRemote usm;
    private OrganizationManagerRemote osm;
    private RoleManagerRemote rsm;    
    private WorkItemHandler wih;    
    private WorkflowEngineHandler weh;
    
    private static final String FACTORY_INITIAL = "java.naming.factory.initial";
    private static final String CNCTXFACTORY = "com.sun.jndi.cosnaming.CNCtxFactory";
    private static final String PROVIDER_URL = "java.naming.provider.url";
    private String defaultUrl = "iiop://localhost:1050";
    
    private static final String USER_MANAGER = "WorkflowUserManager";
    private static final String ORGANIZATION_MANAGER = "WorkflowOrganizationManager";
    private static final String ROLE_MANAGER = "WorkflowRoleManager";
    
    private static String NAUTICA_WORKFLOW_URL = "nautica.workflow.url";
    
    private static final SingletonServices singleton = new SingletonServices();

    /**
     * RXgN^
     * 
     * @throws IOException
     */
    private SingletonServices() {
    }
    
    /**
     * ̃NX̃CX^XԂB
     * 
     * @return CX^X
     */
    public static SingletonServices getInstance() {
        return singleton;
    }
    
    /**
     * [UǗԂB
     * 
     * @return [UǗ
     * @throws NamingException l[~OOꍇ
     */
    public UserManagerRemote getUserManager() throws NamingException, IOException {
        if (usm == null) {
            System.setProperty(FACTORY_INITIAL, CNCTXFACTORY);
            String url = getNauticaWorkflowConfig(NAUTICA_WORKFLOW_URL);
            if (url == null || url.equals("")) {
                System.setProperty(PROVIDER_URL, defaultUrl);
            } else {
                System.setProperty(PROVIDER_URL, url);
            }
            Context context = new InitialContext();
            Object ref = context.lookup(USER_MANAGER);
            usm = (UserManagerRemote) PortableRemoteObject.narrow(ref, UserManagerRemote.class);
        }
        return usm;
    }

    /**
     * gDǗԂB
     * 
     * @return gDǗ
     * @throws NamingException l[~OOꍇ
     */
    public OrganizationManagerRemote getOrganizationManager() throws NamingException, IOException {
        if (osm == null) {
            System.setProperty(FACTORY_INITIAL, CNCTXFACTORY);
            String url = getNauticaWorkflowConfig(NAUTICA_WORKFLOW_URL);
            if (url == null || url.equals("")) {
                System.setProperty(PROVIDER_URL, defaultUrl);
            } else {
                System.setProperty(PROVIDER_URL, url);
            }
            Context context = new InitialContext();
            Object ref = context.lookup(ORGANIZATION_MANAGER);
            osm = (OrganizationManagerRemote) PortableRemoteObject.narrow(ref,
                    OrganizationManagerRemote.class);
        }
        return osm;
    }

    /**
     * [ǗԂB
     * 
     * @return [Ǘ
     * @throws NamingException l[~OOꍇ
     */
    public RoleManagerRemote getRoleManager() throws NamingException, IOException {
        if (rsm == null) {
            System.setProperty(FACTORY_INITIAL, CNCTXFACTORY);
            String url = getNauticaWorkflowConfig(NAUTICA_WORKFLOW_URL);
            if (url == null || url.equals("")) {
                System.setProperty(PROVIDER_URL, defaultUrl);
            } else {
                System.setProperty(PROVIDER_URL, url);
            }
            Context context = new InitialContext();
            Object ref = context.lookup(ROLE_MANAGER);
            rsm = (RoleManagerRemote) PortableRemoteObject.narrow(ref, RoleManagerRemote.class);
        }
        return rsm;
    }

    /**
     * [Nt[̃RlN^ԂB
     * 
     * @return RlN^
     * @throws ServiceException RlN^̎擾Ɏsꍇ
     */
    public WorkflowServiceConnector getWfConnection() throws ServiceException {
        if (conn == null) {
            conn = new WorkflowServiceConnectorServiceLocator()
            .getWorkflowServiceConnector();
        }
        return conn;
    }
    
    /**
     * ƍڂ̃nhԂB
     * 
     * @return ƍڃnh
     * @throws ServiceException ƍڃnh̎擾Ɏsꍇ
     */
    public WorkItemHandler getWfWorkitemHandler() throws ServiceException {
        if (wih == null) {
            wih = new WorkItemHandlerServiceLocator().getWorkItemHandler();
        }
        return wih;
    }
    
    /**
     * GW̃nhԂB
     * 
     * @return GWnh
     * @throws ServiceException GWnh̎擾Ɏsꍇ
     */
    public WorkflowEngineHandler getWfEngineHandler() throws ServiceException {
        if (weh == null) {
            weh = new WorkflowEngineHandlerServiceLocator().getWorkflowEngineHandler();
        }
        return weh;
    }
    
    /**
     * ݒԂB
     * 
     * @param key L[
     * @return L[ɑΉl
     * @throws IOException [hɎsꍇ
     */
    private String getNauticaWorkflowConfig(String key) throws IOException {
        InputStream is = 
            SingletonServices.class.getClassLoader().
            getResourceAsStream("../conf/nautica.properties");
        Properties props = new Properties();
        props.load(is);
        
        return (String) props.get(key);
    }
    
    /**
     * ݒ肳ꂽvZX`IDԂB
     * 
     * @param key L[
     * @return L[ɑΉl
     * @throws IOException [hɎsꍇ
     */
    public String getProcessDefID(String key) throws IOException {
        InputStream is = 
            SingletonServices.class.getClassLoader().
            getResourceAsStream("../conf/sample.properties");
        Properties props = new Properties();
        props.load(is);
        
        return (String) props.get(key);
    }
}