# サンプルアプリ用テーブル作成 

# テーブル名：キーシーケンス管理
# テーブルID：KEYSEQ
# M/T：T
# 備考：ユニークキー取得用
CREATE TABLE IF NOT EXISTS KEYSEQ (
    NAME            VARCHAR(32)     NOT NULL    PRIMARY KEY 	COMMENT 'キーシーケンス名',
    SEQ             INTEGER(10)     NOT NULL    DEFAULT 0   	COMMENT 'シーケンス、初期値は0'
) ENGINE=InnoDB;


# テーブル名：申請種別
# テーブルID：APPKIND
# M/T：M
# 備考：
CREATE TABLE IF NOT EXISTS APPKIND (
    APPKIND_ID            VARCHAR(128)    NOT NULL    PRIMARY KEY  COMMENT '申請種別コード',
    APPKIND_NAME          VARCHAR(128)    NOT NULL                 COMMENT '申請種別名',
    ROLE_ID               VARCHAR(64)     NOT NULL                 COMMENT 'ロールID',
    APP_TABLE_NAME        VARCHAR(128)    NOT NULL                 COMMENT '申請テーブル名',
    APPROVE_ACCOUNT       INTEGER(10)     NOT NULL    DEFAULT 0    COMMENT '承認ブロック数',
    CONFIRM_ACCOUNT		  INTEGER(10)	  DEFAULT 0				   COMMENT '同報ブロック数'
) ENGINE=InnoDB;


# テーブル名：申請トランザクション
# テーブルID：APPTRANSACTION
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS APPTRANSACTION (
    APP_ID             VARCHAR(128)    NOT NULL     COMMENT '申請書番号',
    APPROVE_ACCOUNT_ID INTEGER(10)     NOT NULL     COMMENT '承認ブロックコード',
    APPKIND_ID         VARCHAR(128)    NOT NULL     COMMENT '申請種別コード',
    APP_STATUS         VARCHAR(128)    NOT NULL     COMMENT '状態',
    APP_USER_ID        VARCHAR(64)                  COMMENT '申請者/承認者ユーザID',
    APP_ROLE_ID        VARCHAR(64)                  COMMENT '承認者ロールID',
    COMMENT            VARCHAR(128)					COMMENT 'コメント',
    DATE		       DATETIME                     COMMENT '処理日',
    PRIMARY KEY (APP_ID,APPROVE_ACCOUNT_ID)
) ENGINE=InnoDB;


# テーブル名：申請
# テーブルID：APPLICATION
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS APPLICATION (
    APP_ID      VARCHAR(128)    NOT NULL    PRIMARY KEY  	COMMENT '申請書番号',
    APPKIND_ID  VARCHAR(10) 	NOT NULL 					COMMENT '申請種別コード',
    USER_ID	    VARCHAR(20)     default NULL                COMMENT '申請者ユーザID',
    APP_DATE    DATE            default NULL                COMMENT '申請日'
 ) ENGINE=InnoDB;


# テーブル名：時間外申請
# テーブルID：OVERTIMEAPP
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS OVERTIMEAPP (
    APP_ID           VARCHAR(128)    NOT NULL    PRIMARY KEY  	COMMENT '申請書番号',
    WORKDAY          DATE                             		  	COMMENT '勤務日',
    START_TIME       TIME            NOT NULL          		  	COMMENT '開始予定時刻',
    END_TIME         TIME            NOT NULL         		  	COMMENT '終了予定時刻',
    OVERTIME_HOURS   FLOAT(4,1)                               	COMMENT '予定時間',
    COMP_DAY		 INTEGER(1)      default NULL             	COMMENT '代休取得予定',
    COMP_DAY_DATE    DATE      			  	  	              	COMMENT '代休取得日',
    REASON           VARCHAR(255)                     		  	COMMENT '事由',  
    REMARKS	         VARCHAR(255)							  	COMMENT '備考'
) ENGINE=InnoDB;
